/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.teiid.jboss.AddAnyAuthenticatedDataRole;
import org.teiid.jboss.AddDataRole;
import org.teiid.jboss.AssignDataSource;
import org.teiid.jboss.CacheStatistics;
import org.teiid.jboss.CacheTypes;
import org.teiid.jboss.CancelRequest;
import org.teiid.jboss.ChangeVDBConnectionType;
import org.teiid.jboss.ClearCache;
import org.teiid.jboss.Element;
import org.teiid.jboss.EngineStatistics;
import org.teiid.jboss.ExecuteQuery;
import org.teiid.jboss.GetActiveSessionsCount;
import org.teiid.jboss.GetPlan;
import org.teiid.jboss.GetRuntimeVersion;
import org.teiid.jboss.GetSchema;
import org.teiid.jboss.GetTranslator;
import org.teiid.jboss.GetVDB;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.JBossLogger;
import org.teiid.jboss.ListLongRunningRequests;
import org.teiid.jboss.ListRequests;
import org.teiid.jboss.ListRequestsPerSession;
import org.teiid.jboss.ListRequestsPerVDB;
import org.teiid.jboss.ListSessions;
import org.teiid.jboss.ListTransactions;
import org.teiid.jboss.ListTranslators;
import org.teiid.jboss.ListVDBs;
import org.teiid.jboss.MarkDataSourceAvailable;
import org.teiid.jboss.Namespace;
import org.teiid.jboss.ReadRARDescription;
import org.teiid.jboss.RemoveAnyAuthenticatedDataRole;
import org.teiid.jboss.RemoveDataRole;
import org.teiid.jboss.RestartVDB;
import org.teiid.jboss.TeiidAdd;
import org.teiid.jboss.TeiidSubsystemDescribe;
import org.teiid.jboss.TeiidSubsystemParser;
import org.teiid.jboss.TerminateSession;
import org.teiid.jboss.TerminateTransaction;
import org.teiid.jboss.TranslatorAdd;
import org.teiid.jboss.TranslatorRemove;
import org.teiid.jboss.TransportAdd;
import org.teiid.jboss.TransportRemove;
import org.teiid.jboss.WorkerPoolStatistics;
import org.teiid.logging.LogManager;
import org.teiid.logging.Logger;

public class TeiidExtension
implements Extension {
    private static final String ACTIVE_SESSION_COUNT = "active-session-count";
    private static final String RUNTIME_VERSION = "runtime-version";
    public static final String TEIID_SUBSYSTEM = "teiid";
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 0;
    private static TeiidSubsystemParser parser = new TeiidSubsystemParser();
    private static TransportAdd TRANSPORT_ADD = new TransportAdd();
    private static TransportRemove TRANSPORT_REMOVE = new TransportRemove();
    private static TranslatorAdd TRANSLATOR_ADD = new TranslatorAdd();
    private static TranslatorRemove TRANSLATOR_REMOVE = new TranslatorRemove();
    private static TeiidAdd TEIID_BOOT_ADD = new TeiidAdd();
    private static TeiidSubsystemDescribe TEIID_DESCRIBE = new TeiidSubsystemDescribe();

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(TEIID_SUBSYSTEM, 1, 0);
        LogManager.setLogListener((Logger)new JBossLogger());
        registration.registerXMLElementWriter((XMLElementWriter)parser);
        ManagementResourceRegistration teiidSubsystem = registration.registerSubsystemModel(new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                ResourceBundle bundle = IntegrationPlugin.getResourceBundle(locale);
                ModelNode node = new ModelNode();
                node.get("description").set("teiid subsystem");
                TeiidAdd.describeTeiid(node, "attributes", bundle);
                node.get(new String[]{"children", Element.TRANSPORT_ELEMENT.getLocalName(), "description"}).set(Element.TRANSPORT_ELEMENT.getDescription(bundle));
                node.get(new String[]{"children", Element.TRANSLATOR_ELEMENT.getLocalName(), "description"}).set(Element.TRANSLATOR_ELEMENT.getDescription(bundle));
                return node;
            }
        });
        teiidSubsystem.registerOperationHandler("add", (OperationStepHandler)TEIID_BOOT_ADD, (DescriptionProvider)TEIID_BOOT_ADD, false);
        teiidSubsystem.registerOperationHandler("describe", (OperationStepHandler)TEIID_DESCRIBE, (DescriptionProvider)TEIID_DESCRIBE, false);
        ManagementResourceRegistration translatorSubsystem = teiidSubsystem.registerSubModel(PathElement.pathElement((String)Element.TRANSLATOR_ELEMENT.getLocalName()), new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                ResourceBundle bundle = IntegrationPlugin.getResourceBundle(locale);
                ModelNode node = new ModelNode();
                node.get("description").set(Element.TRANSLATOR_ELEMENT.getDescription(bundle));
                Element.TRANSLATOR_MODULE_ATTRIBUTE.describe(node, "attributes", bundle);
                return node;
            }
        });
        translatorSubsystem.registerOperationHandler("add", (OperationStepHandler)TRANSLATOR_ADD, (DescriptionProvider)TRANSLATOR_ADD, false);
        translatorSubsystem.registerOperationHandler("remove", (OperationStepHandler)TRANSLATOR_REMOVE, (DescriptionProvider)TRANSLATOR_REMOVE, false);
        ManagementResourceRegistration transportModel = teiidSubsystem.registerSubModel(PathElement.pathElement((String)Element.TRANSPORT_ELEMENT.getLocalName()), new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                ResourceBundle bundle = IntegrationPlugin.getResourceBundle(locale);
                ModelNode node = new ModelNode();
                node.get("description").set(Element.TRANSPORT_ELEMENT.getDescription(bundle));
                TransportAdd.transportDescribe(node, "attributes", bundle);
                return node;
            }
        });
        transportModel.registerOperationHandler("add", (OperationStepHandler)TRANSPORT_ADD, (DescriptionProvider)TRANSPORT_ADD, false);
        transportModel.registerOperationHandler("remove", (OperationStepHandler)TRANSPORT_REMOVE, (DescriptionProvider)TRANSPORT_REMOVE, false);
        teiidSubsystem.registerReadOnlyAttribute(RUNTIME_VERSION, (OperationStepHandler)new GetRuntimeVersion(RUNTIME_VERSION), AttributeAccess.Storage.RUNTIME);
        teiidSubsystem.registerReadOnlyAttribute(ACTIVE_SESSION_COUNT, (OperationStepHandler)new GetActiveSessionsCount(ACTIVE_SESSION_COUNT), AttributeAccess.Storage.RUNTIME);
        TeiidAdd.registerReadWriteAttributes(teiidSubsystem);
        TransportAdd.registerReadWriteAttributes(transportModel);
        new GetTranslator().register(teiidSubsystem);
        new ListTranslators().register(teiidSubsystem);
        new ListVDBs().register(teiidSubsystem);
        new GetVDB().register(teiidSubsystem);
        new CacheTypes().register(teiidSubsystem);
        new ClearCache().register(teiidSubsystem);
        new CacheStatistics().register(teiidSubsystem);
        new AddDataRole().register(teiidSubsystem);
        new RemoveDataRole().register(teiidSubsystem);
        new AddAnyAuthenticatedDataRole().register(teiidSubsystem);
        new RestartVDB().register(teiidSubsystem);
        new AssignDataSource().register(teiidSubsystem);
        new ChangeVDBConnectionType().register(teiidSubsystem);
        new RemoveAnyAuthenticatedDataRole().register(teiidSubsystem);
        new ListRequests().register(teiidSubsystem);
        new ListSessions().register(teiidSubsystem);
        new ListRequestsPerSession().register(teiidSubsystem);
        new ListRequestsPerVDB().register(teiidSubsystem);
        new ListLongRunningRequests().register(teiidSubsystem);
        new TerminateSession().register(teiidSubsystem);
        new CancelRequest().register(teiidSubsystem);
        new GetPlan().register(teiidSubsystem);
        new WorkerPoolStatistics().register(teiidSubsystem);
        new ListTransactions().register(teiidSubsystem);
        new TerminateTransaction().register(teiidSubsystem);
        new ExecuteQuery().register(teiidSubsystem);
        new MarkDataSourceAvailable().register(teiidSubsystem);
        new ReadRARDescription().register(teiidSubsystem);
        new GetSchema().register(teiidSubsystem);
        new EngineStatistics().register(teiidSubsystem);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(TEIID_SUBSYSTEM, Namespace.CURRENT.getUri(), (XMLElementReader)parser);
    }
}

