/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkManager;
import javax.transaction.TransactionManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.RelativePathService;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.teiid.PolicyDecider;
import org.teiid.cache.CacheFactory;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBufferCache;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.VDBRepository;
import org.teiid.deployers.VDBStatusChecker;
import org.teiid.dqp.internal.datamgr.TranslatorRepository;
import org.teiid.dqp.internal.process.AuthorizationValidator;
import org.teiid.dqp.internal.process.DefaultAuthorizationValidator;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.events.EventDistributorFactory;
import org.teiid.jboss.BufferManagerService;
import org.teiid.jboss.CacheFactoryService;
import org.teiid.jboss.CacheService;
import org.teiid.jboss.DQPCoreService;
import org.teiid.jboss.DynamicVDBRootMountDeployer;
import org.teiid.jboss.EventDistributorFactoryService;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.JBossLifeCycleListener;
import org.teiid.jboss.JGroupsObjectReplicatorService;
import org.teiid.jboss.ObjectsSerializerService;
import org.teiid.jboss.ReferenceFactoryService;
import org.teiid.jboss.TeiidConstants;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.jboss.TranslatorDependencyDeployer;
import org.teiid.jboss.TranslatorDeployer;
import org.teiid.jboss.TranslatorStructureDeployer;
import org.teiid.jboss.TupleBufferCacheService;
import org.teiid.jboss.VDBDependencyDeployer;
import org.teiid.jboss.VDBDeployer;
import org.teiid.jboss.VDBParserDeployer;
import org.teiid.jboss.VDBRepositoryService;
import org.teiid.jboss.VDBStructureDeployer;
import org.teiid.logging.LogManager;
import org.teiid.query.ObjectReplicator;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.services.InternalEventDistributorFactory;

class TeiidAdd
extends AbstractAddStepHandler {
    public static TeiidAdd INSTANCE = new TeiidAdd();
    static TeiidConstants.TeiidAttribute[] ATTRIBUTES = new TeiidConstants.TeiidAttribute[]{TeiidConstants.ALLOW_ENV_FUNCTION_ELEMENT, TeiidConstants.ASYNC_THREAD_POOL_ELEMENT, TeiidConstants.MAX_THREADS_ELEMENT, TeiidConstants.MAX_ACTIVE_PLANS_ELEMENT, TeiidConstants.USER_REQUEST_SOURCE_CONCURRENCY_ELEMENT, TeiidConstants.TIME_SLICE_IN_MILLI_ELEMENT, TeiidConstants.MAX_ROWS_FETCH_SIZE_ELEMENT, TeiidConstants.LOB_CHUNK_SIZE_IN_KB_ELEMENT, TeiidConstants.QUERY_THRESHOLD_IN_SECS_ELEMENT, TeiidConstants.MAX_SOURCE_ROWS_ELEMENT, TeiidConstants.EXCEPTION_ON_MAX_SOURCE_ROWS_ELEMENT, TeiidConstants.DETECTING_CHANGE_EVENTS_ELEMENT, TeiidConstants.QUERY_TIMEOUT, TeiidConstants.WORKMANAGER, TeiidConstants.AUTHORIZATION_VALIDATOR_MODULE_ELEMENT, TeiidConstants.POLICY_DECIDER_MODULE_ELEMENT, TeiidConstants.DC_STACK_ATTRIBUTE, TeiidConstants.USE_DISK_ATTRIBUTE, TeiidConstants.INLINE_LOBS, TeiidConstants.PROCESSOR_BATCH_SIZE_ATTRIBUTE, TeiidConstants.MAX_PROCESSING_KB_ATTRIBUTE, TeiidConstants.MAX_RESERVED_KB_ATTRIBUTE, TeiidConstants.MAX_FILE_SIZE_ATTRIBUTE, TeiidConstants.MAX_BUFFER_SPACE_ATTRIBUTE, TeiidConstants.MAX_OPEN_FILES_ATTRIBUTE, TeiidConstants.MEMORY_BUFFER_SPACE_ATTRIBUTE, TeiidConstants.MEMORY_BUFFER_OFFHEAP_ATTRIBUTE, TeiidConstants.MAX_STORAGE_OBJECT_SIZE_ATTRIBUTE, TeiidConstants.PPC_NAME_ATTRIBUTE, TeiidConstants.PPC_CONTAINER_NAME_ATTRIBUTE, TeiidConstants.PPC_ENABLE_ATTRIBUTE, TeiidConstants.RSC_NAME_ATTRIBUTE, TeiidConstants.RSC_CONTAINER_NAME_ATTRIBUTE, TeiidConstants.RSC_MAX_STALENESS_ATTRIBUTE, TeiidConstants.RSC_ENABLE_ATTRIBUTE};

    TeiidAdd() {
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        resource.getModel().setEmptyObject();
        TeiidAdd.populate(operation, resource.getModel());
        if (context.isNormalServer()) {
            this.deployResources(context);
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        throw new UnsupportedOperationException();
    }

    static void populate(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (int i = 0; i < ATTRIBUTES.length; ++i) {
            ATTRIBUTES[i].validateAndSet(operation, model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                classloader = Module.getCallerModule().getClassLoader();
            }
            catch (Throwable t) {
                // empty catch block
            }
            Thread.currentThread().setContextClassLoader(classloader);
            this.initilaizeTeiidEngine(context, operation, newControllers);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classloader);
        }
    }

    private void initilaizeTeiidEngine(OperationContext context, ModelNode operation, List<ServiceController<?>> newControllers) throws OperationFailedException {
        AuthorizationValidator authValidator;
        ServiceTarget target = context.getServiceTarget();
        final JBossLifeCycleListener shutdownListener = new JBossLifeCycleListener();
        final String asyncThreadPoolName = TeiidConstants.ASYNC_THREAD_POOL_ELEMENT.asString(operation, context);
        final TranslatorRepository translatorRepo = new TranslatorRepository();
        ValueService translatorService = new ValueService((Value)new Value<TranslatorRepository>(){

            public TranslatorRepository getValue() throws IllegalStateException, IllegalArgumentException {
                return translatorRepo;
            }
        });
        ServiceController service = target.addService(TeiidServiceNames.TRANSLATOR_REPO, (Service)translatorService).install();
        newControllers.add(service);
        SystemFunctionManager systemFunctionManager = new SystemFunctionManager();
        if (TeiidConstants.ALLOW_ENV_FUNCTION_ELEMENT.isDefined(operation, context)) {
            systemFunctionManager.setAllowEnvFunction(TeiidConstants.ALLOW_ENV_FUNCTION_ELEMENT.asBoolean(operation, context).booleanValue());
        } else {
            systemFunctionManager.setAllowEnvFunction(false);
        }
        systemFunctionManager.setClassloader(Thread.currentThread().getContextClassLoader());
        final VDBRepository vdbRepository = new VDBRepository();
        vdbRepository.setSystemFunctionManager(systemFunctionManager);
        VDBRepositoryService vdbRepositoryService = new VDBRepositoryService(vdbRepository);
        newControllers.add(target.addService(TeiidServiceNames.VDB_REPO, (Service)vdbRepositoryService).install());
        final VDBStatusCheckerExecutorService statusChecker = new VDBStatusCheckerExecutorService();
        statusChecker.setTranslatorRepository(translatorRepo);
        ValueService statusService = new ValueService((Value)new Value<VDBStatusChecker>(){

            public VDBStatusChecker getValue() throws IllegalStateException, IllegalArgumentException {
                return statusChecker;
            }
        });
        ServiceBuilder statusBuilder = target.addService(TeiidServiceNames.VDB_STATUS_CHECKER, (Service)statusService);
        statusBuilder.addDependency(TeiidServiceNames.executorServiceName(asyncThreadPoolName), Executor.class, statusChecker.executorInjector);
        statusBuilder.addDependency(TeiidServiceNames.VDB_REPO, VDBRepository.class, statusChecker.vdbRepoInjector);
        newControllers.add(statusBuilder.install());
        newControllers.add(RelativePathService.addService((ServiceName)TeiidServiceNames.DATA_DIR, (String)"teiid-data", (String)"jboss.server.data.dir", (ServiceTarget)target));
        ObjectsSerializerService serializer = new ObjectsSerializerService();
        ServiceBuilder objectSerializerService = target.addService(TeiidServiceNames.OBJECT_SERIALIZER, (Service)serializer);
        objectSerializerService.addDependency(TeiidServiceNames.DATA_DIR, String.class, serializer.getPathInjector());
        newControllers.add(objectSerializerService.install());
        boolean replicatorAvailable = false;
        if (TeiidConstants.DC_STACK_ATTRIBUTE.isDefined(operation, context)) {
            String stack = TeiidConstants.DC_STACK_ATTRIBUTE.asString(operation, context);
            replicatorAvailable = true;
            JGroupsObjectReplicatorService replicatorService = new JGroupsObjectReplicatorService();
            ServiceBuilder serviceBuilder = target.addService(TeiidServiceNames.OBJECT_REPLICATOR, (Service)replicatorService);
            serviceBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"jgroups", "stack", stack}), ChannelFactory.class, replicatorService.channelFactoryInjector);
            serviceBuilder.addDependency(TeiidServiceNames.executorServiceName(asyncThreadPoolName), Executor.class, replicatorService.executorInjector);
            newControllers.add(serviceBuilder.install());
            LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50003, new Object[0]));
        } else {
            LogManager.logDetail((String)"org.teiid.RUNTIME", (Object[])new Object[]{IntegrationPlugin.Util.getString("distributed_cache_not_enabled")});
        }
        newControllers.add(RelativePathService.addService((ServiceName)TeiidServiceNames.BUFFER_DIR, (String)"teiid-buffer", (String)"jboss.server.temp.dir", (ServiceTarget)target));
        BufferManagerService bufferService = this.buildBufferManager(context, operation);
        ServiceBuilder bufferServiceBuilder = target.addService(TeiidServiceNames.BUFFER_MGR, (Service)bufferService);
        bufferServiceBuilder.addDependency(TeiidServiceNames.BUFFER_DIR, String.class, bufferService.pathInjector);
        newControllers.add(bufferServiceBuilder.install());
        TupleBufferCacheService tupleBufferService = new TupleBufferCacheService();
        ServiceBuilder tupleBufferBuilder = target.addService(TeiidServiceNames.TUPLE_BUFFER, (Service)tupleBufferService);
        tupleBufferBuilder.addDependency(TeiidServiceNames.BUFFER_MGR, BufferManager.class, tupleBufferService.bufferMgrInjector);
        tupleBufferBuilder.addDependency(replicatorAvailable ? ServiceBuilder.DependencyType.REQUIRED : ServiceBuilder.DependencyType.OPTIONAL, TeiidServiceNames.OBJECT_REPLICATOR, ObjectReplicator.class, tupleBufferService.replicatorInjector);
        newControllers.add(tupleBufferBuilder.install());
        EventDistributorFactoryService edfs = new EventDistributorFactoryService();
        ServiceBuilder edfsServiceBuilder = target.addService(TeiidServiceNames.EVENT_DISTRIBUTOR_FACTORY, (Service)edfs);
        edfsServiceBuilder.addDependency(TeiidServiceNames.VDB_REPO, VDBRepository.class, edfs.vdbRepositoryInjector);
        edfsServiceBuilder.addDependency(replicatorAvailable ? ServiceBuilder.DependencyType.REQUIRED : ServiceBuilder.DependencyType.OPTIONAL, TeiidServiceNames.OBJECT_REPLICATOR, ObjectReplicator.class, edfs.objectReplicatorInjector);
        newControllers.add(edfsServiceBuilder.install());
        PolicyDecider policyDecider = null;
        if (TeiidConstants.POLICY_DECIDER_MODULE_ELEMENT.isDefined(operation, context)) {
            policyDecider = this.buildService(PolicyDecider.class, TeiidConstants.POLICY_DECIDER_MODULE_ELEMENT.asString(operation, context));
        }
        if (TeiidConstants.AUTHORIZATION_VALIDATOR_MODULE_ELEMENT.isDefined(operation, context)) {
            authValidator = this.buildService(AuthorizationValidator.class, TeiidConstants.AUTHORIZATION_VALIDATOR_MODULE_ELEMENT.asString(operation, context));
        } else {
            DefaultAuthorizationValidator dap = new DefaultAuthorizationValidator();
            dap.setPolicyDecider(policyDecider);
            authValidator = dap;
        }
        ValueService authValidatorService = new ValueService((Value)new Value<AuthorizationValidator>(){

            public AuthorizationValidator getValue() throws IllegalStateException, IllegalArgumentException {
                return authValidator;
            }
        });
        newControllers.add(target.addService(TeiidServiceNames.AUTHORIZATION_VALIDATOR, (Service)authValidatorService).install());
        boolean rsCache = true;
        if (TeiidConstants.RSC_ENABLE_ATTRIBUTE.isDefined(operation, context) && !TeiidConstants.RSC_ENABLE_ATTRIBUTE.asBoolean(operation, context).booleanValue()) {
            rsCache = false;
        }
        if (!TeiidConstants.RSC_CONTAINER_NAME_ATTRIBUTE.isDefined(operation, context)) {
            throw new OperationFailedException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50094, new Object[0]));
        }
        String cacheName = "resultset";
        if (TeiidConstants.RSC_NAME_ATTRIBUTE.isDefined(operation, context)) {
            cacheName = TeiidConstants.RSC_NAME_ATTRIBUTE.asString(operation, context);
        }
        if (rsCache) {
            CacheFactoryService cfs = new CacheFactoryService();
            ServiceBuilder cacheFactoryBuilder = target.addService(TeiidServiceNames.RESULTSET_CACHE_FACTORY, (Service)cfs);
            String ispnName = TeiidConstants.RSC_CONTAINER_NAME_ATTRIBUTE.asString(operation, context);
            cacheFactoryBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"infinispan", ispnName}), EmbeddedCacheManager.class, cfs.cacheContainerInjector);
            newControllers.add(cacheFactoryBuilder.install());
            int maxStaleness = 60;
            if (TeiidConstants.RSC_MAX_STALENESS_ATTRIBUTE.isDefined(operation, context)) {
                maxStaleness = TeiidConstants.RSC_MAX_STALENESS_ATTRIBUTE.asInt(operation, context);
            }
            CacheService resultSetService = new CacheService(cacheName, SessionAwareCache.Type.RESULTSET, maxStaleness);
            ServiceBuilder resultsCacheBuilder = target.addService(TeiidServiceNames.CACHE_RESULTSET, resultSetService);
            resultsCacheBuilder.addDependency(TeiidServiceNames.TUPLE_BUFFER, TupleBufferCache.class, resultSetService.tupleBufferCacheInjector);
            resultsCacheBuilder.addDependency(TeiidServiceNames.RESULTSET_CACHE_FACTORY, CacheFactory.class, resultSetService.cacheFactoryInjector);
            resultsCacheBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"infinispan", ispnName, cacheName}));
            resultsCacheBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"infinispan", ispnName, cacheName + "-repl"}));
            newControllers.add(resultsCacheBuilder.install());
        }
        boolean ppCache = true;
        if (TeiidConstants.PPC_ENABLE_ATTRIBUTE.isDefined(operation, context)) {
            ppCache = TeiidConstants.PPC_ENABLE_ATTRIBUTE.asBoolean(operation, context);
        }
        if (!TeiidConstants.PPC_CONTAINER_NAME_ATTRIBUTE.isDefined(operation, context)) {
            throw new OperationFailedException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50095, new Object[0]));
        }
        cacheName = "preparedplan";
        if (TeiidConstants.PPC_NAME_ATTRIBUTE.isDefined(operation, context)) {
            cacheName = TeiidConstants.PPC_NAME_ATTRIBUTE.asString(operation, context);
        }
        if (ppCache) {
            CacheFactoryService cfs = new CacheFactoryService();
            ServiceBuilder cacheFactoryBuilder = target.addService(TeiidServiceNames.PREPAREDPLAN_CACHE_FACTORY, (Service)cfs);
            String ispnName = TeiidConstants.PPC_CONTAINER_NAME_ATTRIBUTE.asString(operation, context);
            cacheFactoryBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"infinispan", ispnName}), EmbeddedCacheManager.class, cfs.cacheContainerInjector);
            newControllers.add(cacheFactoryBuilder.install());
            CacheService preparedPlanService = new CacheService(cacheName, SessionAwareCache.Type.PREPAREDPLAN, 0);
            ServiceBuilder preparedPlanCacheBuilder = target.addService(TeiidServiceNames.CACHE_PREPAREDPLAN, preparedPlanService);
            preparedPlanCacheBuilder.addDependency(TeiidServiceNames.PREPAREDPLAN_CACHE_FACTORY, CacheFactory.class, preparedPlanService.cacheFactoryInjector);
            preparedPlanCacheBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"infinispan", ispnName, cacheName}));
            newControllers.add(preparedPlanCacheBuilder.install());
        }
        DQPCoreService engine = this.buildQueryEngine(context, operation);
        String workManager = "default";
        if (TeiidConstants.WORKMANAGER.isDefined(operation, context)) {
            workManager = TeiidConstants.WORKMANAGER.asString(operation, context);
        }
        ServiceBuilder engineBuilder = target.addService(TeiidServiceNames.ENGINE, (Service)engine);
        engineBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"connector", "workmanager", workManager}), WorkManager.class, engine.getWorkManagerInjector());
        engineBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"txn", "XATerminator"}), XATerminator.class, engine.getXaTerminatorInjector());
        engineBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"txn", "TransactionManager"}), TransactionManager.class, engine.getTxnManagerInjector());
        engineBuilder.addDependency(TeiidServiceNames.BUFFER_MGR, BufferManager.class, engine.getBufferManagerInjector());
        engineBuilder.addDependency(TeiidServiceNames.TRANSLATOR_REPO, TranslatorRepository.class, engine.getTranslatorRepositoryInjector());
        engineBuilder.addDependency(TeiidServiceNames.VDB_REPO, VDBRepository.class, engine.getVdbRepositoryInjector());
        engineBuilder.addDependency(TeiidServiceNames.AUTHORIZATION_VALIDATOR, AuthorizationValidator.class, engine.getAuthorizationValidatorInjector());
        engineBuilder.addDependency(rsCache ? ServiceBuilder.DependencyType.REQUIRED : ServiceBuilder.DependencyType.OPTIONAL, TeiidServiceNames.CACHE_RESULTSET, SessionAwareCache.class, engine.getResultSetCacheInjector());
        engineBuilder.addDependency(TeiidServiceNames.CACHE_PREPAREDPLAN, SessionAwareCache.class, engine.getPreparedPlanCacheInjector());
        engineBuilder.addDependency(TeiidServiceNames.EVENT_DISTRIBUTOR_FACTORY, InternalEventDistributorFactory.class, engine.getEventDistributorFactoryInjector());
        engineBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ServiceController controller = engineBuilder.install();
        newControllers.add(controller);
        ServiceContainer container = controller.getServiceContainer();
        container.addTerminateListener((ServiceContainer.TerminateListener)shutdownListener);
        container.getService(Services.JBOSS_SERVER_CONTROLLER).addListener((ServiceListener)shutdownListener);
        ReferenceFactoryService referenceFactoryService = new ReferenceFactoryService();
        ServiceName referenceFactoryServiceName = TeiidServiceNames.EVENT_DISTRIBUTOR_FACTORY.append(new String[]{"reference-factory"});
        ServiceBuilder referenceBuilder = target.addService(referenceFactoryServiceName, referenceFactoryService);
        referenceBuilder.addDependency(TeiidServiceNames.EVENT_DISTRIBUTOR_FACTORY, EventDistributorFactory.class, referenceFactoryService.getInjector());
        referenceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        String jndiName = "teiid/event-distributor-factory";
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binderService = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = target.addService(bindInfo.getBinderServiceName(), (Service)binderService);
        binderBuilder.addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, binderService.getManagedObjectInjector());
        binderBuilder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector());
        binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        newControllers.add(referenceBuilder.install());
        newControllers.add(binderBuilder.install());
        LogManager.logDetail((String)"org.teiid.RUNTIME", (Object[])new Object[]{IntegrationPlugin.Util.getString("event_distributor_bound", new Object[]{jndiName})});
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("teiid", Phase.STRUCTURE, 2048, (DeploymentUnitProcessor)new DynamicVDBRootMountDeployer());
                processorTarget.addDeploymentProcessor("teiid", Phase.STRUCTURE, 2049, (DeploymentUnitProcessor)new VDBStructureDeployer());
                processorTarget.addDeploymentProcessor("teiid", Phase.PARSE, 2817, (DeploymentUnitProcessor)new VDBParserDeployer());
                processorTarget.addDeploymentProcessor("teiid", Phase.DEPENDENCIES, 1793, (DeploymentUnitProcessor)new VDBDependencyDeployer());
                processorTarget.addDeploymentProcessor("teiid", Phase.INSTALL, 7424, (DeploymentUnitProcessor)new VDBDeployer(translatorRepo, asyncThreadPoolName, vdbRepository, shutdownListener));
                processorTarget.addDeploymentProcessor("teiid", Phase.STRUCTURE, 1537, (DeploymentUnitProcessor)new TranslatorStructureDeployer());
                processorTarget.addDeploymentProcessor("teiid", Phase.DEPENDENCIES, 769, (DeploymentUnitProcessor)new TranslatorDependencyDeployer());
                processorTarget.addDeploymentProcessor("teiid", Phase.INSTALL, 6145, (DeploymentUnitProcessor)new TranslatorDeployer());
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private <T> T buildService(Class<T> type, String moduleName) throws OperationFailedException {
        Module module;
        try {
            ModuleIdentifier moduleId = ModuleIdentifier.create((String)moduleName);
            module = Module.getCallerModuleLoader().loadModule(moduleId);
        }
        catch (ModuleLoadException e) {
            throw new OperationFailedException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50069, new Object[]{moduleName}), (Throwable)e);
        }
        ServiceLoader services = module.loadService(type);
        Iterator iter = services.iterator();
        if (!iter.hasNext()) {
            throw new OperationFailedException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50089, new Object[]{type.getName(), moduleName}));
        }
        return (T)iter.next();
    }

    private BufferManagerService buildBufferManager(OperationContext context, ModelNode node) throws OperationFailedException {
        BufferManagerService bufferManger = new BufferManagerService();
        if (node == null) {
            return bufferManger;
        }
        if (TeiidConstants.USE_DISK_ATTRIBUTE.isDefined(node, context)) {
            bufferManger.setUseDisk(TeiidConstants.USE_DISK_ATTRIBUTE.asBoolean(node, context));
        }
        if (TeiidConstants.PROCESSOR_BATCH_SIZE_ATTRIBUTE.isDefined(node, context)) {
            bufferManger.setProcessorBatchSize(TeiidConstants.PROCESSOR_BATCH_SIZE_ATTRIBUTE.asInt(node, context));
        }
        if (TeiidConstants.MAX_PROCESSING_KB_ATTRIBUTE.isDefined(node, context)) {
            bufferManger.setMaxProcessingKb(TeiidConstants.MAX_PROCESSING_KB_ATTRIBUTE.asInt(node, context));
        }
        if (TeiidConstants.MAX_RESERVED_KB_ATTRIBUTE.isDefined(node, context)) {
            bufferManger.setMaxReserveKb(TeiidConstants.MAX_RESERVED_KB_ATTRIBUTE.asInt(node, context));
        }
        if (TeiidConstants.MAX_FILE_SIZE_ATTRIBUTE.isDefined(node, context)) {
            bufferManger.setMaxFileSize(TeiidConstants.MAX_FILE_SIZE_ATTRIBUTE.asLong(node, context));
        }
        if (TeiidConstants.MAX_BUFFER_SPACE_ATTRIBUTE.isDefined(node, context)) {
            bufferManger.setMaxBufferSpace(TeiidConstants.MAX_BUFFER_SPACE_ATTRIBUTE.asLong(node, context));
        }
        if (TeiidConstants.MAX_OPEN_FILES_ATTRIBUTE.isDefined(node, context)) {
            bufferManger.setMaxOpenFiles(TeiidConstants.MAX_OPEN_FILES_ATTRIBUTE.asInt(node, context));
        }
        if (TeiidConstants.MEMORY_BUFFER_SPACE_ATTRIBUTE.isDefined(node, context)) {
            bufferManger.setMemoryBufferSpace(TeiidConstants.MEMORY_BUFFER_SPACE_ATTRIBUTE.asInt(node, context));
        }
        if (TeiidConstants.MEMORY_BUFFER_OFFHEAP_ATTRIBUTE.isDefined(node, context)) {
            bufferManger.setMemoryBufferOffHeap(TeiidConstants.MEMORY_BUFFER_OFFHEAP_ATTRIBUTE.asBoolean(node, context));
        }
        if (TeiidConstants.MAX_STORAGE_OBJECT_SIZE_ATTRIBUTE.isDefined(node, context)) {
            bufferManger.setMaxStorageObjectSize(TeiidConstants.MAX_STORAGE_OBJECT_SIZE_ATTRIBUTE.asInt(node, context));
        }
        if (TeiidConstants.INLINE_LOBS.isDefined(node, context)) {
            bufferManger.setInlineLobs(TeiidConstants.INLINE_LOBS.asBoolean(node, context));
        }
        return bufferManger;
    }

    private DQPCoreService buildQueryEngine(OperationContext context, ModelNode node) throws OperationFailedException {
        DQPCoreService engine = new DQPCoreService();
        if (TeiidConstants.MAX_THREADS_ELEMENT.isDefined(node, context)) {
            engine.setMaxThreads(TeiidConstants.MAX_THREADS_ELEMENT.asInt(node, context));
        }
        if (TeiidConstants.MAX_ACTIVE_PLANS_ELEMENT.isDefined(node, context)) {
            engine.setMaxActivePlans(TeiidConstants.MAX_ACTIVE_PLANS_ELEMENT.asInt(node, context));
        }
        if (TeiidConstants.USER_REQUEST_SOURCE_CONCURRENCY_ELEMENT.isDefined(node, context)) {
            engine.setUserRequestSourceConcurrency(TeiidConstants.USER_REQUEST_SOURCE_CONCURRENCY_ELEMENT.asInt(node, context));
        }
        if (TeiidConstants.TIME_SLICE_IN_MILLI_ELEMENT.isDefined(node, context)) {
            engine.setTimeSliceInMilli(TeiidConstants.TIME_SLICE_IN_MILLI_ELEMENT.asInt(node, context));
        }
        if (TeiidConstants.MAX_ROWS_FETCH_SIZE_ELEMENT.isDefined(node, context)) {
            engine.setMaxRowsFetchSize(TeiidConstants.MAX_ROWS_FETCH_SIZE_ELEMENT.asInt(node, context));
        }
        if (TeiidConstants.LOB_CHUNK_SIZE_IN_KB_ELEMENT.isDefined(node, context)) {
            engine.setLobChunkSizeInKB(TeiidConstants.LOB_CHUNK_SIZE_IN_KB_ELEMENT.asInt(node, context));
        }
        if (TeiidConstants.QUERY_THRESHOLD_IN_SECS_ELEMENT.isDefined(node, context)) {
            engine.setQueryThresholdInSecs(TeiidConstants.QUERY_THRESHOLD_IN_SECS_ELEMENT.asInt(node, context));
        }
        if (TeiidConstants.MAX_SOURCE_ROWS_ELEMENT.isDefined(node, context)) {
            engine.setMaxSourceRows(TeiidConstants.MAX_SOURCE_ROWS_ELEMENT.asInt(node, context));
        }
        if (TeiidConstants.EXCEPTION_ON_MAX_SOURCE_ROWS_ELEMENT.isDefined(node, context)) {
            engine.setExceptionOnMaxSourceRows(TeiidConstants.EXCEPTION_ON_MAX_SOURCE_ROWS_ELEMENT.asBoolean(node, context));
        }
        if (TeiidConstants.DETECTING_CHANGE_EVENTS_ELEMENT.isDefined(node, context)) {
            engine.setDetectingChangeEvents(TeiidConstants.DETECTING_CHANGE_EVENTS_ELEMENT.asBoolean(node, context));
        }
        if (TeiidConstants.QUERY_TIMEOUT.isDefined(node, context)) {
            engine.setQueryTimeout(TeiidConstants.QUERY_TIMEOUT.asLong(node, context));
        }
        return engine;
    }

    private void deployResources(OperationContext context) throws OperationFailedException {
        if (this.requiresRuntime(context)) {
            try {
                String deployment;
                Module module = Module.forClass(((Object)((Object)this)).getClass());
                if (module == null) {
                    return;
                }
                URL deployments = module.getExportedResource("deployments.properties");
                if (deployments == null) {
                    return;
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(deployments.openStream()));
                while ((deployment = in.readLine()) != null) {
                    PathAddress deploymentAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment", (String)deployment)});
                    ModelNode op = new ModelNode();
                    op.get("operation").set("add");
                    op.get("address").set(deploymentAddress.toModelNode());
                    op.get("enabled").set(true);
                    op.get("persistent").set(false);
                    URL url = module.getExportedResource(deployment);
                    String urlString = url.toExternalForm();
                    ModelNode contentItem = new ModelNode();
                    contentItem.get("url").set(urlString);
                    op.get("content").add(contentItem);
                    ImmutableManagementResourceRegistration rootResourceRegistration = context.getRootResourceRegistration();
                    OperationStepHandler handler = rootResourceRegistration.getOperationHandler(deploymentAddress, "add");
                    context.addStep(op, handler, OperationContext.Stage.MODEL);
                }
                in.close();
            }
            catch (IOException e) {
                throw new OperationFailedException(e.getMessage(), (Throwable)e);
            }
        }
    }

    static class VDBStatusCheckerExecutorService
    extends VDBStatusChecker {
        final InjectedValue<Executor> executorInjector = new InjectedValue();
        final InjectedValue<VDBRepository> vdbRepoInjector = new InjectedValue();

        VDBStatusCheckerExecutorService() {
        }

        public Executor getExecutor() {
            return (Executor)this.executorInjector.getValue();
        }

        public VDBRepository getVDBRepository() {
            return (VDBRepository)this.vdbRepoInjector.getValue();
        }
    }
}

