/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.RuntimeVDB;
import org.teiid.jboss.BaseOperationHandler;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.OperationsConstants;
import org.teiid.jboss.TeiidServiceNames;

abstract class VDBOperations
extends BaseOperationHandler<RuntimeVDB> {
    public VDBOperations(String operationName) {
        super(operationName);
    }

    @Override
    public RuntimeVDB getService(OperationContext context, PathAddress pathAddress, ModelNode operation) throws OperationFailedException {
        int vdbVersion;
        if (!operation.hasDefined(OperationsConstants.VDB_NAME.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.VDB_NAME.getName() + ".missing")));
        }
        if (!operation.hasDefined(OperationsConstants.VDB_VERSION.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.VDB_VERSION.getName() + ".missing")));
        }
        String vdbName = operation.get(OperationsConstants.VDB_NAME.getName()).asString();
        if (!this.isValidVDB(context, vdbName, vdbVersion = operation.get(OperationsConstants.VDB_VERSION.getName()).asInt())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50096, new Object[]{vdbName, vdbVersion})));
        }
        ServiceController sc = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.vdbServiceName(vdbName, vdbVersion));
        return (RuntimeVDB)RuntimeVDB.class.cast(sc.getValue());
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        builder.addParameter((AttributeDefinition)OperationsConstants.VDB_NAME);
        builder.addParameter((AttributeDefinition)OperationsConstants.VDB_VERSION);
    }
}

