/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.RequestMessage;
import org.teiid.client.ResultsMessage;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.BundleUtil;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.OperationsConstants;
import org.teiid.jboss.TeiidOperationHandler;
import org.teiid.logging.LogManager;
import org.teiid.query.tempdata.TempTableDataManager;

class ExecuteQuery
extends TeiidOperationHandler {
    protected ExecuteQuery() {
        super("execute-query");
    }

    @Override
    protected void executeOperation(OperationContext context, DQPCore engine, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined(OperationsConstants.VDB_NAME.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.VDB_NAME.getName() + ".missing")));
        }
        if (!operation.hasDefined(OperationsConstants.VDB_VERSION.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.VDB_VERSION.getName() + ".missing")));
        }
        if (!operation.hasDefined(OperationsConstants.SQL_QUERY.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.SQL_QUERY.getName() + ".missing")));
        }
        if (!operation.hasDefined(OperationsConstants.TIMEOUT_IN_MILLI.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.TIMEOUT_IN_MILLI.getName() + ".missing")));
        }
        ModelNode result = context.getResult();
        String vdbName = operation.get(OperationsConstants.VDB_NAME.getName()).asString();
        int vdbVersion = operation.get(OperationsConstants.VDB_VERSION.getName()).asInt();
        String sql = operation.get(OperationsConstants.SQL_QUERY.getName()).asString();
        int timeout = operation.get(OperationsConstants.TIMEOUT_IN_MILLI.getName()).asInt();
        if (!this.isValidVDB(context, vdbName, vdbVersion)) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50096, new Object[]{vdbName, vdbVersion})));
        }
        result.set(this.executeQuery(context, engine, vdbName, vdbVersion, sql, timeout, new ModelNode()));
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        builder.addParameter((AttributeDefinition)OperationsConstants.VDB_NAME);
        builder.addParameter((AttributeDefinition)OperationsConstants.VDB_VERSION);
        builder.addParameter((AttributeDefinition)OperationsConstants.SQL_QUERY);
        builder.addParameter((AttributeDefinition)OperationsConstants.TIMEOUT_IN_MILLI);
        builder.setReplyType(ModelType.LIST);
        builder.setReplyValueType(ModelType.STRING);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModelNode executeQuery(OperationContext context, final DQPCore engine, String vdbName, int version, final String command, final long timoutInMilli, final ModelNode resultsNode) throws OperationFailedException {
        ModelNode modelNode;
        String user = "CLI ADMIN";
        LogManager.logDetail((String)"org.teiid.RUNTIME", (Object[])new Object[]{IntegrationPlugin.Util.getString("admin_executing", new Object[]{user, command})});
        VDBMetaData vdb = this.getVDBrepository(context).getLiveVDB(vdbName, version);
        if (vdb == null) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("wrong_vdb")));
        }
        SessionMetadata session = TempTableDataManager.createTemporarySession((String)user, (String)"admin-console", (VDBMetaData)vdb);
        long requestID = 0L;
        DQPWorkContext workContext = new DQPWorkContext();
        workContext.setUseCallingThread(true);
        workContext.setSession(session);
        try {
            modelNode = (ModelNode)workContext.runInContext((Callable)new Callable<ModelNode>(){

                @Override
                public ModelNode call() throws Exception {
                    long elapsed;
                    long start = System.currentTimeMillis();
                    RequestMessage request = new RequestMessage(command);
                    request.setExecutionId(0L);
                    request.setRowLimit(engine.getMaxRowsFetchSize());
                    ResultsFuture message = engine.executeRequest(0L, request);
                    ResultsMessage rm = null;
                    rm = timoutInMilli < 0L ? (ResultsMessage)message.get() : (ResultsMessage)message.get(timoutInMilli, TimeUnit.MILLISECONDS);
                    if (rm.getException() != null) {
                        throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50047, (Throwable)rm.getException());
                    }
                    if (rm.isUpdateResult()) {
                        ExecuteQuery.this.writeResults(resultsNode, Arrays.asList("update-count"), rm.getResultsList());
                    } else {
                        ExecuteQuery.this.writeResults(resultsNode, Arrays.asList(rm.getColumnNames()), rm.getResultsList());
                        while (rm.getFinalRow() == -1 || rm.getLastRow() < rm.getFinalRow()) {
                            elapsed = System.currentTimeMillis() - start;
                            message = engine.processCursorRequest(0L, rm.getLastRow() + 1, 1024);
                            rm = (ResultsMessage)message.get(timoutInMilli - elapsed, TimeUnit.MILLISECONDS);
                            ExecuteQuery.this.writeResults(resultsNode, Arrays.asList(rm.getColumnNames()), rm.getResultsList());
                        }
                    }
                    elapsed = System.currentTimeMillis() - start;
                    ResultsFuture response = engine.closeRequest(0L);
                    response.get(timoutInMilli - elapsed, TimeUnit.MILLISECONDS);
                    return resultsNode;
                }
            });
        }
        catch (Throwable t) {
            try {
                throw new OperationFailedException(new ModelNode().set(t.getMessage()));
            }
            catch (Throwable throwable) {
                try {
                    workContext.runInContext((Callable)new Callable<Void>(engine, session){
                        final /* synthetic */ DQPCore val$engine;
                        final /* synthetic */ SessionMetadata val$session;
                        {
                            this.val$engine = dQPCore;
                            this.val$session = sessionMetadata;
                        }

                        @Override
                        public Void call() throws Exception {
                            this.val$engine.terminateSession(this.val$session.getSessionId());
                            return null;
                        }
                    });
                    throw throwable;
                }
                catch (Throwable e) {
                    throw new OperationFailedException(new ModelNode().set(e.getMessage()));
                }
            }
        }
        try {
            workContext.runInContext((Callable)new /* invalid duplicate definition of identical inner class */);
            return modelNode;
        }
        catch (Throwable e) {
            throw new OperationFailedException(new ModelNode().set(e.getMessage()));
        }
    }

    private void writeResults(ModelNode resultsNode, List<String> columns, List<? extends List<?>> results) throws SQLException {
        for (List<?> row : results) {
            ModelNode rowNode = new ModelNode();
            for (int colNum = 0; colNum < columns.size(); ++colNum) {
                Object aValue = row.get(colNum);
                if (aValue == null) continue;
                if (aValue instanceof Integer) {
                    rowNode.get(columns.get(colNum)).set(((Integer)aValue).intValue());
                    continue;
                }
                if (aValue instanceof Long) {
                    rowNode.get(columns.get(colNum)).set(((Long)aValue).longValue());
                    continue;
                }
                if (aValue instanceof Double) {
                    rowNode.get(columns.get(colNum)).set(((Double)aValue).doubleValue());
                    continue;
                }
                if (aValue instanceof Boolean) {
                    rowNode.get(columns.get(colNum)).set(((Boolean)aValue).booleanValue());
                    continue;
                }
                if (aValue instanceof BigInteger) {
                    rowNode.get(columns.get(colNum)).set((BigInteger)aValue);
                    continue;
                }
                if (aValue instanceof BigDecimal) {
                    rowNode.get(columns.get(colNum)).set((BigDecimal)aValue);
                    continue;
                }
                if (aValue instanceof String) {
                    rowNode.get(new String[]{columns.get(colNum), "type"}).set(ModelType.STRING);
                    rowNode.get(columns.get(colNum)).set((String)aValue);
                    continue;
                }
                if (aValue instanceof Blob) {
                    rowNode.get(new String[]{columns.get(colNum), "type"}).set(ModelType.OBJECT);
                    rowNode.get(columns.get(colNum)).set("blob");
                    continue;
                }
                if (aValue instanceof Clob) {
                    rowNode.get(new String[]{columns.get(colNum), "type"}).set(ModelType.OBJECT);
                    rowNode.get(columns.get(colNum)).set("clob");
                    continue;
                }
                if (aValue instanceof SQLXML) {
                    SQLXML xml = (SQLXML)aValue;
                    rowNode.get(new String[]{columns.get(colNum), "type"}).set(ModelType.STRING);
                    rowNode.get(columns.get(colNum)).set(xml.getString());
                    continue;
                }
                rowNode.get(new String[]{columns.get(colNum), "type"}).set(ModelType.STRING);
                rowNode.get(columns.get(colNum)).set(aValue.toString());
            }
            resultsNode.add(rowNode);
        }
    }
}

