/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.impl.RequestMetadata;
import org.teiid.adminapi.impl.VDBMetadataMapper;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.OperationsConstants;
import org.teiid.jboss.TeiidOperationHandler;

class ListRequests
extends TeiidOperationHandler {
    protected ListRequests() {
        super("list-requests");
    }

    @Override
    protected void executeOperation(OperationContext context, DQPCore engine, ModelNode operation) throws OperationFailedException {
        boolean includeSourceQueries = true;
        if (operation.hasDefined(OperationsConstants.INCLUDE_SOURCE.getName())) {
            includeSourceQueries = operation.get(OperationsConstants.INCLUDE_SOURCE.getName()).asBoolean();
        }
        ModelNode result = context.getResult();
        List requests = engine.getRequests();
        for (RequestMetadata request : requests) {
            if (request.sourceRequest()) {
                if (!includeSourceQueries) continue;
                VDBMetadataMapper.RequestMetadataMapper.INSTANCE.wrap(request, result.add());
                continue;
            }
            VDBMetadataMapper.RequestMetadataMapper.INSTANCE.wrap(request, result.add());
        }
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        builder.addParameter((AttributeDefinition)OperationsConstants.INCLUDE_SOURCE);
        builder.setReplyType(ModelType.LIST);
        builder.setReplyParameters(VDBMetadataMapper.RequestMetadataMapper.INSTANCE.getAttributeDefinitions());
    }
}

