/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.deployers.RuntimeVDB;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.OperationsConstants;
import org.teiid.jboss.VDBOperations;

class RemoveDataRole
extends VDBOperations {
    public RemoveDataRole() {
        super("remove-data-role");
    }

    @Override
    protected void executeOperation(OperationContext context, RuntimeVDB vdb, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined(OperationsConstants.DATA_ROLE.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.DATA_ROLE.getName() + ".missing")));
        }
        if (!operation.hasDefined(OperationsConstants.MAPPED_ROLE.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.MAPPED_ROLE.getName() + ".missing")));
        }
        String policyName = operation.get(OperationsConstants.DATA_ROLE.getName()).asString();
        String mappedRole = operation.get(OperationsConstants.MAPPED_ROLE.getName()).asString();
        try {
            vdb.remoteDataRole(policyName, mappedRole);
        }
        catch (AdminProcessingException e) {
            throw new OperationFailedException(new ModelNode().set(e.getMessage()));
        }
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        super.describeParameters(builder);
        builder.addParameter((AttributeDefinition)OperationsConstants.DATA_ROLE);
        builder.addParameter((AttributeDefinition)OperationsConstants.MAPPED_ROLE);
    }
}

