/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ArrayList;
import java.util.EnumSet;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.VDBRepository;
import org.teiid.jboss.BaseOperationHandler;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.OperationsConstants;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.metadata.Schema;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.TransformationMetadata;

class GetSchema
extends BaseOperationHandler<VDBRepository> {
    protected GetSchema() {
        super("get-schema");
    }

    @Override
    protected VDBRepository getService(OperationContext context, PathAddress pathAddress, ModelNode operation) throws OperationFailedException {
        ServiceController sc = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.VDB_REPO);
        return (VDBRepository)VDBRepository.class.cast(sc.getValue());
    }

    @Override
    protected void executeOperation(OperationContext context, VDBRepository repo, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined(OperationsConstants.VDB_NAME.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.VDB_NAME.getName() + ".missing")));
        }
        if (!operation.hasDefined(OperationsConstants.VDB_VERSION.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.VDB_VERSION.getName() + ".missing")));
        }
        if (!operation.hasDefined(OperationsConstants.MODEL_NAME.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.MODEL_NAME.getName() + ".missing")));
        }
        ModelNode result = context.getResult();
        String vdbName = operation.get(OperationsConstants.VDB_NAME.getName()).asString();
        int vdbVersion = operation.get(OperationsConstants.VDB_VERSION.getName()).asInt();
        String modelName = operation.get(OperationsConstants.MODEL_NAME.getName()).asString();
        VDBMetaData vdb = repo.getLiveVDB(vdbName, vdbVersion);
        if (vdb == null || vdb.getStatus() != VDB.Status.ACTIVE) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50096, new Object[]{vdbName, vdbVersion})));
        }
        EnumSet<Admin.SchemaObjectType> schemaTypes = null;
        if (vdb.getModel(modelName) == null) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50097, new Object[]{vdbName, vdbVersion, modelName})));
        }
        if (operation.hasDefined(OperationsConstants.ENTITY_TYPE.getName())) {
            String[] types = operation.get(OperationsConstants.ENTITY_TYPE.getName()).asString().toUpperCase().split(",");
            if (types.length > 0) {
                ArrayList<Admin.SchemaObjectType> sot = new ArrayList<Admin.SchemaObjectType>();
                for (int i = 1; i < types.length; ++i) {
                    sot.add(Admin.SchemaObjectType.valueOf((String)types[i]));
                }
                schemaTypes = EnumSet.of(Admin.SchemaObjectType.valueOf((String)types[0]), (Enum[])sot.toArray(new Admin.SchemaObjectType[sot.size()]));
            } else {
                schemaTypes = EnumSet.of(Admin.SchemaObjectType.valueOf((String)types[0]));
            }
        }
        String regEx = null;
        if (operation.hasDefined(OperationsConstants.ENTITY_PATTERN.getName())) {
            regEx = operation.get(OperationsConstants.ENTITY_PATTERN.getName()).asString();
        }
        CompositeMetadataStore metadataStore = ((TransformationMetadata)vdb.getAttachment(TransformationMetadata.class)).getMetadataStore();
        Schema schema = metadataStore.getSchema(modelName);
        String ddl = DDLStringVisitor.getDDLString((Schema)schema, schemaTypes, (String)regEx);
        result.set(ddl);
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        builder.addParameter((AttributeDefinition)OperationsConstants.VDB_NAME);
        builder.addParameter((AttributeDefinition)OperationsConstants.VDB_VERSION);
        builder.addParameter((AttributeDefinition)OperationsConstants.MODEL_NAME);
        builder.addParameter((AttributeDefinition)OperationsConstants.ENTITY_TYPE);
        builder.addParameter((AttributeDefinition)OperationsConstants.ENTITY_PATTERN);
        builder.setReplyType(ModelType.STRING);
    }
}

