/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.naming.InitialContext;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.ConcurrentMapInjector;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.ReferenceFactoryService;
import org.teiid.jboss.TeiidConstants;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.jboss.TransportService;
import org.teiid.logging.LogManager;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.transport.ClientServiceRegistry;
import org.teiid.transport.LocalServerConnection;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.SocketConfiguration;

class TransportAdd
extends AbstractAddStepHandler {
    public static TransportAdd INSTANCE = new TransportAdd();
    public static TeiidConstants.TeiidAttribute[] ATTRIBUTES = new TeiidConstants.TeiidAttribute[]{TeiidConstants.TRANSPORT_PROTOCOL_ATTRIBUTE, TeiidConstants.TRANSPORT_SOCKET_BINDING_ATTRIBUTE, TeiidConstants.TRANSPORT_MAX_SOCKET_THREADS_ATTRIBUTE, TeiidConstants.TRANSPORT_IN_BUFFER_SIZE_ATTRIBUTE, TeiidConstants.TRANSPORT_OUT_BUFFER_SIZE_ATTRIBUTE, TeiidConstants.AUTHENTICATION_SECURITY_DOMAIN_ATTRIBUTE, TeiidConstants.AUTHENTICATION_MAX_SESSIONS_ALLOWED_ATTRIBUTE, TeiidConstants.AUTHENTICATION_SESSION_EXPIRATION_TIME_LIMIT_ATTRIBUTE, TeiidConstants.AUTHENTICATION_KRB5_DOMAIN_ATTRIBUTE, TeiidConstants.PG_MAX_LOB_SIZE_ALLOWED_ELEMENT, TeiidConstants.SSL_MODE_ATTRIBUTE, TeiidConstants.SSL_AUTH_MODE_ATTRIBUTE, TeiidConstants.SSL_SSL_PROTOCOL_ATTRIBUTE, TeiidConstants.SSL_KEY_MANAGEMENT_ALG_ATTRIBUTE, TeiidConstants.SSL_ENABLED_CIPHER_SUITES_ATTRIBUTE, TeiidConstants.SSL_KETSTORE_NAME_ATTRIBUTE, TeiidConstants.SSL_KETSTORE_PASSWORD_ATTRIBUTE, TeiidConstants.SSL_KETSTORE_TYPE_ATTRIBUTE, TeiidConstants.SSL_TRUSTSTORE_NAME_ATTRIBUTE, TeiidConstants.SSL_TRUSTSTORE_PASSWORD_ATTRIBUTE, TeiidConstants.SSL_KETSTORE_ALIAS_ATTRIBUTE, TeiidConstants.SSL_KETSTORE_KEY_PASSWORD_ATTRIBUTE};

    TransportAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (int i = 0; i < ATTRIBUTES.length; ++i) {
            ATTRIBUTES[i].validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceTarget target = context.getServiceTarget();
        ModelNode address = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)address);
        String transportName = pathAddress.getLastElement().getValue();
        TransportService transport = new TransportService(transportName);
        String socketBinding = null;
        if (TeiidConstants.TRANSPORT_SOCKET_BINDING_ATTRIBUTE.isDefined(operation, context)) {
            socketBinding = TeiidConstants.TRANSPORT_SOCKET_BINDING_ATTRIBUTE.asString(operation, context);
            transport.setSocketConfig(this.buildSocketConfiguration(context, operation));
        } else {
            transport.setEmbedded(true);
            LogManager.logDetail((String)"org.teiid.SECURITY", (Object)IntegrationPlugin.Util.getString("socket_binding_not_defined", new Object[]{transportName}));
        }
        List<String> domainList = Collections.emptyList();
        if (TeiidConstants.AUTHENTICATION_SECURITY_DOMAIN_ATTRIBUTE.isDefined(operation, context)) {
            String domains = TeiidConstants.AUTHENTICATION_SECURITY_DOMAIN_ATTRIBUTE.asString(operation, context);
            domainList = Arrays.asList(domains.split(","));
        }
        transport.setAuthenticationDomains(domainList);
        if (TeiidConstants.AUTHENTICATION_MAX_SESSIONS_ALLOWED_ATTRIBUTE.isDefined(operation, context)) {
            transport.setSessionMaxLimit(TeiidConstants.AUTHENTICATION_MAX_SESSIONS_ALLOWED_ATTRIBUTE.asLong(operation, context));
        }
        if (TeiidConstants.AUTHENTICATION_SESSION_EXPIRATION_TIME_LIMIT_ATTRIBUTE.isDefined(operation, context)) {
            transport.setSessionExpirationTimeLimit(TeiidConstants.AUTHENTICATION_SESSION_EXPIRATION_TIME_LIMIT_ATTRIBUTE.asLong(operation, context));
        }
        if (TeiidConstants.AUTHENTICATION_KRB5_DOMAIN_ATTRIBUTE.isDefined(operation, context)) {
            transport.setAuthenticationType(AuthenticationType.GSS);
            transport.setKrb5Domain(TeiidConstants.AUTHENTICATION_KRB5_DOMAIN_ATTRIBUTE.asString(operation, context));
        } else {
            transport.setAuthenticationType(AuthenticationType.CLEARTEXT);
        }
        if (TeiidConstants.PG_MAX_LOB_SIZE_ALLOWED_ELEMENT.isDefined(operation, context)) {
            transport.setMaxODBCLobSizeAllowed(TeiidConstants.PG_MAX_LOB_SIZE_ALLOWED_ELEMENT.asInt(operation, context));
        }
        ServiceBuilder transportBuilder = target.addService(TeiidServiceNames.transportServiceName(transportName), (Service)transport);
        if (socketBinding != null) {
            transportBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"binding", socketBinding}), SocketBinding.class, transport.getSocketBindingInjector());
        }
        transportBuilder.addDependency(TeiidServiceNames.BUFFER_MGR, BufferManager.class, transport.getBufferManagerInjector());
        transportBuilder.addDependency(TeiidServiceNames.VDB_REPO, VDBRepository.class, transport.getVdbRepositoryInjector());
        transportBuilder.addDependency(TeiidServiceNames.ENGINE, DQPCore.class, transport.getDqpInjector());
        for (String domain : domainList) {
            LogManager.logInfo((String)"org.teiid.SECURITY", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50011, new Object[]{domain, transportName}));
            transportBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"security", "security-domain", domain}), SecurityDomainContext.class, (Injector)new ConcurrentMapInjector(transport.securityDomains, (Object)domain));
        }
        transportBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        newControllers.add(transportBuilder.install());
        if (transport.isEmbedded() && !this.isEmbeddedRegistered(transportName)) {
            ReferenceFactoryService referenceFactoryService = new ReferenceFactoryService();
            ServiceName referenceFactoryServiceName = TeiidServiceNames.embeddedTransportServiceName(transportName).append(new String[]{"reference-factory"});
            ServiceBuilder referenceBuilder = target.addService(referenceFactoryServiceName, referenceFactoryService);
            referenceBuilder.addDependency(TeiidServiceNames.transportServiceName(transportName), ClientServiceRegistry.class, referenceFactoryService.getInjector());
            referenceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)LocalServerConnection.jndiNameForRuntime((String)transportName));
            BinderService binderService = new BinderService(bindInfo.getBindName());
            ServiceBuilder binderBuilder = target.addService(bindInfo.getBinderServiceName(), (Service)binderService);
            binderBuilder.addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, binderService.getManagedObjectInjector());
            binderBuilder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector());
            binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
            newControllers.add(referenceBuilder.install());
            newControllers.add(binderBuilder.install());
        }
    }

    protected boolean isEmbeddedRegistered(String transportName) {
        try {
            InitialContext ic = new InitialContext();
            ic.lookup(LocalServerConnection.jndiNameForRuntime((String)transportName));
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private SocketConfiguration buildSocketConfiguration(OperationContext context, ModelNode node) throws OperationFailedException {
        SocketConfiguration socket = new SocketConfiguration();
        if (TeiidConstants.TRANSPORT_PROTOCOL_ATTRIBUTE.isDefined(node, context)) {
            socket.setProtocol(TeiidConstants.TRANSPORT_PROTOCOL_ATTRIBUTE.asString(node, context));
        }
        if (TeiidConstants.TRANSPORT_MAX_SOCKET_THREADS_ATTRIBUTE.isDefined(node, context)) {
            socket.setMaxSocketThreads(TeiidConstants.TRANSPORT_MAX_SOCKET_THREADS_ATTRIBUTE.asInt(node, context).intValue());
        }
        if (TeiidConstants.TRANSPORT_IN_BUFFER_SIZE_ATTRIBUTE.isDefined(node, context)) {
            socket.setInputBufferSize(TeiidConstants.TRANSPORT_IN_BUFFER_SIZE_ATTRIBUTE.asInt(node, context).intValue());
        }
        if (TeiidConstants.TRANSPORT_OUT_BUFFER_SIZE_ATTRIBUTE.isDefined(node, context)) {
            socket.setOutputBufferSize(TeiidConstants.TRANSPORT_OUT_BUFFER_SIZE_ATTRIBUTE.asInt(node, context).intValue());
        }
        SSLConfiguration ssl = new SSLConfiguration();
        if (TeiidConstants.SSL_MODE_ATTRIBUTE.isDefined(node, context)) {
            ssl.setMode(TeiidConstants.SSL_MODE_ATTRIBUTE.asString(node, context));
        }
        if (TeiidConstants.SSL_SSL_PROTOCOL_ATTRIBUTE.isDefined(node, context)) {
            ssl.setSslProtocol(TeiidConstants.SSL_SSL_PROTOCOL_ATTRIBUTE.asString(node, context));
        }
        if (TeiidConstants.SSL_KEY_MANAGEMENT_ALG_ATTRIBUTE.isDefined(node, context)) {
            ssl.setKeymanagementAlgorithm(TeiidConstants.SSL_KEY_MANAGEMENT_ALG_ATTRIBUTE.asString(node, context));
        }
        if (TeiidConstants.SSL_AUTH_MODE_ATTRIBUTE.isDefined(node, context)) {
            ssl.setAuthenticationMode(TeiidConstants.SSL_AUTH_MODE_ATTRIBUTE.asString(node, context));
        }
        if (TeiidConstants.SSL_KETSTORE_NAME_ATTRIBUTE.isDefined(node, context)) {
            ssl.setKeystoreFilename(TeiidConstants.SSL_KETSTORE_NAME_ATTRIBUTE.asString(node, context));
        }
        if (TeiidConstants.SSL_KETSTORE_ALIAS_ATTRIBUTE.isDefined(node, context)) {
            ssl.setKeystoreKeyAlias(TeiidConstants.SSL_KETSTORE_ALIAS_ATTRIBUTE.asString(node, context));
        }
        if (TeiidConstants.SSL_KETSTORE_KEY_PASSWORD_ATTRIBUTE.isDefined(node, context)) {
            ssl.setKeystoreKeyPassword(TeiidConstants.SSL_KETSTORE_KEY_PASSWORD_ATTRIBUTE.asString(node, context));
        }
        if (TeiidConstants.SSL_ENABLED_CIPHER_SUITES_ATTRIBUTE.isDefined(node, context)) {
            ssl.setEnabledCipherSuites(TeiidConstants.SSL_ENABLED_CIPHER_SUITES_ATTRIBUTE.asString(node, context));
        }
        if (TeiidConstants.SSL_KETSTORE_PASSWORD_ATTRIBUTE.isDefined(node, context)) {
            ssl.setKeystorePassword(TeiidConstants.SSL_KETSTORE_PASSWORD_ATTRIBUTE.asString(node, context));
        }
        if (TeiidConstants.SSL_KETSTORE_TYPE_ATTRIBUTE.isDefined(node, context)) {
            ssl.setKeystoreType(TeiidConstants.SSL_KETSTORE_TYPE_ATTRIBUTE.asString(node, context));
        }
        if (TeiidConstants.SSL_TRUSTSTORE_NAME_ATTRIBUTE.isDefined(node, context)) {
            ssl.setTruststoreFilename(TeiidConstants.SSL_TRUSTSTORE_NAME_ATTRIBUTE.asString(node, context));
        }
        if (TeiidConstants.SSL_TRUSTSTORE_PASSWORD_ATTRIBUTE.isDefined(node, context)) {
            ssl.setTruststorePassword(TeiidConstants.SSL_TRUSTSTORE_PASSWORD_ATTRIBUTE.asString(node, context));
        }
        socket.setSSLConfiguration(ssl);
        return socket;
    }
}

