/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.deployers.ExtendedPropertyMetadata;
import org.teiid.deployers.ExtendedPropertyMetadataList;
import org.teiid.dqp.internal.datamgr.TranslatorRepository;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.OperationsConstants;
import org.teiid.jboss.TranslatorOperationHandler;

class ReadTranslatorProperties
extends TranslatorOperationHandler {
    protected ReadTranslatorProperties() {
        super("read-translator-properties");
    }

    @Override
    protected void executeOperation(OperationContext context, TranslatorRepository repo, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined(OperationsConstants.TRANSLATOR_NAME.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.TRANSLATOR_NAME.getName() + ".missing")));
        }
        ModelNode result = context.getResult();
        String translatorName = operation.get(OperationsConstants.TRANSLATOR_NAME.getName()).asString();
        VDBTranslatorMetaData translator = repo.getTranslatorMetaData(translatorName);
        if (translator != null) {
            ExtendedPropertyMetadataList properties = (ExtendedPropertyMetadataList)translator.getAttachment(ExtendedPropertyMetadataList.class);
            for (ExtendedPropertyMetadata epm : properties) {
                result.add(ReadTranslatorProperties.buildNode(epm));
            }
        }
    }

    static ModelNode buildNode(ExtendedPropertyMetadata prop) {
        ModelNode node = new ModelNode();
        String name = prop.name();
        String type = prop.type();
        if ("java.lang.String".equals(type)) {
            node.get(new String[]{name, "type"}).set(ModelType.STRING);
        } else if ("java.lang.Integer".equals(type) || "int".equals(type)) {
            node.get(new String[]{name, "type"}).set(ModelType.INT);
        } else if ("java.lang.Long".equals(type) || "long".equals(type)) {
            node.get(new String[]{name, "type"}).set(ModelType.LONG);
        } else if ("java.lang.Boolean".equals(type) || "boolean".equals(type)) {
            node.get(new String[]{name, "type"}).set(ModelType.BOOLEAN);
        }
        node.get(new String[]{name, "required"}).set(prop.required());
        if (prop.description() != null) {
            node.get(new String[]{name, "description"}).set(prop.description());
        }
        if (prop.display() != null) {
            node.get(new String[]{name, "display"}).set(prop.display());
        }
        node.get(new String[]{name, "read-only"}).set(prop.readOnly());
        node.get(new String[]{name, "advanced"}).set(prop.advanced());
        if (prop.allowed() != null) {
            for (String s : prop.allowed()) {
                node.get(new String[]{name, "allowed"}).add(s);
            }
        }
        node.get(new String[]{name, "masked"}).set(prop.masked());
        if (prop.defaultValue() != null) {
            node.get(new String[]{name, "default"}).set(prop.defaultValue());
        }
        return node;
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        builder.addParameter((AttributeDefinition)OperationsConstants.TRANSLATOR_NAME);
        builder.setReplyType(ModelType.LIST);
        builder.setReplyValueType(ModelType.PROPERTY);
    }
}

