/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.List;
import java.util.ServiceLoader;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.TranslatorUtil;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidConstants;
import org.teiid.jboss.TranslatorDeployer;
import org.teiid.logging.LogManager;
import org.teiid.translator.ExecutionFactory;

class TranslatorAdd
extends AbstractAddStepHandler {
    public static TranslatorAdd INSTANCE = new TranslatorAdd();

    TranslatorAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        TeiidConstants.TRANSLATOR_MODULE_ATTRIBUTE.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode address = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)address);
        String translatorName = pathAddress.getLastElement().getValue();
        String moduleName = null;
        if (TeiidConstants.TRANSLATOR_MODULE_ATTRIBUTE.isDefined(operation, context)) {
            moduleName = TeiidConstants.TRANSLATOR_MODULE_ATTRIBUTE.asString(operation, context);
        }
        ServiceTarget target = context.getServiceTarget();
        ClassLoader translatorLoader = ((Object)((Object)this)).getClass().getClassLoader();
        ModuleLoader ml = Module.getCallerModuleLoader();
        if (moduleName != null && ml != null) {
            try {
                Module module = ml.loadModule(ModuleIdentifier.create((String)moduleName));
                translatorLoader = module.getClassLoader();
            }
            catch (ModuleLoadException e) {
                throw new OperationFailedException((Throwable)e, new ModelNode().set(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50007, new Object[]{moduleName, translatorName})));
            }
        }
        boolean added = false;
        ServiceLoader<ExecutionFactory> serviceLoader = ServiceLoader.load(ExecutionFactory.class, translatorLoader);
        if (serviceLoader != null) {
            for (ExecutionFactory ef : serviceLoader) {
                VDBTranslatorMetaData metadata = TranslatorUtil.buildTranslatorMetadata((ExecutionFactory)ef, (String)moduleName);
                if (metadata == null) {
                    throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50008, new Object[]{translatorName})));
                }
                metadata.addAttchment(ClassLoader.class, (Object)translatorLoader);
                if (!translatorName.equalsIgnoreCase(metadata.getName())) continue;
                LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50006, new Object[]{metadata.getName()}));
                TranslatorDeployer.buildService(target, metadata);
                added = true;
                break;
            }
        }
        if (!added) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50009, new Object[]{translatorName, moduleName})));
        }
    }
}

