/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.SecurityContext;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.negotiation.Constants;
import org.jboss.security.negotiation.NegotiationMessage;
import org.jboss.security.negotiation.common.NegotiationContext;
import org.jboss.security.negotiation.spnego.KerberosMessage;
import org.teiid.core.BundleUtil;
import org.teiid.dqp.service.GSSResult;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.logging.LogManager;
import org.teiid.security.Credentials;
import org.teiid.services.SessionServiceImpl;
import org.teiid.services.TeiidLoginContext;

public class JBossSessionService
extends SessionServiceImpl {
    private Map<String, SecurityDomainContext> securityDomainMap;

    public JBossSessionService(Map<String, SecurityDomainContext> securityDomainMap) {
        this.securityDomainMap = securityDomainMap;
    }

    protected TeiidLoginContext authenticate(String userName, Credentials credentials, String applicationName, String domain) throws LoginException {
        Subject subject;
        String credString;
        SimplePrincipal userPrincipal;
        boolean isValid;
        AuthenticationManager authManager;
        String baseUsername = JBossSessionService.getBaseUsername((String)userName);
        SecurityDomainContext securityDomainContext = this.securityDomainMap.get(domain);
        if (securityDomainContext != null && (authManager = securityDomainContext.getAuthenticationManager()) != null && (isValid = authManager.isValid((Principal)(userPrincipal = new SimplePrincipal(userName)), (Object)(credString = credentials == null ? null : new String(credentials.getCredentialsAsCharArray())), subject = new Subject()))) {
            String qualifiedUserName = baseUsername + "@" + domain;
            Object securityContext = this.securityHelper.createSecurityContext(domain, (Principal)userPrincipal, (Object)credString, subject);
            LogManager.logDetail((String)"org.teiid.SECURITY", (Object[])new Object[]{"Logon successful for \"", userName, "\""});
            return new TeiidLoginContext(qualifiedUserName, subject, domain, securityContext);
        }
        throw new LoginException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50072, new Object[]{userName}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GSSResult neogitiateGssLogin(String securityDomain, byte[] serviceTicket) throws LoginException {
        AuthenticationManager authManager;
        SecurityDomainContext securityDomainContext = this.securityDomainMap.get(securityDomain);
        if (securityDomainContext != null && (authManager = securityDomainContext.getAuthenticationManager()) != null) {
            NegotiationContext context;
            Object previous;
            block7: {
                LoginException le;
                block8: {
                    SecurityContext securityContext;
                    block6: {
                        GSSResult gSSResult;
                        previous = null;
                        context = new NegotiationContext();
                        context.setRequestMessage((NegotiationMessage)new KerberosMessage(Constants.KERBEROS_V5, serviceTicket));
                        try {
                            context.associate();
                            securityContext = (SecurityContext)this.securityHelper.createSecurityContext(securityDomain, (Principal)new SimplePrincipal("temp"), null, new Subject());
                            previous = this.securityHelper.associateSecurityContext((Object)securityContext);
                            Subject subject = new Subject();
                            boolean isValid = authManager.isValid(null, null, subject);
                            if (!isValid) break block6;
                            Principal principal = null;
                            Iterator<Principal> i$ = subject.getPrincipals().iterator();
                            if (i$.hasNext()) {
                                Principal p;
                                principal = p = i$.next();
                            }
                            Object sc = this.securityHelper.createSecurityContext(securityDomain, principal, null, subject);
                            LogManager.logDetail((String)"org.teiid.SECURITY", (Object[])new Object[]{"Logon successful though GSS API"});
                            GSSResult result = this.buildGSSResult(context, securityDomain);
                            result.setSecurityContext(sc);
                            result.setUserName(principal.getName());
                            gSSResult = result;
                        }
                        catch (Throwable throwable) {
                            this.securityHelper.associateSecurityContext(previous);
                            context.clear();
                            throw throwable;
                        }
                        this.securityHelper.associateSecurityContext(previous);
                        context.clear();
                        return gSSResult;
                    }
                    le = (LoginException)securityContext.getData().get("org.jboss.security.exception");
                    if (le == null) break block7;
                    if (!le.getMessage().equals("Continuation Required.")) break block8;
                    GSSResult gSSResult = this.buildGSSResult(context, securityDomain);
                    this.securityHelper.associateSecurityContext(previous);
                    context.clear();
                    return gSSResult;
                }
                throw le;
            }
            this.securityHelper.associateSecurityContext(previous);
            context.clear();
        }
        throw new LoginException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50072, new Object[]{"GSS Auth"}));
    }

    private GSSResult buildGSSResult(NegotiationContext context, String securityDomain) throws LoginException {
        if (context.getResponseMessage() instanceof KerberosMessage) {
            try {
                KerberosMessage km = (KerberosMessage)context.getResponseMessage();
                GSSContext securityContext = (GSSContext)context.getSchemeContext();
                return new GSSResult(km.getToken(), context.isAuthenticated(), securityContext.getDelegCred());
            }
            catch (GSSException e) {
                throw new LoginException(e.getMessage());
            }
        }
        throw new LoginException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50103, new Object[]{securityDomain}));
    }
}

