/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.RequestMessage;
import org.teiid.client.ResultsMessage;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.jboss.BaseOperationHandler;
import org.teiid.jboss.BufferManagerService;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.jboss.TransportService;
import org.teiid.logging.LogManager;
import org.teiid.query.tempdata.TempTableDataManager;

abstract class TeiidOperationHandler
extends BaseOperationHandler<DQPCore> {
    protected TeiidOperationHandler(String operationName) {
        super(operationName);
    }

    protected TeiidOperationHandler(String operationName, boolean changesRuntime) {
        super(operationName, changesRuntime);
    }

    static VDBMetaData checkVDB(OperationContext context, String vdbName, int vdbVersion) throws OperationFailedException {
        ServiceController sc = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.VDB_REPO);
        VDBRepository repo = (VDBRepository)VDBRepository.class.cast(sc.getValue());
        VDBMetaData vdb = repo.getLiveVDB(vdbName, vdbVersion);
        if (vdb == null) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50102, new Object[]{vdb, vdbVersion})));
        }
        VDB.Status status = vdb.getStatus();
        if (status != VDB.Status.ACTIVE) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50096, new Object[]{vdbName, vdbVersion, status})));
        }
        return vdb;
    }

    @Override
    protected DQPCore getService(OperationContext context, PathAddress pathAddress, ModelNode operation) throws OperationFailedException {
        ServiceController repo = context.getServiceRegistry(this.isChangesRuntimes()).getRequiredService(TeiidServiceNames.ENGINE);
        if (repo != null) {
            return (DQPCore)DQPCore.class.cast(repo.getValue());
        }
        return null;
    }

    protected BufferManagerService getBufferManager(OperationContext context) {
        ServiceController repo = context.getServiceRegistry(this.isChangesRuntimes()).getRequiredService(TeiidServiceNames.BUFFER_MGR);
        if (repo != null) {
            return (BufferManagerService)((Object)BufferManagerService.class.cast(repo.getService()));
        }
        return null;
    }

    protected VDBRepository getVDBrepository(OperationContext context) {
        ServiceController repo = context.getServiceRegistry(this.isChangesRuntimes()).getRequiredService(TeiidServiceNames.VDB_REPO);
        if (repo != null) {
            return (VDBRepository)VDBRepository.class.cast(repo.getValue());
        }
        return null;
    }

    protected int getSessionCount(OperationContext context) throws AdminException {
        int count = 0;
        List<TransportService> transportServices = this.getTransportServices(context);
        for (TransportService t : transportServices) {
            count += t.getActiveSessionsCount();
        }
        return count;
    }

    protected List<TransportService> getTransportServices(OperationContext context) {
        ArrayList<TransportService> transports = new ArrayList<TransportService>();
        List services = context.getServiceRegistry(false).getServiceNames();
        for (ServiceName name : services) {
            ServiceController transport;
            if (!TeiidServiceNames.TRANSPORT_BASE.isParentOf(name) || (transport = context.getServiceRegistry(this.isChangesRuntimes()).getService(name)) == null) continue;
            transports.add((TransportService)((Object)TransportService.class.cast(transport.getValue())));
        }
        return transports;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ModelNode executeQuery(VDBMetaData vdb, final DQPCore engine, final String command, final long timoutInMilli, final ModelNode resultsNode, final boolean timeAsString) throws OperationFailedException {
        ModelNode modelNode;
        String user = "CLI ADMIN";
        LogManager.logDetail((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.getString("admin_executing", new Object[]{user, command}));
        SessionMetadata session = TempTableDataManager.createTemporarySession((String)user, (String)"admin-console", (VDBMetaData)vdb);
        long requestID = 0L;
        DQPWorkContext workContext = new DQPWorkContext();
        workContext.setUseCallingThread(true);
        workContext.setSession(session);
        try {
            modelNode = (ModelNode)workContext.runInContext((Callable)new Callable<ModelNode>(){

                @Override
                public ModelNode call() throws Exception {
                    long elapsed;
                    long start = System.currentTimeMillis();
                    RequestMessage request = new RequestMessage(command);
                    request.setExecutionId(0L);
                    request.setRowLimit(engine.getMaxRowsFetchSize());
                    ResultsFuture message = engine.executeRequest(0L, request);
                    ResultsMessage rm = null;
                    rm = timoutInMilli < 0L ? (ResultsMessage)message.get() : (ResultsMessage)message.get(timoutInMilli, TimeUnit.MILLISECONDS);
                    if (rm.getException() != null) {
                        throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50047, (Throwable)rm.getException());
                    }
                    if (rm.isUpdateResult()) {
                        TeiidOperationHandler.writeResults(resultsNode, Arrays.asList("update-count"), rm.getResultsList(), timeAsString);
                    } else {
                        TeiidOperationHandler.writeResults(resultsNode, Arrays.asList(rm.getColumnNames()), rm.getResultsList(), timeAsString);
                        while (rm.getFinalRow() == -1 || rm.getLastRow() < rm.getFinalRow()) {
                            elapsed = System.currentTimeMillis() - start;
                            message = engine.processCursorRequest(0L, rm.getLastRow() + 1, 1024);
                            rm = (ResultsMessage)message.get(timoutInMilli - elapsed, TimeUnit.MILLISECONDS);
                            TeiidOperationHandler.writeResults(resultsNode, Arrays.asList(rm.getColumnNames()), rm.getResultsList(), timeAsString);
                        }
                    }
                    elapsed = System.currentTimeMillis() - start;
                    ResultsFuture response = engine.closeRequest(0L);
                    response.get(timoutInMilli - elapsed, TimeUnit.MILLISECONDS);
                    return resultsNode;
                }
            });
        }
        catch (Throwable t) {
            try {
                throw new OperationFailedException(new ModelNode().set(t.getMessage()));
            }
            catch (Throwable throwable) {
                try {
                    workContext.runInContext((Callable)new Callable<Void>(engine, session){
                        final /* synthetic */ DQPCore val$engine;
                        final /* synthetic */ SessionMetadata val$session;
                        {
                            this.val$engine = dQPCore;
                            this.val$session = sessionMetadata;
                        }

                        @Override
                        public Void call() throws Exception {
                            this.val$engine.terminateSession(this.val$session.getSessionId());
                            return null;
                        }
                    });
                    throw throwable;
                }
                catch (Throwable e) {
                    throw new OperationFailedException(new ModelNode().set(e.getMessage()));
                }
            }
        }
        try {
            workContext.runInContext((Callable)new /* invalid duplicate definition of identical inner class */);
            return modelNode;
        }
        catch (Throwable e) {
            throw new OperationFailedException(new ModelNode().set(e.getMessage()));
        }
    }

    private static void writeResults(ModelNode resultsNode, List<String> columns, List<? extends List<?>> results, boolean timeAsString) throws SQLException {
        for (List<?> row : results) {
            ModelNode rowNode = new ModelNode();
            for (int colNum = 0; colNum < columns.size(); ++colNum) {
                Object aValue = row.get(colNum);
                if (aValue == null) continue;
                if (aValue instanceof Integer) {
                    rowNode.get(columns.get(colNum)).set(((Integer)aValue).intValue());
                    continue;
                }
                if (aValue instanceof Long) {
                    rowNode.get(columns.get(colNum)).set(((Long)aValue).longValue());
                    continue;
                }
                if (aValue instanceof Double) {
                    rowNode.get(columns.get(colNum)).set(((Double)aValue).doubleValue());
                    continue;
                }
                if (aValue instanceof Boolean) {
                    rowNode.get(columns.get(colNum)).set(((Boolean)aValue).booleanValue());
                    continue;
                }
                if (aValue instanceof BigInteger) {
                    rowNode.get(columns.get(colNum)).set((BigInteger)aValue);
                    continue;
                }
                if (aValue instanceof BigDecimal) {
                    rowNode.get(columns.get(colNum)).set((BigDecimal)aValue);
                    continue;
                }
                if (aValue instanceof Timestamp && !timeAsString) {
                    rowNode.get(columns.get(colNum)).set(((Timestamp)aValue).getTime());
                    continue;
                }
                if (aValue instanceof Date && !timeAsString) {
                    rowNode.get(columns.get(colNum)).set(((Date)aValue).getTime());
                    continue;
                }
                if (aValue instanceof Time && !timeAsString) {
                    rowNode.get(columns.get(colNum)).set(((Time)aValue).getTime());
                    continue;
                }
                if (aValue instanceof String) {
                    rowNode.get(new String[]{columns.get(colNum), "type"}).set(ModelType.STRING);
                    rowNode.get(columns.get(colNum)).set((String)aValue);
                    continue;
                }
                if (aValue instanceof Blob) {
                    rowNode.get(new String[]{columns.get(colNum), "type"}).set(ModelType.OBJECT);
                    rowNode.get(columns.get(colNum)).set("blob");
                    continue;
                }
                if (aValue instanceof Clob) {
                    rowNode.get(new String[]{columns.get(colNum), "type"}).set(ModelType.OBJECT);
                    rowNode.get(columns.get(colNum)).set("clob");
                    continue;
                }
                if (aValue instanceof SQLXML) {
                    SQLXML xml = (SQLXML)aValue;
                    rowNode.get(new String[]{columns.get(colNum), "type"}).set(ModelType.STRING);
                    rowNode.get(columns.get(colNum)).set(xml.getString());
                    continue;
                }
                rowNode.get(new String[]{columns.get(colNum), "type"}).set(ModelType.STRING);
                rowNode.get(columns.get(colNum)).set(aValue.toString());
            }
            resultsNode.add(rowNode);
        }
    }
}

