/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.core.TeiidComponentException;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.OperationsConstants;
import org.teiid.jboss.TeiidOperationHandler;

class CancelRequest
extends TeiidOperationHandler {
    protected CancelRequest() {
        super("cancel-request", true);
    }

    @Override
    protected void executeOperation(OperationContext context, DQPCore engine, ModelNode operation) throws OperationFailedException {
        try {
            if (!operation.hasDefined(OperationsConstants.SESSION.getName())) {
                throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.SESSION.getName() + ".missing")));
            }
            if (!operation.hasDefined(OperationsConstants.EXECUTION_ID.getName())) {
                throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.EXECUTION_ID.getName() + ".missing")));
            }
            boolean pass = engine.cancelRequest(operation.get(OperationsConstants.SESSION.getName()).asString(), operation.get(OperationsConstants.EXECUTION_ID.getName()).asLong());
            ModelNode result = context.getResult();
            result.set(pass);
        }
        catch (TeiidComponentException e) {
            throw new OperationFailedException((Throwable)e, new ModelNode().set(e.getMessage()));
        }
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        builder.addParameter((AttributeDefinition)OperationsConstants.SESSION);
        builder.addParameter((AttributeDefinition)OperationsConstants.EXECUTION_ID);
        builder.setReplyType(ModelType.BOOLEAN);
    }
}

