/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiParam;
import io.swagger.converter.ModelConverters;
import io.swagger.models.Model;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.PropertyBuilder;
import io.swagger.util.AllowableValues;
import io.swagger.util.AllowableValuesUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.core.Context;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterProcessor {
    static Logger LOGGER = LoggerFactory.getLogger(ParameterProcessor.class);

    public static Parameter applyAnnotations(Swagger swagger, Parameter parameter, Type type, List<Annotation> annotations) {
        AnnotationsHelper helper = new AnnotationsHelper(annotations);
        if (helper.isContext()) {
            return null;
        }
        ParamWrapper<?> param = helper.getApiParam();
        if (param.isHidden()) {
            return null;
        }
        String defaultValue = helper.getDefaultValue();
        JavaType javaType = TypeFactory.defaultInstance().constructType(type);
        if (parameter instanceof AbstractSerializableParameter) {
            AbstractSerializableParameter p = (AbstractSerializableParameter)parameter;
            if (param.isRequired()) {
                p.setRequired(true);
            }
            if (StringUtils.isNotEmpty((CharSequence)param.getName())) {
                p.setName(param.getName());
            }
            if (StringUtils.isNotEmpty((CharSequence)param.getDescription())) {
                p.setDescription(param.getDescription());
            }
            if (StringUtils.isNotEmpty((CharSequence)param.getAccess())) {
                p.setAccess(param.getAccess());
            }
            if (StringUtils.isNotEmpty((CharSequence)param.getDataType())) {
                p.setType(param.getDataType());
            }
            AllowableValues allowableValues = AllowableValuesUtils.create((String)param.getAllowableValues());
            if (p.getItems() != null || param.isAllowMultiple()) {
                EnumMap<PropertyBuilder.PropertyId, Object> args;
                if (p.getItems() == null) {
                    args = new EnumMap<PropertyBuilder.PropertyId, Object>(PropertyBuilder.PropertyId.class);
                    args.put(PropertyBuilder.PropertyId.DEFAULT, (Object)p.getDefaultValue());
                    p.setDefaultValue(null);
                    args.put(PropertyBuilder.PropertyId.ENUM, (Object)p.getEnum());
                    p.setEnum(null);
                    args.put(PropertyBuilder.PropertyId.MINIMUM, (Object)p.getMinimum());
                    p.setMinimum(null);
                    args.put(PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM, (Object)p.isExclusiveMinimum());
                    p.setExclusiveMinimum(null);
                    args.put(PropertyBuilder.PropertyId.MAXIMUM, (Object)p.getMaximum());
                    p.setMaximum(null);
                    args.put(PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM, (Object)p.isExclusiveMaximum());
                    p.setExclusiveMaximum(null);
                    Property items = PropertyBuilder.build((String)p.getType(), (String)p.getFormat(), args);
                    p.type("array").format(null).items(items);
                }
                args = new EnumMap(PropertyBuilder.PropertyId.class);
                if (StringUtils.isNotEmpty((CharSequence)defaultValue)) {
                    args.put(PropertyBuilder.PropertyId.DEFAULT, (Object)defaultValue);
                }
                if (allowableValues != null) {
                    args.putAll(allowableValues.asPropertyArguments());
                }
                PropertyBuilder.merge((Property)p.getItems(), args);
            } else {
                if (StringUtils.isNotEmpty((CharSequence)defaultValue)) {
                    p.setDefaultValue(defaultValue);
                }
                ParameterProcessor.processAllowedValues(allowableValues, p);
            }
        } else {
            Property property;
            BodyParameter bp = new BodyParameter();
            bp.setRequired(param.isRequired());
            bp.setName(StringUtils.isNotEmpty((CharSequence)param.getName()) ? param.getName() : "body");
            if (StringUtils.isNotEmpty((CharSequence)param.getDescription())) {
                bp.setDescription(param.getDescription());
            }
            if (StringUtils.isNotEmpty((CharSequence)param.getAccess())) {
                bp.setAccess(param.getAccess());
            }
            if ((property = ModelConverters.getInstance().readAsProperty((Type)javaType)) != null) {
                EnumMap<PropertyBuilder.PropertyId, String> args = new EnumMap<PropertyBuilder.PropertyId, String>(PropertyBuilder.PropertyId.class);
                if (StringUtils.isNotEmpty((CharSequence)defaultValue)) {
                    args.put(PropertyBuilder.PropertyId.DEFAULT, defaultValue);
                }
                bp.setSchema(PropertyBuilder.toModel((Property)PropertyBuilder.merge((Property)property, args)));
                for (Map.Entry entry : ModelConverters.getInstance().readAll((Type)javaType).entrySet()) {
                    swagger.addDefinition((String)entry.getKey(), (Model)entry.getValue());
                }
            }
            parameter = bp;
        }
        return parameter;
    }

    private static void processAllowedValues(AllowableValues allowableValues, AbstractSerializableParameter<?> p) {
        if (allowableValues == null) {
            return;
        }
        Map args = allowableValues.asPropertyArguments();
        if (args.containsKey(PropertyBuilder.PropertyId.ENUM)) {
            p.setEnum((List)args.get(PropertyBuilder.PropertyId.ENUM));
        } else {
            if (args.containsKey(PropertyBuilder.PropertyId.MINIMUM)) {
                p.setMinimum((Double)args.get(PropertyBuilder.PropertyId.MINIMUM));
            }
            if (args.containsKey(PropertyBuilder.PropertyId.MAXIMUM)) {
                p.setMaximum((Double)args.get(PropertyBuilder.PropertyId.MAXIMUM));
            }
            if (args.containsKey(PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM)) {
                p.setExclusiveMinimum((Boolean)args.get(PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM) != false ? Boolean.valueOf(true) : null);
            }
            if (args.containsKey(PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM)) {
                p.setExclusiveMaximum((Boolean)args.get(PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM) != false ? Boolean.valueOf(true) : null);
            }
        }
    }

    private static final class ApiImplicitParamWrapper
    implements ParamWrapper<ApiImplicitParam> {
        private final ApiImplicitParam apiParam;

        private ApiImplicitParamWrapper(ApiImplicitParam apiParam) {
            this.apiParam = apiParam;
        }

        @Override
        public String getName() {
            return this.apiParam.name();
        }

        @Override
        public String getDescription() {
            return this.apiParam.value();
        }

        @Override
        public String getDefaultValue() {
            return this.apiParam.defaultValue();
        }

        @Override
        public String getAllowableValues() {
            return this.apiParam.allowableValues();
        }

        @Override
        public boolean isRequired() {
            return this.apiParam.required();
        }

        @Override
        public String getAccess() {
            return this.apiParam.access();
        }

        @Override
        public boolean isAllowMultiple() {
            return this.apiParam.allowMultiple();
        }

        @Override
        public String getDataType() {
            return this.apiParam.dataType();
        }

        @Override
        public String getParamType() {
            return this.apiParam.paramType();
        }

        @Override
        public ApiImplicitParam getAnnotation() {
            return this.apiParam;
        }

        @Override
        public boolean isHidden() {
            return false;
        }
    }

    private static final class ApiParamWrapper
    implements ParamWrapper<ApiParam> {
        private final ApiParam apiParam;

        private ApiParamWrapper(ApiParam apiParam) {
            this.apiParam = apiParam;
        }

        @Override
        public String getName() {
            return this.apiParam.name();
        }

        @Override
        public String getDescription() {
            return this.apiParam.value();
        }

        @Override
        public String getDefaultValue() {
            return this.apiParam.defaultValue();
        }

        @Override
        public String getAllowableValues() {
            return this.apiParam.allowableValues();
        }

        @Override
        public boolean isRequired() {
            return this.apiParam.required();
        }

        @Override
        public String getAccess() {
            return this.apiParam.access();
        }

        @Override
        public boolean isAllowMultiple() {
            return this.apiParam.allowMultiple();
        }

        @Override
        public String getDataType() {
            return null;
        }

        @Override
        public String getParamType() {
            return null;
        }

        @Override
        public ApiParam getAnnotation() {
            return this.apiParam;
        }

        @Override
        public boolean isHidden() {
            return this.apiParam.hidden();
        }
    }

    private static class AnnotationsHelper {
        private static final ApiParam DEFAULT_API_PARAM = AnnotationsHelper.getDefaultApiParam(null);
        private boolean context;
        private ParamWrapper<?> apiParam = new ApiParamWrapper(DEFAULT_API_PARAM);
        private String defaultValue;

        public AnnotationsHelper(List<Annotation> annotations) {
            String rsDefault = null;
            for (Annotation item : annotations) {
                if (item instanceof Context) {
                    this.context = true;
                    continue;
                }
                if (item instanceof ApiParam) {
                    this.apiParam = new ApiParamWrapper((ApiParam)item);
                    continue;
                }
                if (item instanceof ApiImplicitParam) {
                    this.apiParam = new ApiImplicitParamWrapper((ApiImplicitParam)item);
                    continue;
                }
                if (!(item instanceof DefaultValue)) continue;
                rsDefault = ((DefaultValue)item).value();
            }
            this.defaultValue = StringUtils.isNotEmpty((CharSequence)this.apiParam.getDefaultValue()) ? this.apiParam.getDefaultValue() : rsDefault;
        }

        private static ApiParam getDefaultApiParam(@ApiParam String annotationHolder) {
            for (Method method : AnnotationsHelper.class.getDeclaredMethods()) {
                if (!"getDefaultApiParam".equals(method.getName())) continue;
                return (ApiParam)method.getParameterAnnotations()[0][0];
            }
            throw new IllegalStateException("Failed to locate default @ApiParam");
        }

        public boolean isContext() {
            return this.context;
        }

        public ParamWrapper<?> getApiParam() {
            return this.apiParam;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }

    public static interface ParamWrapper<T extends Annotation> {
        public String getName();

        public String getDescription();

        public String getDefaultValue();

        public String getAllowableValues();

        public boolean isRequired();

        public String getAccess();

        public boolean isAllowMultiple();

        public String getDataType();

        public String getParamType();

        public T getAnnotation();

        public boolean isHidden();
    }
}

