/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs.utils;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(PathUtils.class);
    private static final char COLON = ':';
    private static final char OPEN = '{';
    private static final char CLOSE = '}';
    private static final char SLASH = '/';

    public static String parsePath(String uri, Map<String, String> patterns) {
        if (uri == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)uri)) {
            return String.valueOf('/');
        }
        StringCharacterIterator ci = new StringCharacterIterator(uri);
        StringBuilder pathBuffer = new StringBuilder();
        char c = ci.first();
        if (c == '\uffff') {
            return String.valueOf('/');
        }
        do {
            if (c == '{') {
                String regexBuffer = PathUtils.cutParameter(ci, patterns);
                if (regexBuffer == null) {
                    LOGGER.warn("Operation path \"" + uri + "\" contains syntax error.");
                    return null;
                }
                pathBuffer.append(regexBuffer);
                continue;
            }
            int length = pathBuffer.length();
            if (c == '/' && length != 0 && pathBuffer.charAt(length - 1) == '/') continue;
            pathBuffer.append(c);
        } while ((c = ci.next()) != '\uffff');
        return pathBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String cutParameter(CharacterIterator ci, Map<String, String> patterns) {
        StringBuilder regexBuffer = new StringBuilder();
        int braceCount = 1;
        char regexChar = ci.next();
        while (regexChar != '\uffff') {
            if (regexChar == '{') {
                ++braceCount;
            } else if (regexChar == '}' && --braceCount == 0) break;
            regexBuffer.append(regexChar);
            regexChar = ci.next();
        }
        if (braceCount != 0) {
            return null;
        }
        String regex = StringUtils.trimToNull((String)regexBuffer.toString());
        if (regex == null) {
            return null;
        }
        StringBuilder pathBuffer = new StringBuilder();
        pathBuffer.append('{');
        int index = regex.indexOf(58);
        if (index != -1) {
            String name = StringUtils.trimToNull((String)regex.substring(0, index));
            String value = StringUtils.trimToNull((String)regex.substring(index + 1, regex.length()));
            if (name == null) return null;
            pathBuffer.append(name);
            if (value != null) {
                patterns.put(name, value);
            }
        } else {
            pathBuffer.append(regex);
        }
        pathBuffer.append('}');
        return pathBuffer.toString();
    }
}

