/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.impl.CacheStatisticsMetadata;
import org.teiid.adminapi.jboss.VDBMetadataMapper;
import org.teiid.core.BundleUtil;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.jboss.BaseCachehandler;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.OperationsConstants;

class CacheStatistics
extends BaseCachehandler {
    protected CacheStatistics() {
        super("cache-statistics");
    }

    @Override
    protected void executeOperation(OperationContext context, SessionAwareCache cache, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined(OperationsConstants.CACHE_TYPE.getName())) {
            throw new OperationFailedException(IntegrationPlugin.Util.getString(OperationsConstants.CACHE_TYPE.getName() + ".missing"));
        }
        String cacheType = operation.get(OperationsConstants.CACHE_TYPE.getName()).asString();
        if (cache == null) {
            throw new OperationFailedException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50071, new Object[]{cacheType}));
        }
        ModelNode result = context.getResult();
        CacheStatisticsMetadata stats = cache.buildCacheStats(cacheType);
        VDBMetadataMapper.CacheStatisticsMetadataMapper.INSTANCE.wrap(stats, result);
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        builder.addParameter((AttributeDefinition)OperationsConstants.CACHE_TYPE);
        builder.setReplyType(ModelType.LIST);
        builder.setReplyParameters(VDBMetadataMapper.CacheStatisticsMetadataMapper.INSTANCE.getAttributeDefinitions());
    }
}

