/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.acl.Group;
import java.util.HashMap;
import java.util.Map;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.vault.SecurityVaultException;
import org.jboss.security.vault.SecurityVaultUtil;
import org.picketbox.datasource.security.AbstractPasswordCredentialLoginModule;
import org.teiid.OAuthCredentialContext;
import org.teiid.jboss.SecurityActions;

public class PassthroughIdentityLoginModule
extends AbstractPasswordCredentialLoginModule {
    private String userName;
    private char[] password;
    private Subject callerSubject;
    private boolean addPrincipal = true;
    private HashMap<String, Object> properties = new HashMap();

    public void initialize(Subject subject, CallbackHandler handler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, handler, sharedState, options);
        this.userName = (String)options.get("username");
        String pass = (String)options.get("password");
        if (pass != null) {
            if (SecurityVaultUtil.isVaultFormat((String)pass)) {
                try {
                    pass = SecurityVaultUtil.getValueAsString((String)pass);
                }
                catch (SecurityVaultException e) {
                    throw new RuntimeException(e);
                }
                this.password = pass.toCharArray();
            } else {
                this.password = pass.toCharArray();
            }
        }
        this.properties.putAll(options);
    }

    public boolean login() throws LoginException {
        String username = this.userName;
        try {
            Principal user = PassthroughIdentityLoginModule.getPrincipal();
            this.callerSubject = PassthroughIdentityLoginModule.getSubject();
            this.addPrincipal = false;
            if (user != null) {
                username = user.getName();
            }
        }
        catch (Throwable e) {
            throw new LoginException(e.getMessage());
        }
        this.userName = username;
        if (super.login()) {
            return true;
        }
        this.sharedState.put("javax.security.auth.login.name", username);
        this.loginOk = true;
        return true;
    }

    public boolean commit() throws LoginException {
        this.sharedState.put("javax.security.auth.login.name", this.userName);
        if (this.addPrincipal) {
            this.subject.getPrincipals().add(this.getIdentity());
            if (this.password != null) {
                PasswordCredential cred = new PasswordCredential(this.userName, this.password);
                SecurityActions.addCredentials(this.subject, cred);
            }
        }
        if (this.callerSubject != null) {
            PassthroughIdentityLoginModule.makeCopy(this.callerSubject, this.subject);
        }
        PassthroughIdentityLoginModule.addPrivateCredential(this.subject, this.properties);
        if (OAuthCredentialContext.getCredential() != null) {
            PassthroughIdentityLoginModule.addPrivateCredential(this.subject, OAuthCredentialContext.getCredential());
        }
        return true;
    }

    protected Principal getIdentity() {
        SimplePrincipal principal = new SimplePrincipal(this.userName);
        return principal;
    }

    protected Group[] getRoleSets() throws LoginException {
        return new Group[0];
    }

    static Principal getPrincipal() {
        if (System.getSecurityManager() == null) {
            return SecurityContextAssociation.getPrincipal();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Principal>(){

            @Override
            public Principal run() {
                return SecurityContextAssociation.getPrincipal();
            }
        });
    }

    static Subject getSubject() {
        if (System.getSecurityManager() == null) {
            return SecurityContextAssociation.getSubject();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                return SecurityContextAssociation.getSubject();
            }
        });
    }

    static Object makeCopy(final Subject from, final Subject to) {
        if (System.getSecurityManager() == null) {
            PassthroughIdentityLoginModule.copy(from, to);
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                PassthroughIdentityLoginModule.copy(from, to);
                return null;
            }
        });
    }

    static void copy(Subject from, Subject to) {
        for (Principal p : from.getPrincipals()) {
            to.getPrincipals().add(p);
        }
        for (Object obj : from.getPrivateCredentials()) {
            to.getPrivateCredentials().add(obj);
        }
        for (Object obj : from.getPublicCredentials()) {
            to.getPublicCredentials().add(obj);
        }
    }

    static void addPrivateCredential(final Subject subject, final Object obj) {
        if (System.getSecurityManager() == null) {
            subject.getPrivateCredentials().add(obj);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    subject.getPrivateCredentials().add(obj);
                    return null;
                }
            });
        }
    }
}

