/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.teiid.deployers.RuntimeVDB;
import org.teiid.jboss.BaseOperationHandler;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.OperationsConstants;
import org.teiid.jboss.TeiidOperationHandler;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.jboss.VDBDeployer;
import org.teiid.vdb.runtime.VDBKey;

abstract class VDBOperations
extends BaseOperationHandler<RuntimeVDB> {
    boolean changesRuntimeState;

    public VDBOperations(String operationName) {
        super(operationName);
    }

    public VDBOperations(String operationName, boolean changesRuntimeState) {
        super(operationName, changesRuntimeState);
        this.changesRuntimeState = changesRuntimeState;
    }

    @Override
    public RuntimeVDB getService(OperationContext context, PathAddress pathAddress, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined(OperationsConstants.VDB_NAME.getName())) {
            throw new OperationFailedException(IntegrationPlugin.Util.getString(OperationsConstants.VDB_NAME.getName() + ".missing"));
        }
        if (!operation.hasDefined(OperationsConstants.VDB_VERSION.getName())) {
            throw new OperationFailedException(IntegrationPlugin.Util.getString(OperationsConstants.VDB_VERSION.getName() + ".missing"));
        }
        String vdbName = operation.get(OperationsConstants.VDB_NAME.getName()).asString();
        int vdbVersion = operation.get(OperationsConstants.VDB_VERSION.getName()).asInt();
        TeiidOperationHandler.checkVDB(context, vdbName, vdbVersion);
        ServiceController sc = context.getServiceRegistry(this.changesRuntimeState).getRequiredService(TeiidServiceNames.vdbServiceName(vdbName, vdbVersion));
        return (RuntimeVDB)RuntimeVDB.class.cast(sc.getValue());
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        builder.addParameter((AttributeDefinition)OperationsConstants.VDB_NAME);
        builder.addParameter((AttributeDefinition)OperationsConstants.VDB_VERSION);
    }

    static void updateServices(OperationContext context, RuntimeVDB vdb, String dsName, RuntimeVDB.ReplaceResult rr) {
        if (rr.isNew) {
            VDBDeployer.addDataSourceListener(context.getServiceTarget(), new VDBKey(vdb.getVdb().getName(), vdb.getVdb().getVersion()), dsName);
        }
        if (rr.removedDs != null) {
            ServiceName serviceName;
            ServiceRegistry registry = context.getServiceRegistry(true);
            try {
                serviceName = TeiidServiceNames.dsListenerServiceName(vdb.getVdb().getName(), vdb.getVdb().getVersion(), rr.removedDs);
            }
            catch (TeiidServiceNames.InvalidServiceNameException e) {
                return;
            }
            ServiceController controller = registry.getService(serviceName);
            if (controller != null) {
                context.removeService(serviceName);
            }
        }
    }
}

