/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.WireProtocol;

public class SocketConfiguration {
    private int outputBufferSize;
    private int inputBufferSize;
    private int maxSocketThreads;
    private int portNumber;
    private InetAddress hostAddress;
    private SSLConfiguration sslConfiguration;
    private String hostName;
    private String name;
    private WireProtocol protocol = WireProtocol.teiid;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBindAddress(String addr) {
        this.hostName = addr;
    }

    public void setPortNumber(int port) {
        this.portNumber = port;
    }

    public void setMaxSocketThreads(int value) {
        this.maxSocketThreads = value;
    }

    public void setInputBufferSize(int value) {
        this.inputBufferSize = value;
    }

    public void setOutputBufferSize(int value) {
        this.outputBufferSize = value;
    }

    public void setSSLConfiguration(SSLConfiguration value) {
        this.sslConfiguration = value;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public int getMaxSocketThreads() {
        return this.maxSocketThreads;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public InetAddress getHostAddress() {
        return this.hostAddress;
    }

    public InetAddress getResolvedHostAddress() throws UnknownHostException {
        InetAddress addr;
        if (this.hostAddress != null) {
            return this.hostAddress;
        }
        if (this.hostName == null) {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        if ((addr = InetAddress.getByName(this.hostName)).getHostAddress().equalsIgnoreCase(this.hostName)) {
            this.hostAddress = addr;
        }
        return addr;
    }

    public void setHostAddress(InetAddress hostAddress) {
        this.hostAddress = hostAddress;
        this.hostName = hostAddress.getHostName();
    }

    public String getHostName() {
        return this.hostName;
    }

    public SSLConfiguration getSSLConfiguration() {
        return this.sslConfiguration;
    }

    public boolean getSslEnabled() {
        return this.sslConfiguration != null && this.sslConfiguration.isSslEnabled();
    }

    public WireProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = WireProtocol.valueOf(protocol);
    }

    public void setProtocol(WireProtocol protocol) {
        this.protocol = protocol;
    }
}

