/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.List;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class WithQueryCommand
implements SubqueryContainer<QueryCommand> {
    public static final String NO_INLINE = "no_inline";
    private GroupSymbol groupSymbol;
    private List<ElementSymbol> columns;
    private QueryCommand queryExpression;
    private TupleBuffer tupleBuffer;
    private boolean recursive;
    private boolean noInline;

    public WithQueryCommand(GroupSymbol groupSymbol, List<ElementSymbol> columns, QueryCommand queryExpression) {
        this.groupSymbol = groupSymbol;
        this.columns = columns;
        this.queryExpression = queryExpression;
    }

    public GroupSymbol getGroupSymbol() {
        return this.groupSymbol;
    }

    public void setColumns(List<ElementSymbol> columns) {
        this.columns = columns;
    }

    public List<ElementSymbol> getColumns() {
        return this.columns;
    }

    @Override
    public QueryCommand getCommand() {
        return this.queryExpression;
    }

    @Override
    public void setCommand(QueryCommand command) {
        this.queryExpression = command;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public WithQueryCommand clone() {
        WithQueryCommand clone = new WithQueryCommand(this.groupSymbol.clone(), LanguageObject.Util.deepClone(this.columns, ElementSymbol.class), null);
        if (this.queryExpression != null) {
            clone.queryExpression = (QueryCommand)this.queryExpression.clone();
        }
        clone.tupleBuffer = this.tupleBuffer;
        clone.recursive = this.recursive;
        clone.noInline = this.noInline;
        return clone;
    }

    public int hashCode() {
        return this.groupSymbol.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WithQueryCommand)) {
            return false;
        }
        WithQueryCommand other = (WithQueryCommand)obj;
        return EquivalenceUtil.areEqual((Object)this.groupSymbol, (Object)other.getGroupSymbol()) && EquivalenceUtil.areEqual(this.columns, other.getColumns()) && EquivalenceUtil.areEqual((Object)this.queryExpression, (Object)other.queryExpression) && this.noInline == other.noInline;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public void setTupleBuffer(TupleBuffer tupleBuffer) {
        this.tupleBuffer = tupleBuffer;
    }

    public TupleBuffer getTupleBuffer() {
        return this.tupleBuffer;
    }

    public void setGroupSymbol(GroupSymbol groupSymbol) {
        this.groupSymbol = groupSymbol;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean isNoInline() {
        return this.noInline;
    }

    public void setNoInline(boolean noUnnest) {
        this.noInline = noUnnest;
    }
}

