/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.memory;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class SynonymMap {
    private final HashMap table;
    private static final String[] EMPTY = new String[0];
    private static final boolean DEBUG = false;

    public SynonymMap(InputStream input) throws IOException {
        this.table = input == null ? new HashMap(0) : this.read(SynonymMap.toByteArray(input));
    }

    public String[] getSynonyms(String word) {
        Object syns = this.table.get(word);
        if (syns == null) {
            return EMPTY;
        }
        if (syns instanceof String) {
            return new String[]{(String)syns};
        }
        String[] synonyms = (String[])syns;
        String[] copy = new String[synonyms.length];
        System.arraycopy(synonyms, 0, copy, 0, synonyms.length);
        return copy;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator iter = new TreeMap(this.table).keySet().iterator();
        int count = 0;
        int f0 = 0;
        int f1 = 0;
        int f2 = 0;
        int f3 = 0;
        while (iter.hasNext()) {
            String word = (String)iter.next();
            buf.append(String.valueOf(word) + ":");
            String[] synonyms = this.getSynonyms(word);
            buf.append(Arrays.asList(synonyms));
            buf.append("\n");
            count += synonyms.length;
            if (synonyms.length == 0) {
                ++f0;
            }
            if (synonyms.length == 1) {
                ++f1;
            }
            if (synonyms.length == 2) {
                ++f2;
            }
            if (synonyms.length != 3) continue;
            ++f3;
        }
        buf.append("\n\nkeys=" + this.table.size() + ", synonyms=" + count + ", f0=" + f0 + ", f1=" + f1 + ", f2=" + f2 + ", f3=" + f3);
        return buf.toString();
    }

    protected String analyze(String word) {
        return word.toLowerCase();
    }

    private static boolean isValid(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (Character.isLetter(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private HashMap read(byte[] data) {
        WORDS = 109144;
        GROUPS = 125745;
        word2Groups = new HashMap<String, ArrayList<Integer>>(WORDS);
        group2Words = new HashMap<Integer, ArrayList<String>>(GROUPS);
        internedWords = new HashMap<String, String>(WORDS);
        charset = Charset.forName("UTF-8");
        lastNum = -1;
        lastGroup = null;
        len = data.length;
        i = 0;
        ** GOTO lbl60
        {
            ++i;
            do {
                if (i < len && data[i] != 40) continue block0;
                if (i >= len) break block0;
                ++i;
                num = 0;
                while (i < len && data[i] != 44) {
                    num = 10 * num + (data[i] - 48);
                    ++i;
                }
                ++i;
                while (i < len && data[i] != 39) {
                    ++i;
                }
                start = ++i;
                while (true) {
                    if (i < len && data[i] != 39) {
                        ++i;
                        continue;
                    }
                    if (++i >= len || data[i] == 44) break;
                }
                if (i >= len) break block0;
                word = charset.decode(ByteBuffer.wrap(data, start, i - start - 1)).toString();
                if (!SynonymMap.isValid(word) || (word = this.analyze(word)) == null || word.length() == 0) continue;
                w = (String)internedWords.get(word);
                if (w == null) {
                    word = new String(word);
                    internedWords.put(word, word);
                } else {
                    word = w;
                }
                group = lastGroup;
                if (num != lastNum) {
                    lastGroup = group = new Integer(num);
                    lastNum = num;
                }
                if ((groups = (ArrayList<Integer>)word2Groups.get(word)) == null) {
                    groups = new ArrayList<Integer>(1);
                    word2Groups.put(word, groups);
                }
                groups.add(group);
                words = (ArrayList<String>)group2Words.get(group);
                if (words == null) {
                    words = new ArrayList<String>(1);
                    group2Words.put(group, words);
                }
                words.add(word);
lbl60:
                // 3 sources

            } while (i < len);
        }
        word2Syns = this.createIndex(word2Groups, group2Words);
        word2Groups = null;
        group2Words = null;
        return this.optimize(word2Syns, internedWords);
    }

    private HashMap createIndex(Map word2Groups, Map group2Words) {
        HashMap<String, String[]> word2Syns = new HashMap<String, String[]>();
        Iterator iter = word2Groups.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ArrayList group = (ArrayList)entry.getValue();
            String word = (String)entry.getKey();
            TreeSet synonyms = new TreeSet();
            int i = group.size();
            while (--i >= 0) {
                ArrayList words = (ArrayList)group2Words.get(group.get(i));
                int j = words.size();
                while (--j >= 0) {
                    Object synonym = words.get(j);
                    if (synonym == word) continue;
                    synonyms.add(synonym);
                }
            }
            int size = synonyms.size();
            if (size <= 0) continue;
            String[] syns = new String[size];
            if (size == 1) {
                syns[0] = (String)synonyms.first();
            } else {
                synonyms.toArray(syns);
            }
            word2Syns.put(word, syns);
        }
        return word2Syns;
    }

    private HashMap optimize(HashMap word2Syns, HashMap internedWords) {
        int len = 0;
        int size = word2Syns.size();
        String[][] allSynonyms = new String[size][];
        String[] words = new String[size];
        Iterator iter = word2Syns.entrySet().iterator();
        int j = 0;
        while (j < size) {
            Map.Entry entry = iter.next();
            allSynonyms[j] = (String[])entry.getValue();
            words[j] = (String)entry.getKey();
            len += words[j].length();
            ++j;
        }
        StringBuffer buf = new StringBuffer(len);
        int j2 = 0;
        while (j2 < size) {
            buf.append(words[j2]);
            ++j2;
        }
        String allWords = new String(buf.toString());
        buf = null;
        int p = 0;
        int j3 = 0;
        while (j3 < size) {
            String word = words[j3];
            internedWords.put(word, allWords.substring(p, p + word.length()));
            p += word.length();
            ++j3;
        }
        int j4 = 0;
        while (j4 < size) {
            String[] syns = allSynonyms[j4];
            int k = syns.length;
            while (--k >= 0) {
                syns[k] = (String)internedWords.get(syns[k]);
            }
            Object replacement = syns;
            if (syns.length == 1) {
                replacement = syns[0];
            }
            word2Syns.remove(words[j4]);
            word2Syns.put(internedWords.get(words[j4]), replacement);
            ++j4;
        }
        return word2Syns;
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        byte[] byArray;
        block8: {
            byte[] output;
            byte[] buffer;
            int len;
            block6: {
                byte[] byArray2;
                block7: {
                    try {
                        int n;
                        len = Math.max(256, input.available());
                        buffer = new byte[len];
                        output = new byte[len];
                        len = 0;
                        while ((n = input.read(buffer)) >= 0) {
                            if (len + n > output.length) {
                                byte[] tmp = new byte[Math.max(output.length << 1, len + n)];
                                System.arraycopy(output, 0, tmp, 0, len);
                                System.arraycopy(buffer, 0, tmp, len, n);
                                buffer = output;
                                output = tmp;
                            } else {
                                System.arraycopy(buffer, 0, output, len, n);
                            }
                            len += n;
                        }
                        if (len != output.length) break block6;
                        byArray2 = output;
                        Object var6_8 = null;
                        if (input == null) break block7;
                    }
                    catch (Throwable throwable) {
                        block9: {
                            Object var6_10 = null;
                            if (input == null) break block9;
                            input.close();
                        }
                        throw throwable;
                    }
                    input.close();
                }
                return byArray2;
            }
            buffer = null;
            buffer = new byte[len];
            System.arraycopy(output, 0, buffer, 0, len);
            byArray = buffer;
            Object var6_9 = null;
            if (input == null) break block8;
            input.close();
        }
        return byArray;
    }
}

