/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.AzimuthalProjection;
import org.osgeo.proj4j.util.ProjectionMath;

public class EqualAreaAzimuthalProjection
extends AzimuthalProjection {
    private double sinb1;
    private double cosb1;
    private double xmf;
    private double ymf;
    private double mmf;
    private double qp;
    private double dd;
    private double rq;
    private double[] apa;

    public EqualAreaAzimuthalProjection() {
        this.initialize();
    }

    public Object clone() {
        EqualAreaAzimuthalProjection p = (EqualAreaAzimuthalProjection)super.clone();
        if (this.apa != null) {
            p.apa = (double[])this.apa.clone();
        }
        return p;
    }

    public void initialize() {
        super.initialize();
        if (this.spherical) {
            if (this.mode == 4) {
                this.sinphi0 = Math.sin(this.projectionLatitude);
                this.cosphi0 = Math.cos(this.projectionLatitude);
            }
        } else {
            this.qp = ProjectionMath.qsfn(1.0, this.e, this.one_es);
            this.mmf = 0.5 / (1.0 - this.es);
            this.apa = ProjectionMath.authset(this.es);
            switch (this.mode) {
                case 1: 
                case 2: {
                    this.dd = 1.0;
                    break;
                }
                case 3: {
                    this.rq = Math.sqrt(0.5 * this.qp);
                    this.dd = 1.0 / this.rq;
                    this.xmf = 1.0;
                    this.ymf = 0.5 * this.qp;
                    break;
                }
                case 4: {
                    this.rq = Math.sqrt(0.5 * this.qp);
                    double sinphi = Math.sin(this.projectionLatitude);
                    this.sinb1 = ProjectionMath.qsfn(sinphi, this.e, this.one_es) / this.qp;
                    this.cosb1 = Math.sqrt(1.0 - this.sinb1 * this.sinb1);
                    this.dd = Math.cos(this.projectionLatitude) / (Math.sqrt(1.0 - this.es * sinphi * sinphi) * this.rq * this.cosb1);
                    this.xmf = this.rq;
                    this.ymf = this.xmf / this.dd;
                    this.xmf *= this.dd;
                }
            }
        }
    }

    public ProjCoordinate project(double lam, double phi, ProjCoordinate xy) {
        if (this.spherical) {
            double sinphi = Math.sin(phi);
            double cosphi = Math.cos(phi);
            double coslam = Math.cos(lam);
            switch (this.mode) {
                case 3: {
                    xy.y = 1.0 + cosphi * coslam;
                    if (xy.y <= 1.0E-10) {
                        throw new ProjectionException();
                    }
                    xy.y = Math.sqrt(2.0 / xy.y);
                    xy.x = xy.y * cosphi * Math.sin(lam);
                    xy.y = xy.y * (this.mode == 3 ? sinphi : this.cosphi0 * sinphi - this.sinphi0 * cosphi * coslam);
                    break;
                }
                case 4: {
                    xy.y = 1.0 + this.sinphi0 * sinphi + this.cosphi0 * cosphi * coslam;
                    if (xy.y <= 1.0E-10) {
                        throw new ProjectionException();
                    }
                    xy.y = Math.sqrt(2.0 / xy.y);
                    xy.x = xy.y * cosphi * Math.sin(lam);
                    xy.y = xy.y * (this.mode == 3 ? sinphi : this.cosphi0 * sinphi - this.sinphi0 * cosphi * coslam);
                    break;
                }
                case 1: {
                    coslam = -coslam;
                }
                case 2: {
                    if (Math.abs(phi + this.projectionLatitude) < 1.0E-10) {
                        throw new ProjectionException();
                    }
                    xy.y = 0.7853981633974483 - phi * 0.5;
                    xy.y = 2.0 * (this.mode == 2 ? Math.cos(xy.y) : Math.sin(xy.y));
                    xy.x = xy.y * Math.sin(lam);
                    xy.y *= coslam;
                }
            }
        } else {
            double sinb = 0.0;
            double cosb = 0.0;
            double b = 0.0;
            double coslam = Math.cos(lam);
            double sinlam = Math.sin(lam);
            double sinphi = Math.sin(phi);
            double q = ProjectionMath.qsfn(sinphi, this.e, this.one_es);
            if (this.mode == 4 || this.mode == 3) {
                sinb = q / this.qp;
                cosb = Math.sqrt(1.0 - sinb * sinb);
            }
            switch (this.mode) {
                case 4: {
                    b = 1.0 + this.sinb1 * sinb + this.cosb1 * cosb * coslam;
                    break;
                }
                case 3: {
                    b = 1.0 + cosb * coslam;
                    break;
                }
                case 1: {
                    b = 1.5707963267948966 + phi;
                    q = this.qp - q;
                    break;
                }
                case 2: {
                    b = phi - 1.5707963267948966;
                    q = this.qp + q;
                }
            }
            if (Math.abs(b) < 1.0E-10) {
                throw new ProjectionException();
            }
            switch (this.mode) {
                case 4: {
                    b = Math.sqrt(2.0 / b);
                    xy.y = this.ymf * b * (this.cosb1 * sinb - this.sinb1 * cosb * coslam);
                    xy.x = this.xmf * b * cosb * sinlam;
                    break;
                }
                case 3: {
                    b = Math.sqrt(2.0 / (1.0 + cosb * coslam));
                    xy.y = b * sinb * this.ymf;
                    xy.x = this.xmf * b * cosb * sinlam;
                    break;
                }
                case 1: 
                case 2: {
                    if (q >= 0.0) {
                        b = Math.sqrt(q);
                        xy.x = b * sinlam;
                        xy.y = coslam * (this.mode == 2 ? b : -b);
                        break;
                    }
                    xy.y = 0.0;
                    xy.x = 0.0;
                }
            }
        }
        return xy;
    }

    public ProjCoordinate projectInverse(double x, double y, ProjCoordinate lp) {
        if (this.spherical) {
            double d;
            double cosz = 0.0;
            double sinz = 0.0;
            double rh = ProjectionMath.distance(x, y);
            lp.y = rh * 0.5;
            if (d > 1.0) {
                throw new ProjectionException();
            }
            lp.y = 2.0 * Math.asin(lp.y);
            if (this.mode == 4 || this.mode == 3) {
                sinz = Math.sin(lp.y);
                cosz = Math.cos(lp.y);
            }
            switch (this.mode) {
                case 3: {
                    lp.y = Math.abs(rh) <= 1.0E-10 ? 0.0 : Math.asin(y * sinz / rh);
                    x *= sinz;
                    y = cosz * rh;
                    break;
                }
                case 4: {
                    lp.y = Math.abs(rh) <= 1.0E-10 ? this.projectionLatitude : Math.asin(cosz * this.sinphi0 + y * sinz * this.cosphi0 / rh);
                    x *= sinz * this.cosphi0;
                    y = (cosz - Math.sin(lp.y) * this.sinphi0) * rh;
                    break;
                }
                case 1: {
                    y = -y;
                    lp.y = 1.5707963267948966 - lp.y;
                    break;
                }
                case 2: {
                    lp.y -= 1.5707963267948966;
                }
            }
            lp.x = y == 0.0 && (this.mode == 3 || this.mode == 4) ? 0.0 : Math.atan2(x, y);
        } else {
            double ab = 0.0;
            switch (this.mode) {
                case 3: 
                case 4: {
                    double d;
                    double rho = ProjectionMath.distance(x /= this.dd, y *= this.dd);
                    if (d < 1.0E-10) {
                        lp.x = 0.0;
                        lp.y = this.projectionLatitude;
                        return lp;
                    }
                    double sCe = 2.0 * Math.asin(0.5 * rho / this.rq);
                    double cCe = Math.cos(sCe);
                    sCe = Math.sin(sCe);
                    x *= sCe;
                    if (this.mode == 4) {
                        ab = cCe * this.sinb1 + y * sCe * this.cosb1 / rho;
                        double q = this.qp * ab;
                        y = rho * this.cosb1 * cCe - y * this.sinb1 * sCe;
                        break;
                    }
                    ab = y * sCe / rho;
                    double q = this.qp * ab;
                    y = rho * cCe;
                    break;
                }
                case 1: {
                    y = -y;
                }
                case 2: {
                    double q = x * x + y * y;
                    if (q == 0.0) {
                        lp.x = 0.0;
                        lp.y = this.projectionLatitude;
                        return lp;
                    }
                    ab = 1.0 - q / this.qp;
                    if (this.mode != 2) break;
                    ab = -ab;
                }
            }
            lp.x = Math.atan2(x, y);
            lp.y = ProjectionMath.authlat(Math.asin(ab), this.apa);
        }
        return lp;
    }

    public boolean isEqualArea() {
        return true;
    }

    public boolean hasInverse() {
        return true;
    }

    public String toString() {
        return "Lambert Equal Area Azimuthal";
    }
}

