/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.teiid.query.sql.LanguageVisitor;

public interface LanguageObject
extends Cloneable {
    public void acceptVisitor(LanguageVisitor var1);

    public Object clone();

    public static class Util {
        public static <S extends LanguageObject, T extends S> ArrayList<S> deepClone(Collection<T> collection, Class<S> type) {
            if (collection == null) {
                return null;
            }
            ArrayList<S> result = new ArrayList<S>(collection.size());
            for (LanguageObject obj : collection) {
                result.add(type.cast(obj.clone()));
            }
            return result;
        }

        public static <T extends LanguageObject> T[] deepClone(T[] collection) {
            if (collection == null) {
                return null;
            }
            LanguageObject[] copy = (LanguageObject[])Arrays.copyOf(collection, collection.length);
            for (int i = 0; i < copy.length; ++i) {
                LanguageObject t = copy[i];
                copy[i] = (LanguageObject)t.clone();
            }
            return copy;
        }
    }
}

