/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.pool;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nux.xom.pool.XOMUtil;

public class FileUtil {
    private static final Pattern PATH_SEPARATOR = Pattern.compile("[\\s:;,]+");
    private static final Pattern MATCH_ALL = Pattern.compile(".*");
    private static final Charset DEFAULT_PLATFORM_CHARSET = Charset.forName(new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding());
    static /* synthetic */ Class class$0;

    private FileUtil() {
    }

    public static URI[] listFiles(String directory, boolean recurse, String includes, String excludes) {
        File dir = FileUtil.parsePath(directory);
        Matcher[] includes2 = FileUtil.parseExpressions(includes);
        if (includes2.length == 0) {
            includes2 = new Matcher[]{MATCH_ALL.matcher("")};
        }
        Matcher[] excludes2 = FileUtil.parseExpressions(excludes);
        ArrayList uris = new ArrayList();
        HashSet history = recurse ? new HashSet() : null;
        FileUtil.listFiles2(dir, includes2, excludes2, uris, history);
        URI[] results = new URI[uris.size()];
        uris.toArray(results);
        return results;
    }

    private static File parsePath(String path) {
        String string = path = path == null ? "" : path.trim();
        if (path.startsWith("file://")) {
            path = path.substring("file://".length());
        } else if (path.startsWith("file:")) {
            path = path.substring("file:".length());
        }
        if (path.length() == 0 || path.equals(".")) {
            path = XOMUtil.getSystemProperty("user.dir", ".");
        } else {
            path = path.replace('\\', File.separatorChar);
            if ((path = path.replace('/', File.separatorChar)).startsWith("~")) {
                String home = XOMUtil.getSystemProperty("user.home", "~");
                path = String.valueOf(home) + path.substring(1);
            }
        }
        return new File(path);
    }

    private static Matcher[] parseExpressions(String expressions) {
        String string = expressions = expressions == null ? "" : expressions.trim();
        if (expressions.length() == 0) {
            return new Matcher[0];
        }
        String[] exprs = PATH_SEPARATOR.split(expressions);
        Matcher[] matchers = new Matcher[exprs.length];
        int size = 0;
        int i = 0;
        while (i < exprs.length) {
            if (exprs[i].length() > 0) {
                String regex = FileUtil.expression2Regex(exprs[i]);
                matchers[size++] = Pattern.compile(regex).matcher("");
            }
            ++i;
        }
        if (size == matchers.length) {
            return matchers;
        }
        Matcher[] results = new Matcher[size];
        System.arraycopy(matchers, 0, results, 0, size);
        return results;
    }

    private static String expression2Regex(String expr) {
        if (expr.startsWith("#")) {
            return expr.substring(1);
        }
        expr = "*" + File.separatorChar + expr;
        expr = expr.replace('\\', File.separatorChar);
        expr = expr.replace('/', File.separatorChar);
        StringBuffer buf = new StringBuffer(3 * expr.length());
        int i = 0;
        while (i < expr.length()) {
            char c = expr.charAt(i);
            if (c == '*') {
                buf.append(".*");
            } else if (c == '\\') {
                buf.append(c);
                buf.append(c);
            } else {
                buf.append("\\Q");
                buf.append(c);
                buf.append("\\E");
            }
            ++i;
        }
        return buf.toString();
    }

    private static void listFiles2(File dir, Matcher[] includes, Matcher[] excludes, List uris, Set history) {
        boolean recurse = history != null;
        try {
            if (recurse && !history.add(dir.getCanonicalPath())) {
                return;
            }
        }
        catch (IOException e) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (!file.isDirectory()) {
                int j = 0;
                while (j < includes.length) {
                    if (includes[j].reset(file.getPath()).matches()) {
                        boolean exclude = false;
                        int k = 0;
                        while (!exclude && k < excludes.length) {
                            exclude = excludes[k].reset(file.getPath()).matches();
                            ++k;
                        }
                        if (exclude) break;
                        uris.add(file.toURI());
                        break;
                    }
                    ++j;
                }
                files[i] = null;
            }
            ++i;
        }
        i = 0;
        while (recurse && i < files.length) {
            if (files[i] != null) {
                FileUtil.listFiles2(files[i], includes, excludes, uris, history);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] toByteArray(InputStream input) throws IOException {
        byte[] byArray;
        block17: {
            byte[] byArray2;
            block16: {
                byte[] byArray3;
                block15: {
                    try {
                        block18: {
                            Class<?> clazz = input.getClass();
                            Class<?> clazz2 = class$0;
                            if (clazz2 == null) {
                                Class<?> clazz3;
                                try {
                                    clazz3 = Class.forName("java.io.ByteArrayInputStream");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                clazz2 = class$0 = clazz3;
                            }
                            if (clazz != clazz2) break block18;
                            InputStream inputStream = input;
                            synchronized (inputStream) {
                                int avail = input.available();
                                if (avail >= 0) {
                                    byte[] buffer = new byte[avail];
                                    input.read(buffer);
                                    byArray3 = buffer;
                                }
                                break block18;
                            }
                            Object var6_10 = null;
                            if (input == null) return byArray3;
                            break block15;
                        }
                        int size = Math.max(256, input.available());
                        byte[] buffer = new byte[size];
                        byte[] output = new byte[size];
                        size = 0;
                        while (true) {
                            int n;
                            if ((n = input.read(buffer)) < 0) {
                                if (size != output.length) break;
                                byArray2 = output;
                                break block16;
                            }
                            if (size + n > output.length) {
                                byte[] tmp = new byte[Math.max(2 * output.length, size + n)];
                                System.arraycopy(output, 0, tmp, 0, size);
                                System.arraycopy(buffer, 0, tmp, size, n);
                                buffer = output;
                                output = tmp;
                            } else {
                                System.arraycopy(buffer, 0, output, size, n);
                            }
                            size += n;
                        }
                        buffer = null;
                        buffer = new byte[size];
                        System.arraycopy(output, 0, buffer, 0, size);
                        byArray = buffer;
                        break block17;
                    }
                    catch (Throwable throwable) {
                        Object var6_13 = null;
                        if (input == null) throw throwable;
                        input.close();
                        throw throwable;
                    }
                }
                input.close();
                return byArray3;
            }
            Object var6_11 = null;
            if (input == null) return byArray2;
            input.close();
            return byArray2;
        }
        Object var6_12 = null;
        if (input == null) return byArray;
        input.close();
        return byArray;
    }

    public static String toString(InputStream input, Charset charset) throws IOException {
        if (charset == null) {
            charset = DEFAULT_PLATFORM_CHARSET;
        }
        byte[] data = FileUtil.toByteArray(input);
        return charset.decode(ByteBuffer.wrap(data)).toString();
    }
}

