/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.sandbox;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import nu.xom.Builder;
import nu.xom.DocType;
import nu.xom.Document;
import nux.xom.binary.BinaryXMLCodec;
import nux.xom.pool.XOMUtil;

class BinaryXMLMultiTest {
    BinaryXMLMultiTest() {
    }

    public static void main(String[] args) throws Exception {
        String cmd = args[0];
        String mode = args[1];
        int compressionLevel = Integer.parseInt(args[2]);
        int iterations = Integer.parseInt(args[3]);
        int runs = Integer.parseInt(args[4]);
        boolean enablePerformancePatches = "true".equals(System.getProperty("nux.xom.sandbox.BinaryXMLTest.enablePatches", "true"));
        System.out.println("patchesEnabled=" + enablePerformancePatches);
        if (enablePerformancePatches) {
            System.setProperty("nu.xom.Verifier.checkURI", "false");
        }
        boolean testCompressionLevels = true;
        BinaryXMLCodec codec = new BinaryXMLCodec();
        int j = 5;
        while (j < args.length) {
            File file;
            if (!BinaryXMLMultiTest.ignore(args[j]) && !(file = new File(args[j])).isDirectory()) {
                System.out.println("now processing " + file);
                Document doc = new Builder().build(file);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                int p = 0;
                while (p < iterations) {
                    System.out.println("compressionLevel=" + compressionLevel);
                    codec.serialize(doc, compressionLevel, out);
                    compressionLevel = (compressionLevel + 1) % 10;
                    ++p;
                }
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                int p2 = 0;
                while (p2 < iterations) {
                    Document doc2 = codec.deserialize(in, null);
                    if (cmd.equals("test")) {
                        if (!Arrays.equals(XOMUtil.toCanonicalXML(doc), XOMUtil.toCanonicalXML(doc2))) {
                            System.err.println("Canonical XML Mismatch: ");
                            System.err.println("expected: " + doc.toXML());
                            System.err.println("actual: " + doc2.toXML());
                            BinaryXMLMultiTest.printDiff(doc, doc2);
                            System.exit(0);
                        }
                        if (!BinaryXMLMultiTest.equalsDocTypeEquals(doc.getDocType(), doc2.getDocType())) {
                            System.err.println("DocType Mismatch: ");
                            System.err.println("expected: " + doc.toXML());
                            System.err.println("actual: " + doc2.toXML());
                            System.exit(0);
                        }
                    }
                    ++p2;
                }
            }
            ++j;
        }
    }

    private static void printDiff(Document expected, Document actual) {
        int window = 100;
        System.err.println("Canonical XML Diff Location Snippet:");
        byte[] e = XOMUtil.toCanonicalXML(expected);
        byte[] a = XOMUtil.toCanonicalXML(actual);
        if (e.length != a.length) {
            System.err.println("e.length=" + e.length + ", a.length=" + a.length);
        }
        int size = Math.min(e.length, a.length);
        int i = 0;
        while (i < size) {
            if (e[i] != a[i]) {
                System.err.println("diff at i=" + i + ", e[i]=" + e[i] + ", a[i]=" + a[i]);
                int off = Math.max(0, i - window);
                int len = Math.min(2 * window, size - off);
                try {
                    System.err.println("e='" + new String(e, off, len, "UTF-8") + "'");
                    System.err.println("a='" + new String(a, off, len, "UTF-8") + "'");
                    break;
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException("can never happen");
                }
            }
            ++i;
        }
    }

    private static boolean equalsDocTypeEquals(DocType x, DocType y) {
        if (x != y) {
            if (x == null && y != null) {
                return false;
            }
            if (x != null && y == null) {
                return false;
            }
            if (!x.getInternalDTDSubset().equals(y.getInternalDTDSubset())) {
                return false;
            }
            if (!BinaryXMLMultiTest.eq(x.getPublicID(), y.getPublicID())) {
                return false;
            }
            if (!BinaryXMLMultiTest.eq(x.getSystemID(), y.getSystemID())) {
                return false;
            }
            return BinaryXMLMultiTest.eq(x.getRootElementName(), y.getRootElementName());
        }
        return true;
    }

    private static boolean eq(Object x, Object y) {
        if (x != y) {
            if (x == null && y != null) {
                return false;
            }
            if (x != null && y == null) {
                return false;
            }
            if (!x.equals(y)) {
                return false;
            }
        }
        return true;
    }

    private static boolean ignore(String file) {
        if (file.endsWith(".html")) {
            return true;
        }
        if (file.endsWith(".out")) {
            return true;
        }
        if (file.endsWith(".txt")) {
            return true;
        }
        if (file.endsWith(".bat")) {
            return true;
        }
        if (file.endsWith(".sh")) {
            return true;
        }
        if (file.endsWith(".sxx")) {
            return true;
        }
        if (file.endsWith(".ssx")) {
            return true;
        }
        if (file.endsWith(".dtd")) {
            return true;
        }
        if (file.endsWith(".xq")) {
            return true;
        }
        if (file.endsWith(".zip")) {
            return true;
        }
        if (file.endsWith(".gz")) {
            return true;
        }
        if (file.endsWith(".jpg")) {
            return true;
        }
        if (file.endsWith(".gif")) {
            return true;
        }
        if (file.endsWith("nspc05x.xml")) {
            return true;
        }
        if (file.endsWith("ent22.xml")) {
            return true;
        }
        if (file.endsWith("2")) {
            return true;
        }
        if (file.indexOf("err.") >= 0) {
            return true;
        }
        if (file.indexOf("ERR.") >= 0) {
            return true;
        }
        if (file.indexOf("Untitled") >= 0) {
            return true;
        }
        if (file.endsWith("CVS")) {
            return true;
        }
        if (file.endsWith("ucs4bigendian.xml")) {
            return true;
        }
        if (file.endsWith("ucs4littleendian.xml")) {
            return true;
        }
        if (file.endsWith("utf8.xml")) {
            return true;
        }
        if (file.endsWith("097.ent")) {
            return true;
        }
        if (file.endsWith("test_ebcdic.xml")) {
            return true;
        }
        if (file.endsWith(".ent")) {
            return true;
        }
        if (file.endsWith("xmltest/valid/sa/012.xml")) {
            return true;
        }
        if (file.indexOf("fail") >= 0) {
            return true;
        }
        if (file.endsWith("p04pass1.xml")) {
            return true;
        }
        if (file.endsWith("namespaces/1.0/009.xml")) {
            return true;
        }
        if (file.endsWith("namespaces/1.0/010.xml")) {
            return true;
        }
        if (file.endsWith("namespaces/1.0/011.xml")) {
            return true;
        }
        if (file.endsWith("namespaces/1.0/013.xml")) {
            return true;
        }
        if (file.endsWith("namespaces/1.0/014.xml")) {
            return true;
        }
        if (file.endsWith("namespaces/1.0/015.xml")) {
            return true;
        }
        if (file.endsWith("namespaces/1.0/016.xml")) {
            return true;
        }
        if (file.endsWith("namespaces/1.0/023.xml")) {
            return true;
        }
        if (file.endsWith("namespaces/1.0/025.xml")) {
            return true;
        }
        if (file.endsWith("namespaces/1.0/026.xml")) {
            return true;
        }
        if (file.endsWith("namespaces/1.0/029.xml")) {
            return true;
        }
        if (file.endsWith("namespaces/1.0/030.xml")) {
            return true;
        }
        if (file.endsWith("namespaces/1.1/005.xml")) {
            return true;
        }
        if (file.endsWith("xinclude/input/utf8bom.xml")) {
            return true;
        }
        if (file.endsWith("wolf-xom/dtdtest.xhtml")) {
            return true;
        }
        if (file.endsWith("wolf-xom/xinclude/output/langtest3.xml")) {
            return true;
        }
        if (file.indexOf("wolf/large/svg/tests/spec/color/") >= 0) {
            return true;
        }
        if (file.indexOf("wolf/large/svg/tests/spec/coordinates/") >= 0) {
            return true;
        }
        if (file.indexOf("wolf/large/svg/tests/spec/filters/") >= 0) {
            return true;
        }
        return file.indexOf("wolf/large/svg/tests/spec/fonts/") >= 0;
    }
}

