/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.SecurityContext;
import org.jboss.security.SubjectInfo;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.teiid.jboss.SecurityActions;
import org.teiid.logging.LogManager;

public class AssosiateCallerIdentityLoginModule
extends AbstractServerLoginModule {
    private Principal principal;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        super.initialize(subject, handler, sharedState, options);
    }

    public boolean login() throws LoginException {
        SecurityContext sc = SecurityActions.getSecurityContext();
        SubjectInfo si = sc.getSubjectInfo();
        Subject subject = si.getAuthenticatedSubject();
        Set<Principal> principals = subject.getPrincipals();
        this.principal = principals.iterator().next();
        if (super.login()) {
            return true;
        }
        LogManager.logDetail((String)"org.teiid.SECURITY", (Object)("Adding Passthrough principal=" + this.principal.getName()));
        this.sharedState.put("javax.security.auth.login.name", this.principal.getName());
        this.sharedState.put("javax.security.auth.login.password", "");
        this.loginOk = true;
        return true;
    }

    protected Principal getIdentity() {
        return this.principal;
    }

    protected Group[] getRoleSets() throws LoginException {
        return new Group[0];
    }
}

