/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.List;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.services.resourceadapters.deployment.InactiveResourceAdapterDeploymentService;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.jca.common.api.metadata.spec.ConfigProperty;
import org.jboss.jca.common.api.metadata.spec.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.spec.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.spec.ResourceAdapter;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.teiid.deployers.ExtendedPropertyMetadata;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.OperationsConstants;
import org.teiid.jboss.ReadTranslatorProperties;
import org.teiid.jboss.TeiidOperationHandler;

class ReadRARDescription
extends TeiidOperationHandler {
    protected ReadRARDescription() {
        super("read-rar-description");
    }

    @Override
    protected void executeOperation(OperationContext context, DQPCore engine, ModelNode operation) throws OperationFailedException {
        ModelNode result = context.getResult();
        if (!operation.hasDefined(OperationsConstants.RAR_NAME.getName())) {
            throw new OperationFailedException(IntegrationPlugin.Util.getString(OperationsConstants.RAR_NAME.getName() + ".missing"));
        }
        String rarName = operation.get(OperationsConstants.RAR_NAME.getName()).asString();
        ResourceAdapter ra = null;
        ServiceName svcName = ConnectorServices.INACTIVE_RESOURCE_ADAPTER_SERVICE.append(new String[]{rarName});
        ServiceController sc = context.getServiceRegistry(false).getService(svcName);
        if (sc != null) {
            InactiveResourceAdapterDeploymentService.InactiveResourceAdapterDeployment deployment = (InactiveResourceAdapterDeploymentService.InactiveResourceAdapterDeployment)InactiveResourceAdapterDeploymentService.InactiveResourceAdapterDeployment.class.cast(sc.getValue());
            ConnectorXmlDescriptor descriptor = deployment.getConnectorXmlDescriptor();
            ra = descriptor.getConnector().getResourceadapter();
        } else {
            svcName = ServiceName.JBOSS.append(new String[]{"deployment", "unit"}).append(new String[]{rarName});
            sc = context.getServiceRegistry(false).getService(svcName);
            if (sc == null) {
                throw new OperationFailedException(IntegrationPlugin.Util.getString("RAR_notfound"));
            }
            DeploymentUnit du = (DeploymentUnit)DeploymentUnit.class.cast(sc.getValue());
            ConnectorXmlDescriptor cd = (ConnectorXmlDescriptor)du.getAttachment(ConnectorXmlDescriptor.ATTACHMENT_KEY);
            ra = cd.getConnector().getResourceadapter();
        }
        if (ra instanceof ResourceAdapter) {
            ResourceAdapter ra1516 = ra;
            result.add(this.buildReadOnlyNode("resourceadapter-class", ra1516.getResourceadapterClass()));
            List connDefinitions = ra1516.getOutboundResourceadapter().getConnectionDefinitions();
            for (ConnectionDefinition p : connDefinitions) {
                result.add(this.buildReadOnlyNode("managedconnectionfactory-class", p.getManagedConnectionFactoryClass().getValue()));
                List props = p.getConfigProperties();
                for (ConfigProperty prop : props) {
                    result.add(this.buildNode(prop));
                }
            }
        }
    }

    private ModelNode buildReadOnlyNode(String name, String value) {
        ModelNode node = new ModelNode();
        node.get(new String[]{name, "type"}).set(ModelType.STRING);
        node.get(new String[]{name, "display"}).set(name);
        node.get(new String[]{name, "read-only"}).set(Boolean.toString(Boolean.TRUE));
        node.get(new String[]{name, "advanced"}).set(Boolean.toString(Boolean.TRUE));
        node.get(new String[]{name, "default"}).set(value);
        return node;
    }

    private ModelNode buildNode(ConfigProperty prop) {
        String name = prop.getConfigPropertyName().getValue();
        String type = prop.getConfigPropertyType().getValue();
        String defaltValue = null;
        if (prop.getConfigPropertyValue() != null) {
            defaltValue = prop.getConfigPropertyValue().getValue();
        }
        String description = null;
        if (prop.getDescriptions() != null) {
            description = ((LocalizedXsdString)prop.getDescriptions().get(0)).getValue();
        }
        ExtendedPropertyMetadata extended = new ExtendedPropertyMetadata(name, type, description, defaltValue);
        return ReadTranslatorProperties.buildNode(extended);
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        builder.addParameter((AttributeDefinition)OperationsConstants.RAR_NAME);
        builder.setReplyType(ModelType.LIST);
        builder.setReplyValueType(ModelType.STRING);
    }
}

