/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.metadata;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.teiid.core.types.XMLType;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;

public class FunctionMetadataReader {
    List<FunctionMethod> functionMethods = new ArrayList<FunctionMethod>();

    public static List<FunctionMethod> loadFunctionMethods(InputStream source) throws XMLStreamException {
        FunctionMetadataReader md = FunctionMetadataReader.parseFunctions(source);
        return md.functionMethods;
    }

    public static FunctionMetadataReader parseFunctions(InputStream content) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLType.getXmlInputFactory();
        XMLStreamReader reader = inputFactory.createXMLStreamReader(content);
        FunctionMetadataReader fmr = new FunctionMetadataReader();
        while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case XMI: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case XMI: {
                            FunctionMetadataReader.parseFunctions(reader, fmr);
                            while (reader.hasNext() && reader.next() != 8) {
                            }
                            break;
                        }
                    }
                    break;
                }
            }
        }
        return fmr;
    }

    private static void parseFunctions(XMLStreamReader reader, FunctionMetadataReader fmr) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            String elementName = reader.getLocalName();
            switch (Element.forName(elementName)) {
                case SCALAR_FUNCTION: {
                    fmr.functionMethods.add(FunctionMetadataReader.parseScalarFunction(reader));
                    continue block3;
                }
            }
            while (reader.hasNext() && (reader.nextTag() != 2 || !reader.getLocalName().equals(elementName))) {
            }
        }
    }

    private static FunctionMethod parseScalarFunction(XMLStreamReader reader) throws XMLStreamException {
        FunctionMethod function = new FunctionMethod();
        if (reader.getAttributeCount() > 0) {
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                if (Element.NAME.getLocalName().equals(attrName)) {
                    function.setName(attrValue);
                    continue;
                }
                if (Element.CATEGORY.getLocalName().equals(attrName)) {
                    function.setCategory(attrValue);
                    continue;
                }
                if (Element.INVOCATION_CLASS.getLocalName().equals(attrName)) {
                    function.setInvocationClass(attrValue);
                    continue;
                }
                if (Element.INVOCATION_METHOD.getLocalName().equals(attrName)) {
                    function.setInvocationMethod(attrValue);
                    continue;
                }
                if (Element.PUSHDOWN.getLocalName().equals(attrName)) {
                    function.setPushDown(attrValue);
                    continue;
                }
                if (!Element.DETERMINISTIC.getLocalName().equals(attrName)) continue;
                function.setDeterministicBoolean(Boolean.parseBoolean(attrValue));
            }
        }
        LinkedList<FunctionParameter> inputs = new LinkedList<FunctionParameter>();
        while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Element.forName(reader.getLocalName())) {
                case INPUT_PARAMTERS: {
                    inputs.addLast(FunctionMetadataReader.parseParameter(reader));
                    break;
                }
                case RETURN_PARAMETER: {
                    function.setOutputParameter(FunctionMetadataReader.parseParameter(reader));
                }
            }
        }
        function.setInputParameters(inputs);
        return function;
    }

    private static FunctionParameter parseParameter(XMLStreamReader reader) throws XMLStreamException {
        FunctionParameter fp = new FunctionParameter();
        if (reader.getAttributeCount() > 0) {
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                if (Element.NAME.getLocalName().equals(attrName)) {
                    fp.setName(attrValue);
                    continue;
                }
                if (Element.DESCRIPTION.getLocalName().equals(attrName)) {
                    fp.setDescription(attrValue);
                    continue;
                }
                if (!Element.TYPE.getLocalName().equals(attrName)) continue;
                fp.setType(attrValue);
            }
        }
        while (reader.nextTag() != 2) {
        }
        return fp;
    }

    static enum Namespace {
        UNKNOWN(null),
        XMI("http://www.omg.org/XMI"),
        FUNCTION("http://www.metamatrix.com/metamodels/MetaMatrixFunction");

        private final String uri;
        private static final Map<String, Namespace> namespaces;

        private Namespace(String uri) {
            this.uri = uri;
        }

        public String getUri() {
            return this.uri;
        }

        public static Namespace forUri(String uri) {
            Namespace element = namespaces.get(uri);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Namespace> map = new HashMap<String, Namespace>();
            for (Namespace namespace : Namespace.values()) {
                String name = namespace.getUri();
                if (name == null) continue;
                map.put(name, namespace);
            }
            namespaces = map;
        }
    }

    static enum Element {
        UNKNOWN(null),
        XMI("XMI"),
        SCALAR_FUNCTION("ScalarFunction"),
        NAME("name"),
        INPUT_PARAMTERS("inputParameters"),
        DESCRIPTION("description"),
        CATEGORY("category"),
        PUSHDOWN("pushDown"),
        INVOCATION_CLASS("invocationClass"),
        INVOCATION_METHOD("invocationMethod"),
        RETURN_PARAMETER("returnParameter"),
        DETERMINISTIC("deterministic"),
        TYPE("type");

        private final String name;
        private static final Map<String, Element> elements;

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Element forName(String localName) {
            Element element = elements.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Element> map = new HashMap<String, Element>();
            for (Element element : Element.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            elements = map;
        }
    }
}

