/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.proc;

import java.util.Map;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.processor.proc.ProgramInstruction;
import org.teiid.query.sql.symbol.ElementSymbol;

public class CreateCursorResultSetInstruction
extends ProgramInstruction {
    protected String rsName;
    protected ProcessorPlan plan;
    private Mode mode;
    private Map<ElementSymbol, ElementSymbol> procAssignments;
    private boolean usesLocalTemp;

    public CreateCursorResultSetInstruction(String rsName, ProcessorPlan plan, Mode mode) {
        this.rsName = rsName;
        this.plan = plan;
        this.mode = mode;
    }

    public void setProcAssignments(Map<ElementSymbol, ElementSymbol> procAssignments) {
        this.procAssignments = procAssignments;
    }

    @Override
    public void process(ProcedurePlan procEnv) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        procEnv.executePlan(this.plan, this.rsName, this.procAssignments, this.mode, this.usesLocalTemp);
    }

    @Override
    public CreateCursorResultSetInstruction clone() {
        ProcessorPlan clonedPlan = this.plan.clone();
        CreateCursorResultSetInstruction clone = new CreateCursorResultSetInstruction(this.rsName, clonedPlan, this.mode);
        clone.setProcAssignments(this.procAssignments);
        clone.usesLocalTemp = true;
        return clone;
    }

    public String toString() {
        return "CREATE CURSOR RESULTSET INSTRUCTION - " + this.rsName;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = new PlanNode("CREATE CURSOR");
        props.addProperty("Result Set", this.rsName);
        props.addProperty("Query", this.plan.getDescriptionProperties());
        return props;
    }

    public ProcessorPlan getCommand() {
        return this.plan;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setUsesLocalTemp(boolean b) {
        this.usesLocalTemp = b;
    }

    public static enum Mode {
        UPDATE,
        HOLD,
        NOHOLD;

    }
}

