/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.tempdata;

import java.util.List;
import org.teiid.common.buffer.TupleBrowser;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.logging.LogManager;
import org.teiid.query.processor.CollectionTupleSource;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.tempdata.BaseIndexInfo;
import org.teiid.query.tempdata.TempTable;
import org.teiid.translator.ExecutionFactory;

class IndexInfo
extends BaseIndexInfo<TempTable> {
    TupleSource valueTs;

    public IndexInfo(TempTable table, List<? extends Expression> projectedCols, Criteria condition, OrderBy orderBy, boolean primary) {
        super(table, projectedCols, condition, orderBy, primary);
    }

    TupleBrowser createTupleBrowser(ExecutionFactory.NullOrder nullOrder) throws TeiidComponentException {
        boolean direction = true;
        if (this.ordering != null) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"Using index for ordering");
            direction = this.ordering;
        }
        if (this.valueTs != null) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"Using index value set");
            return new TupleBrowser(((TempTable)this.table).getTree(), this.valueTs, direction);
        }
        if (!this.valueSet.isEmpty()) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"Using index value set");
            this.sortValueSet(direction, nullOrder);
            CollectionTupleSource cts = new CollectionTupleSource(this.valueSet.iterator());
            return new TupleBrowser(((TempTable)this.table).getTree(), cts, direction);
        }
        if (this.lower != null || this.upper != null) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"Using index for range query", (Object)this.lower, (Object)this.upper);
        }
        return new TupleBrowser(((TempTable)this.table).getTree(), this.lower, this.upper, direction);
    }
}

