/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.jboss.logging.Logger;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.FileUtils;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.logging.LogManager;

public class ObjectSerializer {
    private static final Logger log = Logger.getLogger(ObjectSerializer.class);
    private static final String ATTACHMENT_SUFFIX = ".ser";
    private String storagePath;

    public ObjectSerializer(String path) {
        this.storagePath = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T loadAttachment(File attachmentsStore, Class<T> expected) throws IOException, ClassNotFoundException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("loadAttachment, attachmentsStore=" + attachmentsStore));
        }
        try (ObjectInputStream ois = null;){
            ois = new ObjectInputStream(new FileInputStream(attachmentsStore));
            T t = expected.cast(ois.readObject());
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveAttachment(File attachmentsStore, Object attachment, boolean force) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("saveAttachment, attachmentsStore=" + attachmentsStore + ", attachment=" + attachment));
        }
        if (!attachmentsStore.exists() || force) {
            try (ObjectOutputStream oos = null;){
                attachmentsStore.getParentFile().mkdirs();
                oos = new ObjectOutputStream(new FileOutputStream(attachmentsStore));
                oos.writeObject(attachment);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public File buildVDBFile(VDBMetaData vdb) {
        return new File(this.baseDirectory(vdb.getName() + "_" + vdb.getVersion()), vdb.getName() + "_" + vdb.getVersion() + ATTACHMENT_SUFFIX);
    }

    public File buildVdbXml(VDBMetaData vdb) {
        return new File(this.baseDirectory(vdb.getName() + "_" + vdb.getVersion()), "vdb.xml");
    }

    public File buildModelFile(VDBMetaData vdb, String modelName) {
        return new File(this.baseDirectory(vdb.getName() + "_" + vdb.getVersion()), vdb.getName() + "_" + vdb.getVersion() + "_" + modelName + ATTACHMENT_SUFFIX);
    }

    public boolean isStale(VDBMetaData vdb, long timeAfter) {
        File cacheFile = this.buildVDBFile(vdb);
        return cacheFile.exists() && timeAfter > cacheFile.lastModified();
    }

    public void removeAttachments(VDBMetaData vdb) {
        String dirName = this.baseDirectory(vdb.getName() + "_" + vdb.getVersion());
        FileUtils.removeDirectoryAndChildren((File)new File(dirName));
    }

    public void removeAttachment(File file) {
        FileUtils.remove((File)file);
    }

    private String baseDirectory(String fileName) {
        String dirName = this.storagePath + File.separator + fileName + File.separator;
        return dirName;
    }

    public <T> T loadSafe(File cacheFile, Class<T> clazz) {
        try {
            if (cacheFile.exists()) {
                return clazz.cast(this.loadAttachment(cacheFile, clazz));
            }
            return null;
        }
        catch (Exception e) {
            LogManager.logWarning((String)"org.teiid.RUNTIME", (Throwable)e, (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50043, new Object[]{cacheFile.getAbsolutePath()}));
            cacheFile.delete();
            return null;
        }
    }

    public OutputStream getVdbXmlOutputStream(VDBMetaData vdb) throws IOException {
        File f = this.buildVdbXml(vdb);
        if (!f.exists()) {
            f.getParentFile().mkdirs();
        }
        return new FileOutputStream(f);
    }
}

