/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSigner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.spi.FileSystem;
import org.jboss.vfs.util.PathTokenizer;
import org.teiid.common.buffer.AutoCleanupUtil;

public final class PureZipFileSystem
implements FileSystem {
    private static AtomicInteger counter = new AtomicInteger();
    private final JarFile zipFile;
    private final File archiveFile;
    private final long zipTime;
    private final ZipNode rootNode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VirtualFile mount(URL url) throws IOException, URISyntaxException {
        String fileName = "teiid-vdb-" + url.toExternalForm();
        VirtualFile root = VFS.getChild((String)fileName);
        File f = new File(url.toURI());
        if (root.exists()) {
            long lastModified = f.lastModified();
            if (root.getLastModified() != lastModified) {
                fileName = fileName + counter.get();
                root = VFS.getChild((String)fileName);
            }
        }
        Class<PureZipFileSystem> clazz = PureZipFileSystem.class;
        synchronized (PureZipFileSystem.class) {
            if (!root.exists()) {
                final Closeable c = VFS.mount((VirtualFile)root, (FileSystem)new PureZipFileSystem(f));
                AutoCleanupUtil.setCleanupReference(root, new AutoCleanupUtil.Removable(){

                    @Override
                    public void remove() {
                        try {
                            c.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return root;
        }
    }

    public PureZipFileSystem(File archiveFile) throws IOException {
        JarFile zipFile;
        this.zipTime = archiveFile.lastModified();
        this.zipFile = zipFile = new JarFile(archiveFile);
        this.archiveFile = archiveFile;
        Enumeration<JarEntry> entries = zipFile.entries();
        ZipNode rootNode = new ZipNode(new HashMap(), "", null);
        for (JarEntry entry : PureZipFileSystem.iter(entries)) {
            Map children;
            String token;
            String name = entry.getName();
            boolean isDirectory = entry.isDirectory();
            List tokens = PathTokenizer.getTokens((String)name);
            ZipNode node = rootNode;
            Iterator it = tokens.iterator();
            while (it.hasNext() && !PathTokenizer.isCurrentToken((String)(token = (String)it.next())) && !PathTokenizer.isReverseToken((String)token) && (children = node.children) != null) {
                ZipNode child = (ZipNode)children.get(token);
                if (child == null) {
                    child = it.hasNext() || isDirectory ? new ZipNode(new HashMap(), token, null) : new ZipNode(null, token, entry);
                    children.put(token, child);
                }
                node = child;
            }
        }
        this.rootNode = rootNode;
    }

    private static <T> Iterable<T> iter(Enumeration<T> entries) {
        return Collections.list(entries);
    }

    public File getFile(VirtualFile mountPoint, VirtualFile target) throws IOException {
        ZipNode zipNode = this.getExistingZipNode(mountPoint, target);
        JarEntry zipEntry = zipNode.entry;
        try {
            return new File(new URI("jar", this.archiveFile.toURI().toString() + "!/", zipEntry.getName()));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public InputStream openInputStream(VirtualFile mountPoint, VirtualFile target) throws IOException {
        ZipNode zipNode = this.getExistingZipNode(mountPoint, target);
        if (this.rootNode == zipNode) {
            return new FileInputStream(this.archiveFile);
        }
        JarEntry entry = zipNode.entry;
        if (entry == null) {
            throw new IOException("Not a file: \"" + target.getPathName() + "\"");
        }
        return this.zipFile.getInputStream(entry);
    }

    public boolean delete(VirtualFile mountPoint, VirtualFile target) {
        return false;
    }

    public long getSize(VirtualFile mountPoint, VirtualFile target) {
        ZipNode zipNode = this.getZipNode(mountPoint, target);
        if (zipNode == null) {
            return 0L;
        }
        JarEntry entry = zipNode.entry;
        if (zipNode == this.rootNode) {
            return this.archiveFile.length();
        }
        return entry == null ? 0L : entry.getSize();
    }

    public long getLastModified(VirtualFile mountPoint, VirtualFile target) {
        ZipNode zipNode = this.getZipNode(mountPoint, target);
        if (zipNode == null) {
            return 0L;
        }
        JarEntry entry = zipNode.entry;
        return entry == null ? this.zipTime : entry.getTime();
    }

    public boolean exists(VirtualFile mountPoint, VirtualFile target) {
        ZipNode zipNode = this.rootNode.find(mountPoint, target);
        return zipNode != null;
    }

    public boolean isFile(VirtualFile mountPoint, VirtualFile target) {
        ZipNode zipNode = this.rootNode.find(mountPoint, target);
        return zipNode != null && zipNode.entry != null;
    }

    public boolean isDirectory(VirtualFile mountPoint, VirtualFile target) {
        ZipNode zipNode = this.rootNode.find(mountPoint, target);
        return zipNode != null && zipNode.entry == null;
    }

    public List<String> getDirectoryEntries(VirtualFile mountPoint, VirtualFile target) {
        ZipNode zipNode = this.getZipNode(mountPoint, target);
        if (zipNode == null) {
            return Collections.emptyList();
        }
        Map children = zipNode.children;
        if (children == null) {
            return Collections.emptyList();
        }
        Collection values = children.values();
        ArrayList<String> names = new ArrayList<String>(values.size());
        for (ZipNode node : values) {
            names.add(node.name);
        }
        return names;
    }

    public CodeSigner[] getCodeSigners(VirtualFile mountPoint, VirtualFile target) {
        ZipNode zipNode = this.getZipNode(mountPoint, target);
        if (zipNode == null) {
            return null;
        }
        JarEntry jarEntry = zipNode.entry;
        return jarEntry.getCodeSigners();
    }

    private ZipNode getZipNode(VirtualFile mountPoint, VirtualFile target) {
        return this.rootNode.find(mountPoint, target);
    }

    private ZipNode getExistingZipNode(VirtualFile mountPoint, VirtualFile target) throws FileNotFoundException {
        ZipNode zipNode = this.rootNode.find(mountPoint, target);
        if (zipNode == null) {
            throw new FileNotFoundException(target.getPathName());
        }
        return zipNode;
    }

    public boolean isReadOnly() {
        return true;
    }

    public File getMountSource() {
        return this.archiveFile;
    }

    public URI getRootURI() throws URISyntaxException {
        return new URI("jar", this.archiveFile.toURI().toString() + "!/", null);
    }

    public void close() throws IOException {
        VFSUtils.safeClose((Closeable)new Closeable(){

            @Override
            public void close() throws IOException {
                PureZipFileSystem.this.zipFile.close();
            }
        });
    }

    private File buildFile(File contentsDir, String name) {
        List tokens = PathTokenizer.getTokens((String)name);
        File currentFile = contentsDir;
        for (String token : tokens) {
            currentFile = new File(currentFile, token);
        }
        currentFile.getParentFile().mkdirs();
        return currentFile;
    }

    private static final class ZipNode {
        private final Map<String, ZipNode> children;
        private final String name;
        private final JarEntry entry;

        private ZipNode(Map<String, ZipNode> children, String name, JarEntry entry) {
            this.children = children;
            this.name = name;
            this.entry = entry;
        }

        private ZipNode find(VirtualFile mountPoint, VirtualFile target) {
            if (mountPoint.equals(target)) {
                return this;
            }
            ZipNode parent = this.find(mountPoint, target.getParent());
            if (parent == null) {
                return null;
            }
            Map<String, ZipNode> children = parent.children;
            if (children == null) {
                return null;
            }
            return children.get(target.getName());
        }
    }
}

