/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.plantree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.client.plan.Annotation;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.TableFunctionReference;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;

public class PlanNode {
    private int type;
    private boolean modified;
    private PlanNode parent;
    private LinkedList<PlanNode> children = new LinkedList();
    private List<PlanNode> childrenView = Collections.unmodifiableList(this.children);
    private Map<NodeConstants.Info, Object> nodeProperties;
    private Set<GroupSymbol> groups = new LinkedHashSet<GroupSymbol>();
    private static final String TAB = "  ";

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public PlanNode getParent() {
        return this.parent;
    }

    private void setParent(PlanNode parent) {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.modified = true;
        this.parent = parent;
    }

    public List<PlanNode> getChildren() {
        return this.childrenView;
    }

    public List<PlanNode> removeAllChildren() {
        ArrayList<PlanNode> childrenCopy = new ArrayList<PlanNode>(this.children);
        Iterator childIter = this.children.iterator();
        while (childIter.hasNext()) {
            PlanNode child = (PlanNode)childIter.next();
            childIter.remove();
            child.parent = null;
        }
        this.modified = true;
        return childrenCopy;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public PlanNode getFirstChild() {
        if (this.getChildCount() > 0) {
            return this.children.getFirst();
        }
        return null;
    }

    public PlanNode getLastChild() {
        if (this.getChildCount() > 0) {
            return this.children.getLast();
        }
        return null;
    }

    public void addFirstChild(PlanNode child) {
        this.modified = true;
        this.children.addFirst(child);
        child.setParent(this);
    }

    public void addLastChild(PlanNode child) {
        this.modified = true;
        this.children.addLast(child);
        child.setParent(this);
    }

    public void addChildren(Collection<PlanNode> otherChildren) {
        for (PlanNode planNode : otherChildren) {
            this.addLastChild(planNode);
        }
    }

    public PlanNode removeFromParent() {
        this.modified = true;
        PlanNode result = this.parent;
        if (result != null) {
            result.removeChild(this);
        }
        return result;
    }

    public boolean removeChild(PlanNode child) {
        boolean result = this.children.remove(child);
        if (result) {
            child.parent = null;
            this.modified = true;
        }
        return result;
    }

    public Object getProperty(NodeConstants.Info propertyID) {
        if (this.nodeProperties == null) {
            return null;
        }
        Object result = this.nodeProperties.get((Object)propertyID);
        if (result != null) {
            this.modified = true;
        }
        return result;
    }

    public Object setProperty(NodeConstants.Info propertyID, Object value) {
        if (this.nodeProperties == null) {
            this.nodeProperties = new LinkedHashMap<NodeConstants.Info, Object>();
        }
        this.modified = true;
        return this.nodeProperties.put(propertyID, value);
    }

    public Object removeProperty(Object propertyID) {
        if (this.nodeProperties == null) {
            return null;
        }
        this.modified = true;
        return this.nodeProperties.remove(propertyID);
    }

    public boolean hasProperty(NodeConstants.Info propertyID) {
        return this.getProperty(propertyID) != null;
    }

    public boolean hasCollectionProperty(NodeConstants.Info propertyID) {
        Collection value = (Collection)this.getProperty(propertyID);
        return value != null && !value.isEmpty();
    }

    public void addGroup(GroupSymbol groupID) {
        this.modified = true;
        this.groups.add(groupID);
    }

    public void addGroups(Collection<GroupSymbol> newGroups) {
        this.modified = true;
        this.groups.addAll(newGroups);
    }

    public Set<GroupSymbol> getGroups() {
        return this.groups;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        this.getRecursiveString(str, 0, null);
        return str.toString();
    }

    public String nodeToString(boolean recusive) {
        StringBuilder str = new StringBuilder();
        if (!recusive) {
            this.getNodeString(str, null);
        } else {
            this.getRecursiveString(str, 0, this.modified);
        }
        return str.toString();
    }

    private static void setTab(StringBuilder str, int tabStop) {
        for (int i = 0; i < tabStop; ++i) {
            str.append(TAB);
        }
    }

    void getRecursiveString(StringBuilder str, int tabLevel, Boolean mod) {
        PlanNode.setTab(str, tabLevel);
        this.getNodeString(str, mod);
        str.append(")\n");
        for (PlanNode child : this.children) {
            child.getRecursiveString(str, tabLevel + 1, mod == null ? null : Boolean.valueOf(child.modified));
        }
    }

    void getNodeString(StringBuilder str, Boolean mod) {
        str.append(NodeConstants.getNodeTypeString(this.type));
        str.append("(groups=");
        str.append(this.groups);
        if (!Boolean.FALSE.equals(mod)) {
            if (this.nodeProperties != null) {
                str.append(", props=");
                String props = this.nodeProperties.toString();
                if (props.length() > 100000) {
                    props = props.substring(0, 100000) + "...";
                }
                str.append(props);
            }
            if (Boolean.TRUE.equals(mod)) {
                this.modified = false;
            }
        }
    }

    public boolean hasBooleanProperty(NodeConstants.Info propertyKey) {
        return Boolean.TRUE.equals(this.getProperty(propertyKey));
    }

    public void replaceChild(PlanNode child, PlanNode replacement) {
        this.modified = true;
        int i = this.children.indexOf(child);
        this.children.set(i, replacement);
        child.setParent(null);
        replacement.setParent(this);
    }

    public void addAsParent(PlanNode node) {
        this.modified = true;
        if (this.parent != null) {
            this.parent.replaceChild(this, node);
        }
        assert (node.getChildCount() == 0);
        node.addLastChild(this);
    }

    public List<SymbolMap> getCorrelatedReferences() {
        List<SubqueryContainer<?>> containers = this.getSubqueryContainers();
        if (containers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SymbolMap> result = new ArrayList<SymbolMap>(containers.size());
        for (SubqueryContainer<?> container : containers) {
            SymbolMap map = ((Command)container.getCommand()).getCorrelatedReferences();
            if (map == null) continue;
            result.add(map);
        }
        return result;
    }

    public List<SymbolMap> getAllReferences() {
        ArrayList<SymbolMap> refMaps = new ArrayList<SymbolMap>(this.getCorrelatedReferences());
        refMaps.addAll(this.getExportedCorrelatedReferences());
        return refMaps;
    }

    public List<SymbolMap> getExportedCorrelatedReferences() {
        if (this.type != 4) {
            return Collections.emptyList();
        }
        LinkedList<SymbolMap> result = new LinkedList<SymbolMap>();
        block0: for (PlanNode child : NodeEditor.findAllNodes(this, 64, 1)) {
            SymbolMap references = (SymbolMap)child.getProperty(NodeConstants.Info.CORRELATED_REFERENCES);
            if (references == null) continue;
            Set<GroupSymbol> correlationGroups = GroupsUsedByElementsVisitor.getGroups(references.getValues());
            PlanNode joinNode = NodeEditor.findParent(child, 4, 64);
            while (joinNode != null) {
                if (joinNode.getGroups().containsAll(correlationGroups)) {
                    if (joinNode != this) continue block0;
                    result.add(references);
                    continue block0;
                }
                joinNode = NodeEditor.findParent(joinNode, 4, 64);
            }
        }
        return result;
    }

    public Set<ElementSymbol> getCorrelatedReferenceElements() {
        List<SymbolMap> maps = this.getCorrelatedReferences();
        if (maps.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ElementSymbol> result = new HashSet<ElementSymbol>();
        for (SymbolMap symbolMap : maps) {
            List<Expression> values = symbolMap.getValues();
            for (Expression expr : values) {
                ElementCollectorVisitor.getElements((LanguageObject)expr, result);
            }
        }
        return result;
    }

    public List<SubqueryContainer<?>> getSubqueryContainers() {
        List<LanguageObject> toSearch = Collections.emptyList();
        switch (this.getType()) {
            case 16: {
                Criteria criteria = (Criteria)this.getProperty(NodeConstants.Info.SELECT_CRITERIA);
                toSearch = Arrays.asList(criteria);
                break;
            }
            case 8: {
                toSearch = (Collection)this.getProperty(NodeConstants.Info.PROJECT_COLS);
                break;
            }
            case 4: {
                toSearch = (List<Expression>)this.getProperty(NodeConstants.Info.JOIN_CRITERIA);
                break;
            }
            case 64: {
                TableFunctionReference tfr = (TableFunctionReference)this.getProperty(NodeConstants.Info.TABLE_FUNCTION);
                if (tfr == null) break;
                toSearch = Arrays.asList(tfr);
                break;
            }
            case 128: {
                SymbolMap groupMap = (SymbolMap)this.getProperty(NodeConstants.Info.SYMBOL_MAP);
                toSearch = groupMap.getValues();
                break;
            }
            case 32: {
                OrderBy orderBy = (OrderBy)this.getProperty(NodeConstants.Info.SORT_ORDER);
                if (orderBy == null) break;
                toSearch = orderBy.getOrderByItems();
            }
        }
        return ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(toSearch);
    }

    public float getCardinality() {
        Float cardinality = (Float)this.getProperty(NodeConstants.Info.EST_CARDINALITY);
        if (cardinality == null) {
            return -1.0f;
        }
        return cardinality.floatValue();
    }

    public void recordDebugAnnotation(String annotation, Object modelID, String resolution, AnalysisRecord record, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        if (record != null && record.recordAnnotations()) {
            boolean current = this.modified;
            this.modified = true;
            record.addAnnotation("Relational Planner", annotation + (modelID != null ? " " + (metadata != null ? metadata.getName(modelID) : modelID) : ""), resolution + " " + this.nodeToString(false), Annotation.Priority.LOW);
            this.modified = current;
        }
    }

    public PlanNode clone() {
        PlanNode node = new PlanNode();
        node.type = this.type;
        node.groups = new HashSet<GroupSymbol>(this.groups);
        if (this.nodeProperties != null) {
            node.nodeProperties = new LinkedHashMap<NodeConstants.Info, Object>(this.nodeProperties);
        }
        return node;
    }
}

