/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.sandbox;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.query.StaticQueryContext;
import nu.xom.Builder;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.NodeFactory;
import nu.xom.Serializer;
import nu.xom.converters.SAXConverter;
import nux.xom.binary.BinaryXMLCodec;
import nux.xom.io.StaxParser;
import nux.xom.io.StaxUtil;
import nux.xom.io.StreamingSerializer;
import nux.xom.io.StreamingSerializerFactory;
import nux.xom.pool.FileUtil;
import nux.xom.pool.XOMUtil;
import nux.xom.sandbox.IOTest;
import nux.xom.sandbox.IOTestUtil;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class BinaryXMLTest
extends IOTest {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private BinaryXMLTest() {
    }

    public static void main(String[] args) throws Exception {
        String cmd = args[0];
        String mode = args[1];
        int compressionLevel = Integer.parseInt(args[2]);
        int iterations = Integer.parseInt(args[3]);
        int runs = Integer.parseInt(args[4]);
        boolean enablePerformancePatches = "true".equals(System.getProperty("nux.xom.sandbox.BinaryXMLTest.enablePatches", "true"));
        System.out.println("patchesEnabled=" + enablePerformancePatches);
        boolean testCompressionLevels = false;
        int run = 0;
        while (run < runs) {
            long time = 0L;
            long doneEncoded = 0L;
            long done = 0L;
            int checksum = 0;
            if (enablePerformancePatches) {
                System.setProperty("nu.xom.Verifier.checkPCDATA", "false");
                System.setProperty("nu.xom.Verifier.checkURI", "false");
            }
            XMLInputFactory staxInputFactory = null;
            if (mode.indexOf("stax") >= 0 && mode.indexOf("fi") < 0) {
                if (mode.indexOf("sun") >= 0) {
                    staxInputFactory = (XMLInputFactory)Class.forName("com.sun.xml.stream.ZephyrParserFactory").newInstance();
                } else if (mode.indexOf("bea") >= 0) {
                    staxInputFactory = (XMLInputFactory)Class.forName("com.bea.xml.stream.MXParserFactory").newInstance();
                } else if (mode.indexOf("wood") >= 0) {
                    staxInputFactory = (XMLInputFactory)Class.forName("com.ctc.wstx.stax.WstxInputFactory").newInstance();
                }
            }
            XMLOutputFactory staxOutputFactory = null;
            if (mode.indexOf("stax") >= 0) {
                staxOutputFactory = BinaryXMLTest.createXMLOutputFactory(mode);
            }
            BinaryXMLCodec codec = new BinaryXMLCodec();
            NodeFactory bnuxFactory = null;
            if (mode.startsWith("bnux") && mode.indexOf("NNF") >= 0) {
                bnuxFactory = XOMUtil.getNullNodeFactory();
            }
            Builder builder = new Builder();
            if (mode.equals("xom-V")) {
                builder = new Builder(new NodeFactory(){});
            }
            if (mode.equals("xom-NNF")) {
                builder = new Builder(XOMUtil.getNullNodeFactory());
            }
            StaticQueryContext context = null;
            Transformer saxonSerializer = null;
            if (mode.equals("saxon")) {
                context = new StaticQueryContext(new Configuration());
                String clazz = "net.sf.saxon.TransformerFactoryImpl";
                System.setProperty("javax.xml.transform.TransformerFactory", clazz);
                saxonSerializer = TransformerFactory.newInstance().newTransformer();
            }
            DocumentBuilder domBuilder = null;
            Transformer domSerializer = null;
            if (mode.equals("dom")) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setAttribute("http://apache.org/xml/features/dom/defer-node-expansion", Boolean.FALSE);
                domBuilder = factory.newDocumentBuilder();
                String clazz = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";
                System.setProperty("javax.xml.transform.TransformerFactory", clazz);
                domSerializer = TransformerFactory.newInstance().newTransformer();
                System.err.println(domSerializer.getClass().getName());
            }
            Object fiSerializer = null;
            Builder fiBuilder = null;
            Method fiMethod = null;
            XMLStreamReader fistaxReader = null;
            Method fistaxMethod = null;
            if (mode.startsWith("fi")) {
                NodeFactory factory = null;
                if (mode.indexOf("NNF") >= 0) {
                    factory = XOMUtil.getNullNodeFactory();
                }
                XMLReader parser = (XMLReader)Class.forName("com.sun.xml.fastinfoset.sax.SAXDocumentParser").newInstance();
                fiBuilder = new Builder(parser, false, factory);
                fiSerializer = mode.indexOf("stax") >= 0 ? (XMLStreamWriter)Class.forName("com.sun.xml.fastinfoset.stax.StAXDocumentSerializer").newInstance() : (ContentHandler)Class.forName("com.sun.xml.fastinfoset.sax.SAXDocumentSerializer").newInstance();
                if (mode.startsWith("fi1")) {
                    Method method = fiSerializer.getClass().getMethod("setAttributeValueSizeLimit", Integer.TYPE);
                    method.invoke(fiSerializer, new Integer(Integer.MAX_VALUE));
                    method = fiSerializer.getClass().getMethod("setCharacterContentChunkSizeLimit", Integer.TYPE);
                    method.invoke(fiSerializer, new Integer(Integer.MAX_VALUE));
                }
                Class<?> clazz = fiSerializer.getClass();
                Class[] classArray = new Class[1];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.io.OutputStream");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                fiMethod = clazz.getMethod("setOutputStream", classArray);
                if (mode.indexOf("stax") >= 0) {
                    fistaxReader = (XMLStreamReader)Class.forName("com.sun.xml.fastinfoset.stax.StAXDocumentParser").newInstance();
                    Class<?> clazz3 = fistaxReader.getClass();
                    Class[] classArray2 = new Class[1];
                    Class<?> clazz4 = class$1;
                    if (clazz4 == null) {
                        try {
                            clazz4 = Class.forName("java.io.InputStream");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray2[0] = clazz4;
                    fistaxMethod = clazz3.getMethod("setInputStream", classArray2);
                }
            }
            Builder staxBuilder = null;
            if (mode.indexOf("stax") >= 0) {
                NodeFactory factory = null;
                if (mode.indexOf("NNF") >= 0) {
                    factory = XOMUtil.getNullNodeFactory();
                }
                staxBuilder = StaxUtil.createBuilder(staxInputFactory, factory);
            }
            int j = 5;
            while (j < args.length) {
                try {
                    File[] files = IOTestUtil.listXMLFiles(args[j]);
                    int k = 0;
                    while (k < files.length) {
                        File file = files[k];
                        if (BinaryXMLTest.bogus(file) || BinaryXMLTest.ignore(file) || file.isDirectory()) {
                            System.out.println("\n: IGNORING " + file + " ...");
                        } else {
                            System.out.println("now processing " + file);
                            String baseURI = file.toURI().toASCIIString();
                            if (baseURI.startsWith("file:/")) {
                                if (!(baseURI = baseURI.substring("file:/".length())).startsWith("//")) {
                                    baseURI = "//" + baseURI;
                                }
                                baseURI = "file:/" + baseURI;
                            }
                            Document doc = new Builder().build(file);
                            byte[] data = codec.serialize(doc, compressionLevel);
                            if (!cmd.equals("test")) {
                                doc = new BinaryXMLCodec().deserialize(data);
                            }
                            byte[] fileData = FileUtil.toByteArray(new FileInputStream(file));
                            long fileLength = file.length();
                            int encodedSize = 0;
                            org.w3c.dom.Document domDoc = null;
                            if (mode.equals("dom")) {
                                domDoc = domBuilder.parse(file);
                            }
                            DocumentInfo saxonDoc = null;
                            if (mode.equals("saxon")) {
                                saxonDoc = context.buildDocument((Source)new StreamSource(new ByteArrayInputStream(fileData)));
                            }
                            if (mode.startsWith("fi")) {
                                data = mode.indexOf("stax") >= 0 ? BinaryXMLTest.serializeWithFastInfosetStax(doc, (XMLStreamWriter)fiSerializer, fiMethod, new ByteArrayOutputStream()) : BinaryXMLTest.serializeWithFastInfoset(doc, (ContentHandler)fiSerializer, fiMethod, new ByteArrayOutputStream());
                            }
                            long start = System.currentTimeMillis();
                            int i = 0;
                            while (i < iterations) {
                                try {
                                    if (cmd.equals("ser") || cmd.equals("serdeser") || cmd.equals("test")) {
                                        ByteArrayOutputStream out = BinaryXMLTest.createOutputStream(cmd.equals("ser"));
                                        if (mode.startsWith("bnux")) {
                                            if (mode.indexOf("stream") < 0) {
                                                codec.serialize(doc, compressionLevel, out);
                                                data = out.toByteArray();
                                            } else {
                                                data = BinaryXMLTest.serializeWithStreamingBnux(doc, compressionLevel, out);
                                            }
                                        } else if (mode.startsWith("xom")) {
                                            data = mode.indexOf("stax") >= 0 ? BinaryXMLTest.serializeWithStax(doc, staxOutputFactory, out) : (mode.indexOf("stream") < 0 ? BinaryXMLTest.serializeWithXOM(doc, out) : BinaryXMLTest.serializeWithStreamingXOM(doc, out));
                                        } else if (mode.equals("saxon")) {
                                            saxonSerializer.transform((Source)saxonDoc, new StreamResult(out));
                                            data = out.toByteArray();
                                        } else if (mode.equals("dom")) {
                                            domSerializer.transform(new DOMSource(domDoc), new StreamResult(out));
                                            data = out.toByteArray();
                                        } else if (mode.startsWith("fi")) {
                                            data = mode.indexOf("stax") >= 0 ? BinaryXMLTest.serializeWithFastInfosetStax(doc, (XMLStreamWriter)fiSerializer, fiMethod, out) : BinaryXMLTest.serializeWithFastInfoset(doc, (ContentHandler)fiSerializer, fiMethod, out);
                                        } else {
                                            throw new IllegalArgumentException("illegal mode");
                                        }
                                        checksum += data.length;
                                    }
                                    encodedSize = data.length;
                                    doneEncoded += (long)encodedSize;
                                    Document doc2 = null;
                                    if (cmd.equals("deser") || cmd.equals("serdeser") || cmd.equals("test")) {
                                        if (mode.startsWith("bnux")) {
                                            doc2 = codec.deserialize(new ByteArrayInputStream(data), bnuxFactory);
                                        } else if (mode.startsWith("xom") && mode.indexOf("stax") >= 0) {
                                            doc2 = staxBuilder.build((InputStream)new ByteArrayInputStream(fileData));
                                        } else if (mode.startsWith("xom")) {
                                            doc2 = mode.indexOf("stream") < 0 ? builder.build((InputStream)new ByteArrayInputStream(fileData), baseURI) : builder.build((InputStream)new ByteArrayInputStream(data), baseURI);
                                        } else if (mode.equals("saxon")) {
                                            context.buildDocument((Source)new StreamSource(new ByteArrayInputStream(fileData)));
                                        } else if (mode.equals("dom")) {
                                            domDoc = domBuilder.parse(new ByteArrayInputStream(fileData));
                                        } else if (mode.startsWith("fi") && mode.indexOf("stax") >= 0) {
                                            fistaxMethod.invoke((Object)fistaxReader, new ByteArrayInputStream(data));
                                            doc2 = new StaxParser(fistaxReader, staxBuilder.getNodeFactory()).build();
                                        } else if (mode.startsWith("fi")) {
                                            doc2 = fiBuilder.build((InputStream)new ByteArrayInputStream(data));
                                        } else {
                                            throw new IllegalArgumentException("illegal mode");
                                        }
                                        if (doc2 != null) {
                                            checksum += doc2.getBaseURI().length();
                                        }
                                    }
                                    if (cmd.equals("test")) {
                                        IOTestUtil.xomAssertEquals(doc, doc2);
                                        IOTestUtil.canonicalAssertEquals(doc, doc2);
                                        if (!BinaryXMLTest.equalsDocTypeEquals(doc.getDocType(), doc2.getDocType())) {
                                            System.err.println("DocType Mismatch: ");
                                            System.err.println("expected: " + doc.toXML());
                                            System.err.println("actual: " + doc2.toXML());
                                            System.exit(0);
                                        }
                                    }
                                }
                                catch (RuntimeException e) {
                                    System.err.println("FATAL ERROR: " + e);
                                    System.err.println("expected" + doc.toXML());
                                    throw e;
                                }
                                done += fileLength;
                                ++i;
                            }
                            time += System.currentTimeMillis() - start;
                            float cfactor = (float)fileLength * 1.0f / (float)encodedSize;
                            System.out.println("compression factor = " + cfactor);
                        }
                        ++k;
                    }
                }
                catch (Exception e) {
                    if (BinaryXMLTest.hasCause(e, "org.jvnet.fastinfoset.FastInfosetException")) {
                        e.printStackTrace(System.out);
                    }
                    throw e;
                }
                ++j;
            }
            System.out.println("\n****** SUMMARY ******");
            System.out.println("files = " + iterations * (args.length - 5));
            System.out.println("secs = " + (float)time / 1000.0f);
            System.out.println("mean throughput MB/s = " + (float)done / 1048576.0f / ((float)time / 1000.0f));
            float cfactor = (float)done * 1.0f / (float)doneEncoded;
            System.out.println("mean compression factor = " + cfactor);
            System.out.println("files/sec = " + (float)(iterations * (args.length - 5)) / ((float)time / 1000.0f));
            System.out.println("checksum = " + checksum);
            ++run;
        }
    }

    private static byte[] serializeWithXOM(Document doc, ByteArrayOutputStream out) throws IOException {
        Serializer ser = new Serializer((OutputStream)out);
        ser.write(doc);
        return out.toByteArray();
    }

    private static byte[] serializeWithStreamingXOM(Document doc, ByteArrayOutputStream out) throws IOException {
        StreamingSerializerFactory factory = new StreamingSerializerFactory();
        StreamingSerializer ser = factory.createXMLSerializer(out, "UTF-8");
        ser.write(doc);
        return out.toByteArray();
    }

    private static byte[] serializeWithStreamingBnux(Document doc, int compressionLevel, ByteArrayOutputStream out) throws IOException {
        StreamingSerializerFactory factory = new StreamingSerializerFactory();
        StreamingSerializer ser = factory.createBinaryXMLSerializer(out, compressionLevel);
        ser.write(doc);
        return out.toByteArray();
    }

    private static byte[] serializeWithFastInfoset(Document doc, ContentHandler fiSerializer, Method method, ByteArrayOutputStream out) throws Exception {
        try {
            method.invoke((Object)fiSerializer, out);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
        new SAXConverter(fiSerializer).convert(doc);
        return out.toByteArray();
    }

    private static byte[] serializeWithFastInfosetStax(Document doc, XMLStreamWriter fiSerializer, Method method, ByteArrayOutputStream out) throws Exception {
        try {
            method.invoke((Object)fiSerializer, out);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
        new StreamingSerializerFactory().createStaxSerializer(fiSerializer).write(doc);
        return out.toByteArray();
    }

    private static byte[] serializeWithStax(Document doc, XMLOutputFactory staxOutputFactory, ByteArrayOutputStream out) throws XMLStreamException, IOException {
        XMLStreamWriter writer = staxOutputFactory.createXMLStreamWriter(out, "UTF-8");
        StreamingSerializer ser = new StreamingSerializerFactory().createStaxSerializer(writer);
        ser.write(doc);
        return out.toByteArray();
    }

    private static XMLOutputFactory createXMLOutputFactory(String mode) {
        if (mode.indexOf("sun") >= 0) {
            System.setProperty("javax.xml.stream.XMLOutputFactory", "com.sun.xml.stream.ZephyrWriterFactory");
        } else if (mode.indexOf("bea") >= 0) {
            System.setProperty("javax.xml.stream.XMLOutputFactory", "com.bea.xml.stream.XMLOutputFactoryBase");
        } else if (mode.indexOf("wood") >= 0) {
            System.setProperty("javax.xml.stream.XMLOutputFactory", "com.ctc.wstx.stax.WstxOutputFactory");
        } else if (mode.indexOf("fi") >= 0) {
            System.setProperty("javax.xml.stream.XMLOutputFactory", "com.sun.xml.fastinfoset.stax.factory.StAXOutputFactory");
        }
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        System.out.println("outFactory=" + factory.getClass().getName());
        return factory;
    }

    private static boolean hasCause(Throwable e, String clazz) {
        while (e != null) {
            if (e.getClass().getName().equals(clazz)) {
                return true;
            }
            e = e instanceof SAXException ? ((SAXException)e).getException() : (e instanceof XMLStreamException ? ((XMLStreamException)e).getNestedException() : e.getCause());
        }
        return false;
    }

    private static void printDiff(Document expected, Document actual) {
        int window = 100;
        System.err.println("Canonical XML Diff Location Snippet:");
        byte[] e = XOMUtil.toCanonicalXML(expected);
        byte[] a = XOMUtil.toCanonicalXML(actual);
        if (e.length != a.length) {
            System.err.println("e.length=" + e.length + ", a.length=" + a.length);
        }
        int size = Math.min(e.length, a.length);
        int i = 0;
        while (i < size) {
            if (e[i] != a[i]) {
                System.err.println("diff at i=" + i + ", e[i]=" + e[i] + ", a[i]=" + a[i]);
                int off = Math.max(0, i - window);
                int len = Math.min(2 * window, size - off);
                try {
                    System.err.println("e='" + new String(e, off, len, "UTF-8") + "'");
                    System.err.println("a='" + new String(a, off, len, "UTF-8") + "'");
                    break;
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException("can never happen");
                }
            }
            ++i;
        }
    }

    private static boolean equalsDocTypeEquals(DocType x, DocType y) {
        if (x != y) {
            if (x == null && y != null) {
                return false;
            }
            if (x != null && y == null) {
                return false;
            }
            if (!x.getInternalDTDSubset().equals(y.getInternalDTDSubset())) {
                return false;
            }
            if (!BinaryXMLTest.eq(x.getPublicID(), y.getPublicID())) {
                return false;
            }
            if (!BinaryXMLTest.eq(x.getSystemID(), y.getSystemID())) {
                return false;
            }
            return BinaryXMLTest.eq(x.getRootElementName(), y.getRootElementName());
        }
        return true;
    }

    private static boolean eq(Object x, Object y) {
        if (x != y) {
            if (x == null && y != null) {
                return false;
            }
            if (x != null && y == null) {
                return false;
            }
            if (!x.equals(y)) {
                return false;
            }
        }
        return true;
    }

    private static boolean ignore(File xmlFile) {
        String file = xmlFile.getAbsolutePath();
        return false;
    }

    public static ByteArrayOutputStream createOutputStream(boolean nullStream) {
        return nullStream ? new NullOutputStream() : new ByteArrayOutputStream(256);
    }

    private static final class NullOutputStream
    extends ByteArrayOutputStream {
        private NullOutputStream() {
        }

        public void write(int b) {
            ++this.count;
        }

        public void write(byte[] b, int off, int len) {
            this.count += off + len;
            if (len > 0) {
                this.count += b[len - 1];
            }
        }

        public byte[] toByteArray() {
            return new byte[]{(byte)this.count};
        }

        public void close() {
            this.count = 0;
        }
    }
}

