/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.AdminObjectImpl;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.CopyOnWriteLinkedHashMap;

public class ModelMetaData
extends AdminObjectImpl
implements Model {
    private static final int DEFAULT_ERROR_HISTORY = 10;
    private static final String SUPPORTS_MULTI_SOURCE_BINDINGS_KEY_OLD = "supports-multi-source-bindings";
    private static final String SUPPORTS_MULTI_SOURCE_BINDINGS_KEY = "multisource";
    private static final long serialVersionUID = 3714234763056162230L;
    protected Map<String, SourceMappingMetadata> sources = new CopyOnWriteLinkedHashMap();
    protected String modelType = Model.Type.PHYSICAL.name();
    protected String description;
    protected String path;
    protected boolean visible = true;
    protected List<Message> messages;
    protected transient List<Message> runtimeMessages;
    protected List<String> sourceMetadataType = new ArrayList<String>();
    protected List<String> sourceMetadataText = new ArrayList<String>();
    protected Model.MetadataStatus metadataStatus = Model.MetadataStatus.LOADING;

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isSource() {
        return this.getModelType() == Model.Type.PHYSICAL;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public Model.Type getModelType() {
        try {
            return Model.Type.valueOf(this.modelType);
        }
        catch (IllegalArgumentException e) {
            return Model.Type.OTHER;
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public boolean isSupportsMultiSourceBindings() {
        return this.isSource() && (this.sources.size() > 1 || Boolean.parseBoolean(this.getPropertyValue(SUPPORTS_MULTI_SOURCE_BINDINGS_KEY)) || Boolean.parseBoolean(this.getPropertyValue(SUPPORTS_MULTI_SOURCE_BINDINGS_KEY_OLD)));
    }

    public void setSupportsMultiSourceBindings(boolean supports) {
        this.addProperty(SUPPORTS_MULTI_SOURCE_BINDINGS_KEY, Boolean.toString(supports));
    }

    public void setModelType(Model.Type modelType) {
        this.modelType = modelType.name();
    }

    public void setModelType(String modelType) {
        this.modelType = modelType != null ? modelType.toUpperCase() : null;
    }

    @Override
    public Model.MetadataStatus getMetadataStatus() {
        return this.metadataStatus;
    }

    public void setMetadataStatus(Model.MetadataStatus status) {
        this.metadataStatus = status;
    }

    public void setMetadataStatus(String status) {
        if (status != null) {
            this.metadataStatus = Model.MetadataStatus.valueOf(status);
        }
    }

    public String toString() {
        return this.getName() + this.sources;
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    public Collection<SourceMappingMetadata> getSourceMappings() {
        return this.sources.values();
    }

    public Map<String, SourceMappingMetadata> getSources() {
        return this.sources;
    }

    public SourceMappingMetadata getSourceMapping(String sourceName) {
        return this.sources.get(sourceName);
    }

    public void setSourceMappings(List<SourceMappingMetadata> sources) {
        this.sources.clear();
        for (SourceMappingMetadata source : sources) {
            this.addSourceMapping(source.getName(), source.getTranslatorName(), source.getConnectionJndiName());
        }
    }

    @Override
    public List<String> getSourceNames() {
        return new ArrayList<String>(this.sources.keySet());
    }

    @Override
    public String getSourceConnectionJndiName(String sourceName) {
        SourceMappingMetadata s = this.sources.get(sourceName);
        if (s == null) {
            return null;
        }
        return s.getConnectionJndiName();
    }

    @Override
    public String getSourceTranslatorName(String sourceName) {
        SourceMappingMetadata s = this.sources.get(sourceName);
        if (s == null) {
            return null;
        }
        return s.getTranslatorName();
    }

    public SourceMappingMetadata addSourceMapping(String name, String translatorName, String connJndiName) {
        return this.sources.put(name, new SourceMappingMetadata(name, translatorName, connJndiName));
    }

    public void addSourceMapping(SourceMappingMetadata source) {
        this.addSourceMapping(source.getName(), source.getTranslatorName(), source.getConnectionJndiName());
    }

    public synchronized boolean hasErrors() {
        if (this.messages != null) {
            for (Message error : this.messages) {
                if (error.getSeverity() != Message.Severity.ERROR) continue;
                return true;
            }
        }
        if (this.runtimeMessages != null) {
            for (Message error : this.runtimeMessages) {
                if (error.getSeverity() != Message.Severity.ERROR) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized List<Message> getMessages() {
        return this.getMessages(true);
    }

    public synchronized List<Message> getMessages(boolean includeRuntime) {
        if (this.messages == null && this.runtimeMessages == null) {
            return Collections.emptyList();
        }
        ArrayList<Message> list = new ArrayList<Message>();
        if (this.messages != null) {
            list.addAll(this.messages);
        }
        if (includeRuntime && this.runtimeMessages != null) {
            list.addAll(this.runtimeMessages);
        }
        return list;
    }

    public Message addMessage(String severity, String message) {
        Message ve = new Message(Message.Severity.valueOf(severity), message);
        this.addMessage(ve);
        return ve;
    }

    public synchronized boolean hasRuntimeMessages() {
        return this.runtimeMessages != null && !this.runtimeMessages.isEmpty();
    }

    public synchronized Message addRuntimeError(String message) {
        return this.addRuntimeMessage(Message.Severity.ERROR, message);
    }

    public synchronized Message addRuntimeMessage(Message.Severity severity, String message) {
        Message ve = new Message(severity, message);
        if (this.runtimeMessages == null) {
            this.runtimeMessages = new LinkedList<Message>();
        }
        this.runtimeMessages.add(ve);
        if (this.runtimeMessages.size() > 10) {
            this.runtimeMessages.remove(0);
        }
        return ve;
    }

    public synchronized Message addMessage(Message ve) {
        if (this.messages == null) {
            this.messages = new LinkedList<Message>();
        }
        this.messages.add(ve);
        return ve;
    }

    public synchronized void clearRuntimeMessages() {
        this.runtimeMessages = null;
    }

    public synchronized void clearMessages() {
        this.clearRuntimeMessages();
        this.messages = null;
    }

    public void addSourceMetadata(String type, String text) {
        this.sourceMetadataType.add(type);
        this.sourceMetadataText.add(text);
    }

    @Deprecated
    public String getSchemaSourceType() {
        if (!this.sourceMetadataType.isEmpty()) {
            return this.sourceMetadataType.get(0);
        }
        return null;
    }

    @Deprecated
    public void setSchemaSourceType(String schemaSourceType) {
        if (!this.sourceMetadataType.isEmpty()) {
            this.sourceMetadataType.set(0, schemaSourceType);
        } else {
            this.sourceMetadataType.add(schemaSourceType);
        }
    }

    @Deprecated
    public String getSchemaText() {
        if (!this.sourceMetadataText.isEmpty()) {
            return this.sourceMetadataText.get(0);
        }
        return null;
    }

    @Deprecated
    public void setSchemaText(String schemaText) {
        if (!this.sourceMetadataText.isEmpty()) {
            this.sourceMetadataText.set(0, schemaText);
        } else {
            this.sourceMetadataText.add(schemaText);
        }
    }

    public List<String> getSourceMetadataType() {
        return this.sourceMetadataType;
    }

    public List<String> getSourceMetadataText() {
        return this.sourceMetadataText;
    }

    @Override
    public List<String> getValidityErrors() {
        ArrayList<String> allErrors = new ArrayList<String>();
        List<Message> errors = this.getMessages();
        if (errors != null && !errors.isEmpty()) {
            for (Message m : errors) {
                if (m.getSeverity() != Message.Severity.ERROR) continue;
                allErrors.add(m.getValue());
            }
        }
        return allErrors;
    }

    public static class Message
    implements Serializable {
        private static final long serialVersionUID = 2044197069467559527L;
        protected String value;
        protected Severity severity;
        protected String path;

        public Message() {
        }

        public Message(Severity severity, String msg) {
            this.severity = severity;
            Assertion.isNotNull((Object)msg);
            this.value = msg;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            Assertion.isNotNull((Object)value);
            this.value = value;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public void setSeverity(Severity severity) {
            this.severity = severity;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Message other = (Message)obj;
            if (this.severity == null ? other.severity != null : !this.severity.equals((Object)other.severity)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public static enum Severity {
            ERROR,
            WARNING,
            INFO;

        }
    }
}

