/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.stream.ChunkedStream;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Collection;
import org.teiid.core.util.ExternalizeUtil;
import org.teiid.netty.handler.codec.serialization.CompactObjectOutputStream;

public class ObjectEncoder
extends ChannelOutboundHandlerAdapter {
    private static final byte[] LENGTH_PLACEHOLDER = new byte[4];
    private static final int CHUNK_SIZE = 65535;
    private final int estimatedLength;
    private final boolean preferDirect;

    public ObjectEncoder() {
        this(512, true);
    }

    public ObjectEncoder(int estimatedLength, boolean preferDirect) {
        if (estimatedLength < 0) {
            throw new IllegalArgumentException("estimatedLength: " + estimatedLength);
        }
        this.estimatedLength = estimatedLength;
        this.preferDirect = preferDirect;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ByteBuf out = this.allocateBuffer(ctx, this.estimatedLength, this.preferDirect);
        int startIdx = out.writerIndex();
        ByteBufOutputStream bout = new ByteBufOutputStream(out);
        bout.write(LENGTH_PLACEHOLDER);
        CompactObjectOutputStream oout = new CompactObjectOutputStream((OutputStream)bout);
        try {
            oout.writeObject(msg);
            ExternalizeUtil.writeCollection((ObjectOutput)oout, (Collection)oout.getReferences());
            oout.flush();
            oout.close();
            int endIdx = out.writerIndex();
            out.setInt(startIdx, endIdx - startIdx - 4);
            if (out.isReadable()) {
                ctx.write((Object)out, promise);
                for (InputStream is : oout.getStreams()) {
                    ctx.write((Object)new AnonymousChunkedStream(new BufferedInputStream(is, 65535)), promise);
                }
            } else {
                out.release();
                ctx.write((Object)Unpooled.EMPTY_BUFFER, promise);
            }
            ctx.flush();
            out = null;
        }
        catch (Throwable t) {
            throw new FailedWriteException(msg, t);
        }
        finally {
            if (out != null) {
                out.release();
            }
        }
    }

    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, int estimatedSize, boolean preferDirect) throws Exception {
        if (preferDirect) {
            return ctx.alloc().ioBuffer(estimatedSize);
        }
        return ctx.alloc().heapBuffer(estimatedSize);
    }

    static class AnonymousChunkedStream
    extends ChunkedStream {
        public AnonymousChunkedStream(InputStream in) {
            super(in, 65535);
        }

        public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
            ByteBuf cb = super.readChunk(ctx);
            int length = cb.capacity();
            ByteBuf prefix = Unpooled.wrappedBuffer((byte[])new byte[2]);
            prefix.setShort(0, (int)((short)length));
            if (this.isEndOfInput()) {
                return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{prefix, cb, Unpooled.wrappedBuffer((byte[])new byte[2])});
            }
            return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{prefix, cb});
        }
    }

    public static class FailedWriteException
    extends Exception {
        private static final long serialVersionUID = -998903582526732966L;
        private Object object;

        FailedWriteException(Object object, Throwable t) {
            super(t);
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

