/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.VDB;
import org.teiid.deployers.RuntimeVDB;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.OperationsConstants;
import org.teiid.jboss.VDBOperations;

class ChangeVDBConnectionType
extends VDBOperations {
    public ChangeVDBConnectionType() {
        super("change-vdb-connection-type", true);
    }

    @Override
    protected void executeOperation(OperationContext context, RuntimeVDB vdb, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined(OperationsConstants.CONNECTION_TYPE.getName())) {
            throw new OperationFailedException(IntegrationPlugin.Util.getString(OperationsConstants.CONNECTION_TYPE.getName() + ".missing"));
        }
        String connectionType = operation.get(OperationsConstants.CONNECTION_TYPE.getName()).asString();
        try {
            vdb.changeConnectionType(VDB.ConnectionType.valueOf((String)connectionType));
        }
        catch (AdminProcessingException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        super.describeParameters(builder);
        builder.addParameter((AttributeDefinition)OperationsConstants.CONNECTION_TYPE);
    }
}

