/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.Subject;
import org.teiid.CommandContext;
import org.teiid.adminapi.Session;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.dqp.internal.datamgr.ConnectorWorkItem;
import org.teiid.dqp.internal.datamgr.RuntimeMetadataImpl;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.message.RequestID;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.CacheDirective;
import org.teiid.translator.ExecutionContext;

public class ExecutionContextImpl
implements ExecutionContext {
    private String partID;
    private String connectorName;
    private String executeCount;
    private boolean keepAlive = false;
    private boolean isTransactional;
    private int batchSize = 256;
    private List<Exception> warnings = new LinkedList<Exception>();
    private Session session;
    private boolean dataAvailable;
    private Collection<String> generalHint;
    private Collection<String> hint;
    private org.teiid.query.util.CommandContext commandContext;
    private CacheDirective cacheDirective;
    private RuntimeMetadata runtimeMetadata;
    private ConnectorWorkItem workItem;
    private CacheDirective.Scope scope;

    public ExecutionContextImpl(String vdbName, Object vdbVersion, Serializable executionPayload, String originalConnectionID, String connectorName, long requestId, String partId, String execCount) {
        this.commandContext = new org.teiid.query.util.CommandContext();
        this.commandContext.setVdbName(vdbName);
        this.commandContext.setVdbVersion(vdbVersion.toString());
        this.commandContext.setCommandPayload(executionPayload);
        this.commandContext.setConnectionID(originalConnectionID);
        this.commandContext.setRequestId(new RequestID(originalConnectionID, requestId));
        this.connectorName = connectorName;
        this.partID = partId;
        this.executeCount = execCount;
    }

    public ExecutionContextImpl(org.teiid.query.util.CommandContext commandContext, String connectorName, String partId, String execCount, ConnectorWorkItem workItem) {
        this.connectorName = connectorName;
        this.partID = partId;
        this.executeCount = execCount;
        this.commandContext = commandContext;
        this.workItem = workItem;
    }

    public CommandContext getCommandContext() {
        return this.commandContext;
    }

    public String getConnectorIdentifier() {
        return this.connectorName;
    }

    public String getRequestId() {
        return this.commandContext.getRequestId();
    }

    public String getPartIdentifier() {
        return this.partID;
    }

    public String getExecutionCountIdentifier() {
        return this.executeCount;
    }

    public String getVdbName() {
        return this.commandContext.getVdbName();
    }

    public String getVdbVersion() {
        return this.commandContext.getVdbVersion();
    }

    public Subject getSubject() {
        return this.commandContext.getSubject();
    }

    public Serializable getCommandPayload() {
        return this.commandContext.getCommandPayload();
    }

    public String getConnectionId() {
        return this.commandContext.getConnectionId();
    }

    public void keepExecutionAlive(boolean alive) {
        this.keepAlive = alive;
    }

    boolean keepExecutionAlive() {
        return this.keepAlive;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExecutionContext)) {
            return false;
        }
        ExecutionContext other = (ExecutionContext)obj;
        return EquivalenceUtil.areEqual((Object)this.getRequestId(), (Object)other.getRequestId()) && EquivalenceUtil.areEqual((Object)this.getPartIdentifier(), (Object)other.getPartIdentifier());
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.getRequestId()}), (Object[])new Object[]{this.partID});
    }

    public String toString() {
        String userName = null;
        if (this.getSubject() != null) {
            for (Principal p : this.getSubject().getPrincipals()) {
                userName = p.getName();
            }
        }
        return "ExecutionContext<vdb=" + this.getVdbName() + ", version=" + this.getVdbVersion() + ", user=" + userName + ">";
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    void setTransactional(boolean isTransactional) {
        this.isTransactional = isTransactional;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void addWarning(Exception ex) {
        if (ex == null) {
            return;
        }
        this.warnings.add(ex);
    }

    public List<Exception> getWarnings() {
        ArrayList<Exception> result = new ArrayList<Exception>(this.warnings);
        this.warnings.clear();
        return result;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public synchronized void dataAvailable() {
        RequestWorkItem requestWorkItem = this.commandContext.getWorkItem();
        this.dataAvailable = true;
        if (requestWorkItem != null) {
            requestWorkItem.moreWork();
        }
    }

    public synchronized boolean isDataAvailable() {
        boolean result = this.dataAvailable;
        this.dataAvailable = false;
        return result;
    }

    public String getGeneralHint() {
        return StringUtil.join(this.generalHint, (String)" ");
    }

    public String getSourceHint() {
        return StringUtil.join(this.hint, (String)" ");
    }

    public Collection<String> getGeneralHints() {
        return this.generalHint;
    }

    public Collection<String> getSourceHints() {
        return this.hint;
    }

    public void setGeneralHints(Collection<String> generalHint) {
        this.generalHint = generalHint;
    }

    public void setHints(Collection<String> hint) {
        this.hint = hint;
    }

    public String getConnectionID() {
        return this.getConnectionId();
    }

    public Serializable getExecutionPayload() {
        return this.getCommandPayload();
    }

    public String getRequestID() {
        return this.getRequestId();
    }

    public CacheDirective getCacheDirective() {
        return this.cacheDirective;
    }

    public void setCacheDirective(CacheDirective directive) {
        this.cacheDirective = directive;
    }

    public void setRuntimeMetadata(RuntimeMetadataImpl queryMetadata) {
        this.runtimeMetadata = queryMetadata;
    }

    public RuntimeMetadata getRuntimeMetadata() {
        return this.runtimeMetadata;
    }

    public void logCommand(Object ... command) {
        if (this.workItem != null) {
            this.workItem.logCommand(command);
        }
    }

    public CacheDirective.Scope getScope() {
        return this.scope;
    }

    public void setScope(CacheDirective.Scope scope) {
        this.scope = scope;
    }
}

