/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.Collection;
import java.util.List;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.internal.process.CachedResults;
import org.teiid.dqp.internal.process.DataTierManagerImpl;
import org.teiid.dqp.internal.process.DataTierTupleSource;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.internal.process.TupleSourceCache;
import org.teiid.logging.LogManager;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.processor.RegisterRequestParameter;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.translator.CacheDirective;

final class CachingTupleSource
extends TupleSourceCache.CopyOnReadTupleSource {
    private final DataTierManagerImpl dataTierManagerImpl;
    private final SessionAwareCache.CacheID cid;
    private final RegisterRequestParameter parameterObject;
    private final CacheDirective cd;
    private final Collection<GroupSymbol> accessedGroups;
    final DataTierTupleSource dtts;
    final RequestWorkItem item;

    CachingTupleSource(DataTierManagerImpl dataTierManagerImpl, TupleBuffer tb, DataTierTupleSource ts, SessionAwareCache.CacheID cid, RegisterRequestParameter parameterObject, CacheDirective cd, Collection<GroupSymbol> accessedGroups, RequestWorkItem item) {
        super(tb, ts);
        this.dataTierManagerImpl = dataTierManagerImpl;
        this.dtts = ts;
        this.cid = cid;
        this.parameterObject = parameterObject;
        this.cd = cd;
        this.accessedGroups = accessedGroups;
        this.item = item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<?> nextTuple() throws TeiidComponentException, TeiidProcessingException {
        if (this.dtts.scope == CacheDirective.Scope.NONE || this.tb == null) {
            this.removeTupleBuffer();
            return this.ts.nextTuple();
        }
        List<?> tuple = super.nextTuple();
        if (tuple == null && !this.dtts.errored) {
            CacheDirective cacheDirective = this.cd;
            synchronized (cacheDirective) {
                if (this.dtts.scope == CacheDirective.Scope.NONE) {
                    this.removeTupleBuffer();
                    return tuple;
                }
                CachedResults cr = new CachedResults();
                cr.setResults(this.tb, null);
                if (!Boolean.FALSE.equals(this.cd.getUpdatable())) {
                    if (this.accessedGroups != null) {
                        for (GroupSymbol gs : this.accessedGroups) {
                            cr.getAccessInfo().addAccessedObject(gs.getMetadataID());
                        }
                    }
                } else {
                    cr.getAccessInfo().setSensitiveToMetadataChanges(false);
                }
                if (this.parameterObject.limit > 0 && this.parameterObject.limit == this.rowNumber) {
                    cr.setRowLimit(this.rowNumber);
                }
                this.tb.setPrefersMemory(Boolean.TRUE.equals(this.cd.getPrefersMemory()));
                FunctionMethod.Determinism determinismLevel = CachingTupleSource.getDeterminismLevel(this.dtts.scope);
                this.dataTierManagerImpl.requestMgr.getRsCache().put(this.cid, determinismLevel, cr, this.cd.getTtl());
                this.tb = null;
            }
        }
        return tuple;
    }

    public static FunctionMethod.Determinism getDeterminismLevel(CacheDirective.Scope scope) {
        FunctionMethod.Determinism determinismLevel = FunctionMethod.Determinism.SESSION_DETERMINISTIC;
        if (scope != null) {
            switch (scope) {
                case VDB: {
                    determinismLevel = FunctionMethod.Determinism.VDB_DETERMINISTIC;
                    break;
                }
                case SESSION: {
                    determinismLevel = FunctionMethod.Determinism.SESSION_DETERMINISTIC;
                    break;
                }
                case USER: {
                    determinismLevel = FunctionMethod.Determinism.USER_DETERMINISTIC;
                }
            }
        }
        return determinismLevel;
    }

    private void removeTupleBuffer() {
        if (this.tb != null) {
            this.tb.remove();
            this.tb = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSource() {
        block14: {
            try {
                if (this.tb == null || this.dtts.errored) break block14;
                boolean readAll = true;
                CacheDirective cacheDirective = this.cd;
                synchronized (cacheDirective) {
                    readAll = !Boolean.FALSE.equals(this.cd.getReadAll());
                }
                if (!readAll) break block14;
                this.dtts.getAtomicRequestMessage().setSerial(true);
                while (this.dtts.scope != CacheDirective.Scope.NONE) {
                    if (this.item.isCanceled()) {
                        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)this.dtts.getAtomicRequestMessage().getAtomicRequestID(), (Object)"Not using full results due to cancellation.");
                    } else {
                        try {
                            List<?> tuple = this.nextTuple();
                            if (tuple != null) continue;
                        }
                        catch (BlockedException e) {
                            try {
                                Thread.sleep(50L);
                                continue;
                            }
                            catch (InterruptedException e1) {
                            }
                        }
                        catch (TeiidException e) {
                            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)((Object)e), (Object)this.dtts.getAtomicRequestMessage().getAtomicRequestID(), (Object)"Not using full results due to error.");
                        }
                    }
                    break;
                }
            }
            finally {
                this.removeTupleBuffer();
                this.ts.closeSource();
            }
        }
    }
}

