/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javax.resource.spi.work.Work;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.ThreadReuseExecutor;
import org.teiid.logging.LogManager;

public final class FutureWork<T>
extends FutureTask<T>
implements ThreadReuseExecutor.PrioritizedRunnable,
Work {
    private int priority;
    private long creationTime = System.currentTimeMillis();
    private DQPWorkContext workContext = DQPWorkContext.getWorkContext();
    private List<DQPCore.CompletionListener<T>> completionListeners = new LinkedList<DQPCore.CompletionListener<T>>();
    private String parentName;
    private String requestId;

    public FutureWork(Callable<T> processor, int priority) {
        super(processor);
        this.parentName = Thread.currentThread().getName();
        this.priority = priority;
    }

    public FutureWork(Runnable processor, T result, int priority) {
        super(processor, result);
        this.priority = priority;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    @Override
    public void run() {
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"Running task for parent thread", (Object)this.parentName);
        LogManager.putMdc((String)"teiid-request", (String)this.requestId);
        try {
            super.run();
        }
        finally {
            LogManager.removeMdc((String)"teiid-request");
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public DQPWorkContext getDqpWorkContext() {
        return this.workContext;
    }

    public void release() {
    }

    synchronized void addCompletionListener(DQPCore.CompletionListener<T> completionListener) {
        if (this.isDone()) {
            completionListener.onCompletion(this);
            return;
        }
        this.completionListeners.add(completionListener);
    }

    @Override
    protected synchronized void done() {
        for (DQPCore.CompletionListener<T> listener : this.completionListeners) {
            try {
                listener.onCompletion(this);
            }
            catch (Throwable t) {
                LogManager.logError((String)"org.teiid.PROCESSOR", (Throwable)t, (Object)"Uncaught throwable from completion listener");
            }
        }
        this.completionListeners.clear();
    }
}

