/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.FileStoreInputStreamFactory;
import org.teiid.core.types.InputStreamFactory;

public final class SaveOnReadInputStream
extends FilterInputStream {
    private SwitchingInputStream sis = new SwitchingInputStream();
    private final FileStoreInputStreamFactory fsisf;
    private FileStore.FileStoreOutputStream fsos;
    private boolean saved;
    private boolean read;
    private boolean returned;
    InputStreamFactory inputStreamFactory = new InputStreamFactory(){

        public InputStream getInputStream() throws IOException {
            if (!SaveOnReadInputStream.this.saved) {
                if (!SaveOnReadInputStream.this.returned) {
                    SaveOnReadInputStream.this.returned = true;
                    return SaveOnReadInputStream.this.sis;
                }
                SaveOnReadInputStream.this.fsos.flush();
                long start = SaveOnReadInputStream.this.fsisf.getLength();
                SaveOnReadInputStream.this.close();
                InputStream is = SaveOnReadInputStream.this.fsisf.getInputStream(start, -1L);
                SaveOnReadInputStream.this.sis.setIn(is);
            }
            return SaveOnReadInputStream.this.fsisf.getInputStream();
        }

        public InputStreamFactory.StorageMode getStorageMode() {
            if (!SaveOnReadInputStream.this.saved) {
                try {
                    this.getInputStream().close();
                }
                catch (IOException e) {
                    return InputStreamFactory.StorageMode.OTHER;
                }
            }
            return SaveOnReadInputStream.this.fsisf.getStorageMode();
        }
    };

    public SaveOnReadInputStream(InputStream in, FileStoreInputStreamFactory fsisf) {
        super(in);
        this.fsisf = fsisf;
        this.fsos = fsisf.getOuputStream();
    }

    @Override
    public int read() throws IOException {
        this.read = true;
        int i = super.read();
        this.read = false;
        if (i > 0) {
            this.fsos.write(i);
        } else {
            this.saved = true;
        }
        return i;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.read = true;
        int bytes = super.read(b, off, len);
        this.read = false;
        if (bytes > 0) {
            this.fsos.write(b, off, bytes);
        } else if (bytes == -1) {
            this.saved = true;
        }
        return bytes;
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.saved && !this.read) {
                byte[] bytes = new byte[8192];
                while (!this.saved) {
                    this.read(bytes, 0, bytes.length);
                }
            }
            this.fsos.close();
        }
        finally {
            if (!this.saved) {
                this.fsisf.free();
                this.saved = true;
            }
            super.close();
        }
    }

    public InputStreamFactory getInputStreamFactory() {
        return this.inputStreamFactory;
    }

    class SwitchingInputStream
    extends FilterInputStream {
        protected SwitchingInputStream() {
            super(SaveOnReadInputStream.this);
        }

        public void setIn(InputStream is) {
            this.in = is;
        }
    }
}

