/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.TransformationException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.core.util.StringUtil;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.jdbc.TeiidConnection;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.CharsetUtils;
import org.teiid.query.function.TeiidFunction;
import org.teiid.query.metadata.MaterializationMetadataRepository;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;
import org.teiid.query.util.CommandContext;

public final class FunctionMethods {
    private static final boolean CALENDAR_TIMESTAMPDIFF = PropertiesUtils.getBooleanProperty((Properties)System.getProperties(), (String)"org.teiid.calendarTimestampDiff", (boolean)true);
    public static final String AT = "@";
    private static final BigDecimal ZERO = new BigDecimal(0);
    private static final double log10baseE = Math.log(10.0);
    static String[] dayNames;
    static String[] monthNames;
    private static final char SPACE = ' ';
    public static final String SPACE_CHAR = " ";

    public static int plus(int x, int y) throws FunctionExecutionException {
        long result = (long)x + (long)y;
        if (result > Integer.MAX_VALUE || result < Integer.MIN_VALUE) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID31169, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31169, new Object[]{result}));
        }
        return (int)result;
    }

    public static long plus(long x, long y) throws FunctionExecutionException {
        if (y > 0L ? x > Long.MAX_VALUE - y : x < Long.MIN_VALUE - y) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID31169, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31169, new Object[]{BigInteger.valueOf(x).add(BigInteger.valueOf(y))}));
        }
        return x + y;
    }

    public static float plus(float x, float y) {
        return x + y;
    }

    public static double plus(double x, double y) {
        return x + y;
    }

    public static Object plus(BigInteger x, BigInteger y) {
        return x.add(y);
    }

    public static Object plus(BigDecimal x, BigDecimal y) {
        return x.add(y);
    }

    public static int minus(int x, int y) throws FunctionExecutionException {
        long result = (long)x - (long)y;
        if (result > Integer.MAX_VALUE || result < Integer.MIN_VALUE) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID31169, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31169, new Object[]{result}));
        }
        return (int)result;
    }

    public static long minus(long x, long y) throws FunctionExecutionException {
        if (y > 0L ? x < Long.MIN_VALUE + y : x > Long.MAX_VALUE + y) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID31169, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31169, new Object[]{BigInteger.valueOf(x).subtract(BigInteger.valueOf(y))}));
        }
        return x - y;
    }

    public static float minus(float x, float y) {
        return x - y;
    }

    public static double minus(double x, double y) {
        return x - y;
    }

    public static Object minus(BigInteger x, BigInteger y) {
        return x.subtract(y);
    }

    public static Object minus(BigDecimal x, BigDecimal y) {
        return x.subtract(y);
    }

    public static int multiply(int x, int y) throws FunctionExecutionException {
        long result = (long)x * (long)y;
        if (result > Integer.MAX_VALUE || result < Integer.MIN_VALUE) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID31169, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31169, new Object[]{result}));
        }
        return (int)result;
    }

    public static long multiply(long x, long y) throws FunctionExecutionException {
        if (y > 0L && (x > Long.MAX_VALUE / y || x < Long.MIN_VALUE / y) || y < -1L && (x > Long.MIN_VALUE / y || x < Long.MAX_VALUE / y) || y == -1L && x == Long.MIN_VALUE) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID31169, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31169, new Object[]{BigInteger.valueOf(x).multiply(BigInteger.valueOf(y))}));
        }
        return x * y;
    }

    public static float multiply(float x, float y) {
        return x * y;
    }

    public static double multiply(double x, double y) {
        return x * y;
    }

    public static Object multiply(BigInteger x, BigInteger y) {
        return x.multiply(y);
    }

    public static Object multiply(BigDecimal x, BigDecimal y) {
        return x.multiply(y);
    }

    public static int divide(int x, int y) throws FunctionExecutionException {
        if (x == Integer.MIN_VALUE && y == -1) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID31169, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31169, new Object[]{0x80000000L}));
        }
        return x / y;
    }

    public static long divide(long x, long y) throws FunctionExecutionException {
        if (x == Long.MIN_VALUE && y == -1L) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID31169, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31169, new Object[]{BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.valueOf(1L))}));
        }
        return x / y;
    }

    public static float divide(float x, float y) {
        return x / y;
    }

    public static double divide(double x, double y) {
        return x / y;
    }

    public static Object divide(BigInteger x, BigInteger y) {
        return x.divide(y);
    }

    public static Object divide(BigDecimal x, BigDecimal y) {
        BigDecimal bd = x.divide(y, Math.max(16, x.scale() + y.precision() + 1), RoundingMode.HALF_UP).stripTrailingZeros();
        if ((bd = bd.setScale(Math.max(x.scale(), bd.scale()))).compareTo(ZERO) == 0) {
            return ZERO;
        }
        return bd;
    }

    public static int abs(int x) throws FunctionExecutionException {
        if (x == Integer.MIN_VALUE) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID31169, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31169, new Object[]{0x80000000L}));
        }
        return Math.abs(x);
    }

    public static long abs(long x) throws FunctionExecutionException {
        if (x == Long.MIN_VALUE) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID31169, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31169, new Object[]{BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.valueOf(1L))}));
        }
        return Math.abs(x);
    }

    public static float abs(float x) {
        return Math.abs(x);
    }

    public static double abs(double x) {
        return Math.abs(x);
    }

    public static Object abs(BigInteger x) {
        return x.abs();
    }

    public static Object abs(BigDecimal x) {
        return x.abs();
    }

    public static Object ceiling(Number x) {
        return new Double(Math.ceil(x.doubleValue()));
    }

    public static Object exp(Number x) {
        return new Double(Math.exp(x.doubleValue()));
    }

    public static Object floor(Number x) {
        return new Double(Math.floor(x.doubleValue()));
    }

    public static Object log(Number x) {
        return new Double(Math.log(x.doubleValue()));
    }

    public static Object log10(Number x) {
        return new Double(Math.log(x.doubleValue()) / log10baseE);
    }

    public static Object rand(CommandContext context, Integer seed) {
        if (seed == null) {
            return new Double(context.getNextRand());
        }
        return new Double(context.getNextRand(seed.longValue()));
    }

    public static Object rand(CommandContext context) {
        return new Double(context.getNextRand());
    }

    public static int mod(int x, int y) {
        return x % y;
    }

    public static long mod(long x, long y) {
        return x % y;
    }

    public static float mod(float x, float y) {
        return x % y;
    }

    public static double mod(double x, double y) {
        return x % y;
    }

    public static Object mod(BigInteger x, BigInteger y) {
        return x.remainder(y);
    }

    public static Object mod(BigDecimal x, BigDecimal y) {
        return x.remainder(y);
    }

    public static double power(double x, double y) {
        return Math.pow(x, y);
    }

    public static BigInteger power(BigInteger x, int y) {
        return x.pow(y);
    }

    public static BigDecimal power(BigDecimal x, int y) {
        return x.pow(y);
    }

    public static int round(int number, int places) {
        if (places < 0) {
            return FunctionMethods.round(new BigDecimal(number), places).intValue();
        }
        return number;
    }

    public static float round(float number, int places) {
        return FunctionMethods.round(new BigDecimal(number), places).floatValue();
    }

    public static double round(double number, int places) {
        return FunctionMethods.round(new BigDecimal(number), places).doubleValue();
    }

    public static BigDecimal round(BigDecimal bigDecimalNumber, int places) {
        int scale = bigDecimalNumber.scale();
        if (scale <= places) {
            return bigDecimalNumber;
        }
        bigDecimalNumber = bigDecimalNumber.setScale(places, 4);
        return bigDecimalNumber.setScale(scale, 4);
    }

    public static Object sign(int x) {
        return Integer.signum(x);
    }

    public static Object sign(long x) {
        return Long.signum(x);
    }

    public static Object sign(float x) {
        return Float.valueOf(Math.signum(x));
    }

    public static Object sign(double x) {
        return Math.signum(x);
    }

    public static Object sign(BigInteger x) {
        return new Integer(x.signum());
    }

    public static Object sign(BigDecimal x) {
        return new Integer(x.signum());
    }

    public static Object sqrt(Number x) {
        return new Double(Math.sqrt(x.doubleValue()));
    }

    public static Object currentDate() {
        return TimestampWithTimezone.createDate((java.util.Date)new java.util.Date());
    }

    public static Object currentTime() {
        return TimestampWithTimezone.createTime((java.util.Date)new java.util.Date());
    }

    public static Object currentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    private static int getField(java.util.Date date, int field) {
        Calendar cal = TimestampWithTimezone.getCalendar();
        cal.setTime(date);
        return cal.get(field);
    }

    public static Object dayName(java.util.Date x) {
        return FunctionMethods.getDayNames()[FunctionMethods.getField(x, 7) - 1];
    }

    private static Locale getSymbolLocale() {
        return PropertiesUtils.getBooleanProperty((Properties)System.getProperties(), (String)"org.teiid.enDateNames", (boolean)false) ? Locale.ENGLISH : Locale.getDefault();
    }

    static String[] getMonthNames() {
        if (monthNames == null) {
            DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(FunctionMethods.getSymbolLocale());
            String[] months = dateFormatSymbols.getMonths();
            monthNames = Arrays.copyOf(months, 12);
        }
        return monthNames;
    }

    static String[] getDayNames() {
        if (dayNames == null) {
            DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(FunctionMethods.getSymbolLocale());
            dayNames = Arrays.copyOfRange(dateFormatSymbols.getWeekdays(), 1, 8);
        }
        return dayNames;
    }

    public static Object dayOfMonth(java.util.Date x) {
        return FunctionMethods.getField(x, 5);
    }

    public static int dayOfWeek(java.util.Date x) {
        int result = FunctionMethods.getField(x, 7);
        return result;
    }

    public static Object dayOfYear(java.util.Date x) {
        return FunctionMethods.getField(x, 6);
    }

    public static Object hour(java.util.Date x) {
        return FunctionMethods.getField(x, 11);
    }

    public static Object minute(java.util.Date x) {
        return FunctionMethods.getField(x, 12);
    }

    public static Object month(java.util.Date x) {
        return FunctionMethods.getField(x, 2) + 1;
    }

    public static Object monthName(java.util.Date x) {
        return FunctionMethods.getMonthNames()[FunctionMethods.getField(x, 2)];
    }

    public static Object second(java.util.Date x) {
        return FunctionMethods.getField(x, 13);
    }

    public static int week(java.util.Date x) {
        return FunctionMethods.getField(x, 3);
    }

    public static Object year(java.util.Date x) {
        return FunctionMethods.getField(x, 1);
    }

    public static Object quarter(java.util.Date date) {
        int month = FunctionMethods.getField(date, 2);
        if (month > 11) {
            throw new AssertionError((Object)("Invalid month for " + date));
        }
        return month / 3 + 1;
    }

    public static Object timestampAdd(String intervalType, Integer count, Timestamp timestamp) {
        Calendar cal = TimestampWithTimezone.getCalendar();
        int nanos = timestamp.getNanos();
        cal.setTime(timestamp);
        if (intervalType.equalsIgnoreCase("SQL_TSI_FRAC_SECOND")) {
            int countValue = count;
            if ((nanos += countValue) > 999999999) {
                int addSecond = nanos / 999999999;
                int leftNanos = nanos % 999999999;
                cal.add(13, addSecond);
                Timestamp ts = new Timestamp(cal.getTime().getTime());
                ts.setNanos(leftNanos);
                return ts;
            }
            Timestamp ts = new Timestamp(cal.getTime().getTime());
            ts.setNanos(nanos);
            return ts;
        }
        FunctionMethods.addField(intervalType, count, cal);
        Timestamp ts = new Timestamp(cal.getTime().getTime());
        ts.setNanos(nanos);
        return ts;
    }

    private static void addField(String interval, Integer count, Calendar cal) {
        int countValue = count;
        if (!interval.equalsIgnoreCase("SQL_TSI_FRAC_SECOND")) {
            if (interval.equalsIgnoreCase("SQL_TSI_SECOND")) {
                cal.add(13, countValue);
            } else if (interval.equalsIgnoreCase("SQL_TSI_MINUTE")) {
                cal.add(12, countValue);
            } else if (interval.equalsIgnoreCase("SQL_TSI_HOUR")) {
                cal.add(11, countValue);
            } else if (interval.equalsIgnoreCase("SQL_TSI_DAY")) {
                cal.add(6, countValue);
            } else if (interval.equalsIgnoreCase("SQL_TSI_WEEK")) {
                cal.add(3, countValue);
            } else if (interval.equalsIgnoreCase("SQL_TSI_MONTH")) {
                cal.add(2, countValue);
            } else if (interval.equalsIgnoreCase("SQL_TSI_QUARTER")) {
                cal.add(2, countValue * 3);
            } else if (interval.equalsIgnoreCase("SQL_TSI_YEAR")) {
                cal.add(1, countValue);
            }
        }
    }

    public static Long timestampDiff(String intervalType, Timestamp ts1Obj, Timestamp ts2Obj) throws FunctionExecutionException {
        return FunctionMethods.timestampDiff(intervalType, ts1Obj, ts2Obj, CALENDAR_TIMESTAMPDIFF);
    }

    public static Long timestampDiff(String intervalType, Timestamp ts1Obj, Timestamp ts2Obj, boolean calendarBased) throws FunctionExecutionException {
        long ts1 = ts1Obj.getTime() / 1000L;
        long ts2 = ts2Obj.getTime() / 1000L;
        long tsDiff = ts2 - ts1;
        long count = 0L;
        if (intervalType.equalsIgnoreCase("SQL_TSI_FRAC_SECOND")) {
            if (Math.abs(tsDiff) > Integer.MAX_VALUE) {
                throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID31144, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31144, new Object[0]));
            }
            count = tsDiff * 1000000000L + (long)ts2Obj.getNanos() - (long)ts1Obj.getNanos();
        } else if (intervalType.equalsIgnoreCase("SQL_TSI_SECOND")) {
            count = tsDiff;
        } else if (calendarBased) {
            if (intervalType.equalsIgnoreCase("SQL_TSI_MINUTE")) {
                count = ts2 / 60L - ts1 / 60L;
            } else if (intervalType.equalsIgnoreCase("SQL_TSI_HOUR")) {
                TimeZone tz = TimestampWithTimezone.getCalendar().getTimeZone();
                if (tz.getDSTSavings() > 0 || tz.getRawOffset() % 3600000 != 0) {
                    ts1 += (long)(tz.getOffset(ts1Obj.getTime()) / 1000);
                    ts2 += (long)(tz.getOffset(ts2Obj.getTime()) / 1000);
                }
                count = ts2 / 3600L - ts1 / 3600L;
            } else if (intervalType.equalsIgnoreCase("SQL_TSI_DAY") || intervalType.equalsIgnoreCase("SQL_TSI_WEEK")) {
                TimeZone tz = TimestampWithTimezone.getCalendar().getTimeZone();
                if (tz.getDSTSavings() > 0 || tz.getRawOffset() % 3600000 != 0) {
                    ts1 += (long)(tz.getOffset(ts1Obj.getTime()) / 1000);
                    ts2 += (long)(tz.getOffset(ts2Obj.getTime()) / 1000);
                }
                count = ts2 / 86400L - ts1 / 86400L;
                if (intervalType.equalsIgnoreCase("SQL_TSI_WEEK")) {
                    long days = count;
                    count /= 7L;
                    if (days % 7L != 0L) {
                        int day1 = FunctionMethods.dayOfWeek(ts1Obj);
                        int day2 = FunctionMethods.dayOfWeek(ts2Obj);
                        int diff = Integer.signum(day2 - day1);
                        if (diff > 0) {
                            if (tsDiff < 0L) {
                                --count;
                            }
                        } else if (diff < 0 && tsDiff > 0L) {
                            ++count;
                        }
                    }
                }
            } else if (intervalType.equalsIgnoreCase("SQL_TSI_MONTH")) {
                Calendar cal = TimestampWithTimezone.getCalendar();
                cal.setTimeInMillis(ts1Obj.getTime());
                int months1 = cal.get(1) * 12 + cal.get(2);
                cal.setTimeInMillis(ts2Obj.getTime());
                int months2 = cal.get(1) * 12 + cal.get(2);
                count = months2 - months1;
            } else if (intervalType.equalsIgnoreCase("SQL_TSI_QUARTER")) {
                Calendar cal = TimestampWithTimezone.getCalendar();
                cal.setTimeInMillis(ts1Obj.getTime());
                int quarters1 = cal.get(1) * 4 + cal.get(2) / 3;
                cal.setTimeInMillis(ts2Obj.getTime());
                int quarters2 = cal.get(1) * 4 + cal.get(2) / 3;
                count = quarters2 - quarters1;
            } else if (intervalType.equalsIgnoreCase("SQL_TSI_YEAR")) {
                Calendar cal = TimestampWithTimezone.getCalendar();
                cal.setTimeInMillis(ts1Obj.getTime());
                int years1 = cal.get(1);
                cal.setTimeInMillis(ts2Obj.getTime());
                int years2 = cal.get(1);
                count = years2 - years1;
            }
        } else if (intervalType.equalsIgnoreCase("SQL_TSI_MINUTE")) {
            count = tsDiff / 60L;
        } else if (intervalType.equalsIgnoreCase("SQL_TSI_HOUR")) {
            count = tsDiff / 3600L;
        } else if (intervalType.equalsIgnoreCase("SQL_TSI_DAY")) {
            count = tsDiff / 86400L;
        } else if (intervalType.equalsIgnoreCase("SQL_TSI_WEEK")) {
            count = tsDiff / 604800L;
        } else if (intervalType.equalsIgnoreCase("SQL_TSI_MONTH")) {
            count = tsDiff / 2592000L;
        } else if (intervalType.equalsIgnoreCase("SQL_TSI_QUARTER")) {
            count = tsDiff / 7862400L;
        } else if (intervalType.equalsIgnoreCase("SQL_TSI_YEAR")) {
            count = tsDiff / 31536000L;
        }
        return count;
    }

    public static Object timestampCreate(Date date, Time time) {
        Calendar tsCal = TimestampWithTimezone.getCalendar();
        tsCal.setTime(time);
        int hour = tsCal.get(11);
        int minute = tsCal.get(12);
        int second = tsCal.get(13);
        tsCal.setTime(date);
        tsCal.set(11, hour);
        tsCal.set(12, minute);
        tsCal.set(13, second);
        return new Timestamp(tsCal.getTime().getTime());
    }

    public static Object length(String str) {
        return str.length();
    }

    public static String concat(String str1, String str2) {
        return str1 + str2;
    }

    public static String concat2(String str1, String str2) {
        if (str1 == null) {
            if (str2 == null) {
                return null;
            }
            return str2;
        }
        if (str2 == null) {
            return str1;
        }
        return str1 + str2;
    }

    /*
     * Exception decompiling
     */
    public static ClobType concat(CommandContext context, ClobType str1, ClobType str2) throws IOException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ClobType concat2(CommandContext context, ClobType str1, ClobType str2) throws IOException, SQLException {
        if (str1 == null) {
            if (str2 == null) {
                return null;
            }
            return str2;
        }
        if (str2 == null) {
            return str1;
        }
        return FunctionMethods.concat(context, str1, str2);
    }

    public static Object substring(String string, Integer startVal, Integer lengthVal) {
        if (startVal < 0) {
            startVal = string.length() + startVal;
        } else if (startVal > 0) {
            Integer n = startVal;
            Integer n2 = startVal = Integer.valueOf(startVal - 1);
        }
        if (startVal < 0 || startVal >= string.length()) {
            return null;
        }
        if (lengthVal < 0) {
            return null;
        }
        int endVal = Math.min(startVal + lengthVal, string.length());
        return new String(string.substring(startVal, endVal));
    }

    public static Object substring(String string, Integer start) {
        int startVal = start;
        return FunctionMethods.substring(string, startVal, string.length());
    }

    public static Object left(String string, Integer count) throws FunctionExecutionException {
        int countValue = count;
        if (countValue < 0) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID30396, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30396, new Object[]{countValue}));
        }
        if (string.length() < countValue) {
            return string;
        }
        return new String(string.substring(0, countValue));
    }

    public static Object right(String string, Integer count) throws FunctionExecutionException {
        int countValue = count;
        if (countValue < 0) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID30396, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30396, new Object[]{countValue}));
        }
        if (string.length() < countValue) {
            return string;
        }
        return new String(string.substring(string.length() - countValue));
    }

    public static Object lowerCase(String str) {
        return str.toLowerCase();
    }

    public static Object upperCase(String str) {
        return str.toUpperCase();
    }

    public static Object locate(String sub, String str) {
        return FunctionMethods.locate(sub, str, 1);
    }

    public static Object endsWith(String sub, String str) {
        return str.endsWith(sub);
    }

    public static Object locate(String sub, String str, Integer start) {
        if (str == null || sub == null) {
            return null;
        }
        if (start == null) {
            start = 1;
        }
        return new Integer(str.indexOf(sub, start - 1) + 1);
    }

    public static String trim(String trimSpec, String trimChar, String string) throws FunctionExecutionException {
        if (trimChar.length() != 1) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID30398, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30398, new Object[]{"TRIM CHAR", trimChar}));
        }
        if (!trimSpec.equalsIgnoreCase("LEADING")) {
            string = FunctionMethods.rightTrim(string, trimChar.charAt(0));
        }
        if (!trimSpec.equalsIgnoreCase("TRAILING")) {
            string = FunctionMethods.leftTrim(string, trimChar.charAt(0));
        }
        return string;
    }

    public static String leftTrim(String string, char trimChar) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == trimChar) continue;
            if (i == 0) {
                return string;
            }
            return new String(string.substring(i));
        }
        return "";
    }

    public static String leftTrim(String string) {
        return FunctionMethods.leftTrim(string, ' ');
    }

    public static String rightTrim(String string, char trimChar) {
        return FunctionMethods.rightTrim(string, trimChar, true);
    }

    public static String rightTrim(String string, char trimChar, boolean newString) {
        for (int i = string.length() - 1; i >= 0; --i) {
            if (string.charAt(i) == trimChar) continue;
            if (i == string.length() - 1) {
                return string;
            }
            String result = string.substring(0, i + 1);
            if (newString) {
                return new String(result);
            }
            return result;
        }
        return "";
    }

    public static Object rightTrim(String string) {
        return FunctionMethods.rightTrim(string, ' ');
    }

    public static Object replace(String string, String subString, String replaceString) {
        return StringUtil.replaceAll((String)string, (String)subString, (String)replaceString);
    }

    public static Object insert(String string1, Integer start, Integer length, String str2) throws FunctionExecutionException {
        int startValue = start;
        int len = length;
        if (startValue < 1 || startValue - 1 > string1.length()) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID30399, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30399, new Object[]{start, string1}));
        }
        if (len < 0) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID30400, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30400, new Object[]{len}));
        }
        if (string1.length() == 0 && (startValue > 1 || len > 0)) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID30401, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30401, new Object[0]));
        }
        StringBuffer result = new StringBuffer();
        result.append(string1.substring(0, startValue - 1));
        int endValue = startValue + len - 1;
        if (endValue > string1.length()) {
            result.append(str2);
        } else {
            result.append(str2);
            result.append(string1.substring(endValue));
        }
        return result.toString();
    }

    public static Object repeat(String str, Integer count) {
        int repeatCount = count;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < repeatCount && result.length() <= DataTypeManager.MAX_STRING_LENGTH; ++i) {
            result.append(str);
        }
        return result.toString();
    }

    public static Integer ascii(String ch) {
        if (ch.length() == 0) {
            return null;
        }
        return ch.charAt(0);
    }

    public static Integer ascii(Character ch) {
        return ch.charValue();
    }

    public static Object chr(int intValue) {
        return new Character((char)intValue);
    }

    public static Object initCap(String s) {
        StringBuffer cap = new StringBuffer();
        boolean checkCap = true;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (checkCap) {
                cap.append(Character.toUpperCase(c));
            } else {
                cap.append(Character.toLowerCase(c));
            }
            checkCap = Character.isWhitespace(c);
        }
        return cap.toString();
    }

    public static Object lpad(String inputString, Integer padLength, String padStr) throws FunctionExecutionException {
        return FunctionMethods.pad(inputString, padLength, padStr, true);
    }

    public static Object pad(String str, Integer padLength, String padStr, boolean left) throws FunctionExecutionException {
        int length = padLength;
        if (length < 1) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID30402, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30402, new Object[0]));
        }
        if (length < str.length()) {
            return new String(str.substring(0, length));
        }
        if (length > DataTypeManager.MAX_STRING_LENGTH) {
            length = DataTypeManager.MAX_STRING_LENGTH;
        }
        if (padStr.length() == 0) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID30403, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30403, new Object[0]));
        }
        StringBuffer outStr = new StringBuffer(str);
        while (outStr.length() < length) {
            if (left) {
                outStr.insert(0, padStr);
                continue;
            }
            outStr.append(padStr);
        }
        if (left) {
            return new String(outStr.substring(outStr.length() - length));
        }
        return new String(outStr.substring(0, length));
    }

    public static Object lpad(String inputString, Integer padLength) throws FunctionExecutionException {
        return FunctionMethods.lpad(inputString, padLength, SPACE_CHAR);
    }

    public static Object rpad(String inputString, Integer padLength, String padStr) throws FunctionExecutionException {
        return FunctionMethods.pad(inputString, padLength, padStr, false);
    }

    public static Object rpad(String inputString, Integer padLength) throws FunctionExecutionException {
        return FunctionMethods.rpad(inputString, padLength, SPACE_CHAR);
    }

    public static Object translate(String str, String in, String out) throws FunctionExecutionException {
        if (in.length() != out.length()) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID30404, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30404, new Object[0]));
        }
        if (in.length() == 0 || str.length() == 0) {
            return str;
        }
        StringBuffer translated = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            int j = in.indexOf(c);
            if (j >= 0) {
                translated.append(out.charAt(j));
                continue;
            }
            translated.append(c);
        }
        return translated.toString();
    }

    public static Object convert(Object src, String type) throws FunctionExecutionException {
        try {
            return DataTypeManager.transformValue((Object)src, (Class)DataTypeManager.getDataTypeClass((String)type));
        }
        catch (TransformationException e) {
            throw new FunctionExecutionException(QueryPlugin.Event.TEIID30405, e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30405, new Object[]{src, DataTypeManager.getDataTypeName(src.getClass()), type}));
        }
    }

    public static Object context(Object context, Object expression) throws FunctionExecutionException {
        throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID30406, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30406, new Object[0]));
    }

    public static Object rowlimit(Object expression) throws FunctionExecutionException {
        throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID30407, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30407, new Object[0]));
    }

    public static Object rowlimitexception(Object expression) throws FunctionExecutionException {
        throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID30407, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30407, new Object[0]));
    }

    public static Object lookup(Object codeTable, Object returnElement, Object keyElement, Object keyValue) {
        throw new UnsupportedOperationException("This method should never be called.");
    }

    public static Object ifnull(Object value, Object ifNullValue) {
        return FunctionMethods.coalesce(value, ifNullValue, new Object[0]);
    }

    public static Object coalesce(Object value, Object value1, Object ... other) {
        if (value != null) {
            return value;
        }
        if (value1 != null) {
            return value1;
        }
        for (Object object : other) {
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public static String format(CommandContext context, java.util.Date date, String format) throws FunctionExecutionException {
        try {
            SimpleDateFormat sdf = CommandContext.getDateFormat(context, format);
            return sdf.format(date);
        }
        catch (IllegalArgumentException iae) {
            throw new FunctionExecutionException(QueryPlugin.Event.TEIID30409, iae, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30409, new Object[]{iae.getMessage()}));
        }
    }

    private static java.util.Date parseDateHelper(CommandContext context, String date, String format) throws FunctionExecutionException {
        SimpleDateFormat df = CommandContext.getDateFormat(context, format);
        try {
            return df.parse(date);
        }
        catch (ParseException e) {
            throw new FunctionExecutionException(QueryPlugin.Event.TEIID30410, e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30410, new Object[]{date, format}));
        }
    }

    public static Timestamp parseTimestamp(CommandContext context, String timestamp, String format) throws FunctionExecutionException {
        return new Timestamp(FunctionMethods.parseDateHelper(context, timestamp, format).getTime());
    }

    public static String format(CommandContext context, Number number, String format) throws FunctionExecutionException {
        try {
            DecimalFormat df = CommandContext.getDecimalFormat(context, format);
            return df.format(number);
        }
        catch (IllegalArgumentException iae) {
            throw new FunctionExecutionException(QueryPlugin.Event.TEIID30411, iae, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30411, new Object[]{iae.getMessage()}));
        }
    }

    public static Object parseInteger(CommandContext context, String number, String format) throws FunctionExecutionException {
        BigDecimal intNum = FunctionMethods.parseBigDecimal(context, number, format);
        return new Integer(((Number)intNum).intValue());
    }

    public static Object parseLong(CommandContext context, String number, String format) throws FunctionExecutionException {
        BigDecimal longNum = FunctionMethods.parseBigDecimal(context, number, format);
        return new Long(((Number)longNum).longValue());
    }

    public static Object parseDouble(CommandContext context, String number, String format) throws FunctionExecutionException {
        BigDecimal doubleNum = FunctionMethods.parseBigDecimal(context, number, format);
        return new Double(((Number)doubleNum).doubleValue());
    }

    public static Object parseFloat(CommandContext context, String number, String format) throws FunctionExecutionException {
        BigDecimal longNum = FunctionMethods.parseBigDecimal(context, number, format);
        return new Float(((Number)longNum).floatValue());
    }

    public static Object parseBigInteger(CommandContext context, String number, String format) throws FunctionExecutionException {
        BigDecimal bigIntegerNum = FunctionMethods.parseBigDecimal(context, number, format);
        return new BigInteger(((Object)bigIntegerNum).toString());
    }

    public static BigDecimal parseBigDecimal(CommandContext context, String number, String format) throws FunctionExecutionException {
        DecimalFormat df = CommandContext.getDecimalFormat(context, format);
        try {
            return (BigDecimal)df.parse(number);
        }
        catch (ParseException e) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID30412, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30412, new Object[]{number, format}));
        }
    }

    public static Object acos(Number number) {
        return new Double(Math.acos(number.doubleValue()));
    }

    public static Object asin(Number number) {
        return new Double(Math.asin(number.doubleValue()));
    }

    public static Object atan(Number number) {
        return new Double(Math.atan(number.doubleValue()));
    }

    public static Object atan2(Number number1, Number number2) {
        return new Double(Math.atan2(number1.doubleValue(), number2.doubleValue()));
    }

    public static Object cos(Number number) {
        return new Double(Math.cos(number.doubleValue()));
    }

    public static Object cot(Number number) {
        return new Double(1.0 / Math.tan(number.doubleValue()));
    }

    public static Object degrees(Number number) {
        return new Double(Math.toDegrees(number.doubleValue()));
    }

    public static Object pi() {
        return new Double(Math.PI);
    }

    public static Object radians(Number number) {
        return new Double(Math.toRadians(number.doubleValue()));
    }

    public static Object sin(Number number) {
        return new Double(Math.sin(number.doubleValue()));
    }

    public static Object tan(Number number) {
        return new Double(Math.tan(number.doubleValue()));
    }

    public static Object bitand(int x, int y) {
        return x & y;
    }

    public static Object bitor(int x, int y) {
        return x | y;
    }

    public static Object bitxor(int x, int y) {
        return x ^ y;
    }

    public static int bitnot(int x) {
        return ~x;
    }

    public static Object user(CommandContext context) {
        return FunctionMethods.user(context, true);
    }

    public static Object user(CommandContext context, boolean includeSecurityDomain) {
        if (!includeSecurityDomain || context.getSession() == null) {
            return context.getUserName();
        }
        String name = context.getUserName();
        return FunctionMethods.escapeName(name) + AT + context.getSession().getSecurityDomain();
    }

    static String escapeName(String name) {
        if (name == null) {
            return name;
        }
        return name.replaceAll(AT, "\\\\@");
    }

    public static Object current_database(CommandContext context) {
        return context.getVdbName();
    }

    public static Object commandPayload(CommandContext context) {
        Serializable payload = context.getCommandPayload();
        if (payload == null) {
            return null;
        }
        return payload.toString();
    }

    public static Object commandPayload(CommandContext context, String param) throws ExpressionEvaluationException, FunctionExecutionException {
        Serializable payload = context.getCommandPayload();
        if (payload == null) {
            return null;
        }
        if (payload instanceof Properties) {
            return ((Properties)payload).getProperty(param);
        }
        throw new ExpressionEvaluationException((BundleUtil.Event)QueryPlugin.Event.TEIID30413, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30413, new Object[]{"commandPayload", payload.getClass().getName()}));
    }

    public static Object env(String propertyName) {
        String propertyNameNocase = propertyName.toLowerCase();
        String value = System.getProperty(propertyName);
        if (value == null) {
            value = System.getProperty(propertyNameNocase);
        }
        return value;
    }

    public static Object session_id(CommandContext context) {
        return context.getConnectionId();
    }

    @TeiidFunction(category="Miscellaneous")
    public static Object node_id() {
        return System.getProperty("jboss.node.name");
    }

    public static Object modifyTimeZone(Timestamp value, String originalTimezoneString, String targetTimezoneString) {
        TimeZone dbmsTimeZone;
        TimeZone originalTimeZone = TimeZone.getTimeZone(originalTimezoneString);
        if (originalTimeZone.equals(dbmsTimeZone = TimeZone.getTimeZone(targetTimezoneString))) {
            return value;
        }
        Calendar cal = Calendar.getInstance(dbmsTimeZone);
        return TimestampWithTimezone.createTimestamp((java.util.Date)value, (TimeZone)originalTimeZone, (Calendar)cal);
    }

    public static Object modifyTimeZone(CommandContext context, Timestamp value, String targetTimezoneString) {
        TimeZone dbmsTimeZone = TimeZone.getTimeZone(targetTimezoneString);
        Calendar cal = Calendar.getInstance(dbmsTimeZone);
        return TimestampWithTimezone.createTimestamp((java.util.Date)value, (TimeZone)context.getServerTimeZone(), (Calendar)cal);
    }

    @TeiidFunction(category="Conversion", name="to_chars", nullOnNull=true)
    public static ClobType toChars(BlobType value, String encoding) throws SQLException, IOException {
        return FunctionMethods.toChars(value, encoding, true);
    }

    @TeiidFunction(category="Conversion", name="to_chars")
    public static ClobType toChars(BlobType value, String encoding, boolean wellFormed) throws SQLException, IOException {
        Charset cs = FunctionMethods.getCharset(encoding);
        InputStreamFactory.BlobInputStreamFactory bisf = new InputStreamFactory.BlobInputStreamFactory((Blob)value.getReference());
        ClobImpl clob = new ClobImpl((InputStreamFactory)bisf, -1L);
        clob.setCharset(cs);
        if (!(wellFormed || "BASE64".equalsIgnoreCase(encoding) || "HEX".equalsIgnoreCase(encoding))) {
            try (Reader r = clob.getCharacterStream();){
                while (r.read() != -1) {
                }
            }
        }
        return new ClobType((Clob)clob);
    }

    @TeiidFunction(category="Conversion", name="to_bytes", nullOnNull=true)
    public static BlobType toBytes(ClobType value, String encoding) throws IOException, SQLException {
        return FunctionMethods.toBytes(value, encoding, true);
    }

    @TeiidFunction(category="Conversion", name="to_bytes")
    public static BlobType toBytes(ClobType value, String encoding, boolean wellFormed) throws IOException, SQLException {
        Charset cs = FunctionMethods.getCharset(encoding);
        InputStreamFactory.ClobInputStreamFactory cisf = new InputStreamFactory.ClobInputStreamFactory((Clob)value.getReference());
        cisf.setCharset(cs);
        if (!wellFormed || "BASE64".equalsIgnoreCase(encoding) || "HEX".equalsIgnoreCase(encoding)) {
            try (ReaderInputStream is = new ReaderInputStream(value.getCharacterStream(), cs.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT));){
                while (is.read() != -1) {
                }
            }
        }
        return new BlobType((Blob)new BlobImpl((InputStreamFactory)cisf));
    }

    public static Charset getCharset(String encoding) {
        if ("BASE64".equalsIgnoreCase(encoding)) {
            return CharsetUtils.BASE64;
        }
        if ("HEX".equalsIgnoreCase(encoding)) {
            return CharsetUtils.HEX;
        }
        return Charset.forName(encoding);
    }

    public static String unescape(String string) {
        return StringUtil.unescape((CharSequence)string, (int)-1, (boolean)true, (StringBuilder)new StringBuilder());
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static Object array_get(Object array, int index) throws FunctionExecutionException, SQLException {
        try {
            if (array instanceof java.sql.Array) {
                return Array.get(((java.sql.Array)array).getArray(index, 1), 0);
            }
            if (array.getClass().isArray()) {
                return Array.get(array, index - 1);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID30416, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30416, new Object[]{array.getClass()}));
    }

    public static int array_length(Object array) throws FunctionExecutionException, SQLException {
        if (array instanceof java.sql.Array) {
            return Array.getLength(((java.sql.Array)array).getArray());
        }
        if (array.getClass().isArray()) {
            return Array.getLength(array);
        }
        throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID30416, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30416, new Object[]{array.getClass()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TeiidFunction(category="System", determinism=FunctionMethod.Determinism.COMMAND_DETERMINISTIC)
    public static int mvstatus(CommandContext context, String schemaName, String viewName, Boolean validity, String status, String action) throws FunctionExecutionException, SQLException, QueryMetadataException, TeiidComponentException {
        if (!(validity != null && validity.booleanValue() || MaterializationMetadataRepository.ErrorAction.IGNORE.name().equalsIgnoreCase(action))) {
            if (MaterializationMetadataRepository.ErrorAction.THROW_EXCEPTION.name().equalsIgnoreCase(action)) {
                throw new FunctionExecutionException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31147, new Object[]{schemaName, viewName}));
            }
            Object id = context.getMetadata().getGroupID(schemaName + '.' + viewName);
            String statusTable = context.getMetadata().getExtensionProperty(id, "{http://www.teiid.org/ext/relational/2012}MATVIEW_STATUS_TABLE", false);
            if (statusTable == null) {
                throw new FunctionExecutionException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31177, new Object[]{schemaName, viewName}));
            }
            statusTable = SQLStringVisitor.getSQLString(new GroupSymbol(statusTable)).toString();
            try (Statement ps = null;){
                TeiidConnection c = context.getConnection();
                ps = c.prepareStatement("SELECT Valid, LoadState FROM " + statusTable + " WHERE VDBName = ? AND VDBVersion = ? AND SchemaName = ? AND Name = ?");
                ps.setString(1, context.getVdbName());
                ps.setString(2, context.getVdbVersion());
                ps.setString(3, schemaName);
                ps.setString(4, viewName);
                ResultSet rs = ps.executeQuery();
                if (rs.next() && rs.getBoolean(1)) {
                    int n = 1;
                    return n;
                }
            }
            context.getWorkItem().scheduleWork(10000L);
            throw BlockedException.INSTANCE;
        }
        return 1;
    }

    @TeiidFunction(category="System")
    public static String[] tokenize(String str, char delimiter) {
        List tokens = StringUtil.tokenize((String)str, (char)delimiter);
        return tokens.toArray(new String[tokens.size()]);
    }

    @TeiidFunction(name="regexp_replace", category="String", nullOnNull=true)
    public static String regexpReplace(CommandContext context, String source, String regex, String replacement) throws FunctionExecutionException {
        return FunctionMethods.regexpReplace(context, source, regex, replacement, "");
    }

    @TeiidFunction(name="regexp_replace", category="String", nullOnNull=true)
    public static ClobType regexpReplace(CommandContext context, ClobType source, String regex, String replacement) throws FunctionExecutionException {
        return FunctionMethods.regexpReplace(context, source, regex, replacement, "");
    }

    @TeiidFunction(name="regexp_replace", category="String", nullOnNull=true)
    public static String regexpReplace(CommandContext context, String source, String regex, String replacement, String flags) throws FunctionExecutionException {
        return FunctionMethods.regexpReplace(context, (CharSequence)source, regex, replacement, flags);
    }

    @TeiidFunction(name="regexp_replace", category="String", nullOnNull=true)
    public static ClobType regexpReplace(CommandContext context, ClobType source, String regex, String replacement, String flags) throws FunctionExecutionException {
        String result = FunctionMethods.regexpReplace(context, source.getCharSequence(), regex, replacement, flags);
        return new ClobType((Clob)new ClobImpl(result));
    }

    public static String regexpReplace(CommandContext context, CharSequence source, String regex, String replacement, String flags) throws FunctionExecutionException {
        Pattern pattern;
        boolean global = false;
        int bitFlags = 0;
        for (int i = 0; i < flags.length(); ++i) {
            char c = flags.charAt(i);
            if (c == 'g') {
                global = true;
                continue;
            }
            if (c == 'i') {
                bitFlags |= 2;
                continue;
            }
            if (c == 'm') {
                bitFlags |= 8;
                continue;
            }
            throw new FunctionExecutionException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31168, new Object[]{Character.valueOf(c)}));
        }
        try {
            pattern = CommandContext.getPattern(context, regex, bitFlags);
        }
        catch (PatternSyntaxException e) {
            throw new FunctionExecutionException(e);
        }
        Matcher matcher = pattern.matcher(source);
        String result = global ? matcher.replaceAll(replacement) : matcher.replaceFirst(replacement);
        return result;
    }
}

