/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.AbstractCompareCriteria;
import org.teiid.query.sql.symbol.Expression;

public class CompareCriteria
extends AbstractCompareCriteria {
    private Expression rightExpression;
    private Boolean isOptional = Boolean.FALSE;

    public CompareCriteria() {
    }

    public CompareCriteria(Expression leftExpression, int operator, Expression rightExpression) {
        this.set(leftExpression, operator, rightExpression);
    }

    public void setRightExpression(Expression expression) {
        this.rightExpression = expression;
    }

    public Expression getRightExpression() {
        return this.rightExpression;
    }

    public void set(Expression leftExpression, int operator, Expression rightExpression) {
        this.setLeftExpression(leftExpression);
        this.setOperator(operator);
        this.setRightExpression(rightExpression);
    }

    public void setOptional(Boolean isOptional) {
        if (isOptional == null && Boolean.TRUE.equals(this.isOptional)) {
            return;
        }
        this.isOptional = isOptional;
    }

    public boolean isOptional() {
        return this.isOptional == null || this.isOptional != false;
    }

    public Boolean getIsOptional() {
        return this.isOptional;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int hc = 0;
        hc = HashCodeUtil.hashCode((int)hc, (int)this.getOperator());
        hc += HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.getLeftExpression()});
        return hc += HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.getRightExpression()});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CompareCriteria)) {
            return false;
        }
        CompareCriteria cc = (CompareCriteria)obj;
        return this.getOperator() == cc.getOperator() && EquivalenceUtil.areEqual((Object)this.getLeftExpression(), (Object)cc.getLeftExpression()) && EquivalenceUtil.areEqual((Object)this.getRightExpression(), (Object)cc.getRightExpression()) || this.getOperator() == 1 && EquivalenceUtil.areEqual((Object)this.getLeftExpression(), (Object)cc.getRightExpression()) && EquivalenceUtil.areEqual((Object)this.getRightExpression(), (Object)cc.getLeftExpression());
    }

    @Override
    public Object clone() {
        Expression leftCopy = null;
        if (this.getLeftExpression() != null) {
            leftCopy = (Expression)this.getLeftExpression().clone();
        }
        Expression rightCopy = null;
        if (this.getRightExpression() != null) {
            rightCopy = (Expression)this.getRightExpression().clone();
        }
        CompareCriteria result = new CompareCriteria(leftCopy, this.getOperator(), rightCopy);
        result.isOptional = this.isOptional;
        return result;
    }
}

