/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.binary;

final class LRUHashMap2 {
    private static final float LOAD_FACTOR = 0.75f;
    private static final int INITIAL_CAPACITY = 16;
    private Entry[] entries = new Entry[16];
    private int threshold = 12;
    private int size = 0;
    private final int maxSize;
    private final Entry header;

    LRUHashMap2(int maxSize) {
        this.maxSize = maxSize;
        this.header.before = this.header.after = (this.header = new Entry(null, null, -1, null, null));
    }

    public void clear() {
        this.size = 0;
        this.header.before = this.header.after = this.header;
        Entry[] src = this.entries;
        int i = src.length;
        while (--i >= 0) {
            src[i] = null;
        }
    }

    public Object get(String key1, String key2) {
        int hash = LRUHashMap2.hash(key1, key2);
        int i = hash & this.entries.length - 1;
        Entry entry = LRUHashMap2.findEntry(key1, key2, this.entries[i], hash);
        if (entry == null) {
            return null;
        }
        entry.remove();
        entry.insert(this.header);
        return entry.value;
    }

    public void put(String key1, String key2, Object value) {
        int hash = LRUHashMap2.hash(key1, key2);
        int i = hash & this.entries.length - 1;
        Entry entry = LRUHashMap2.findEntry(key1, key2, this.entries[i], hash);
        if (entry != null) {
            entry.value = value;
            entry.remove();
            entry.insert(this.header);
        } else {
            this.entries[i] = new Entry(key1, key2, hash, this.entries[i], value);
            this.entries[i].insert(this.header);
            ++this.size;
            if (this.size > this.maxSize) {
                this.removeEntry(this.header.after.key1, this.header.after.key2);
            }
            if (this.size >= this.threshold) {
                this.rehash();
            }
        }
    }

    public int size() {
        return this.size;
    }

    private static Entry findEntry(String key1, String key2, Entry cursor, int hash) {
        while (cursor != null) {
            if (hash == cursor.hash && LRUHashMap2.eq(key1, cursor.key1) && LRUHashMap2.eq(key2, cursor.key2)) {
                cursor.key1 = key1;
                cursor.key2 = key2;
                return cursor;
            }
            cursor = cursor.next;
        }
        return null;
    }

    private void removeEntry(String key1, String key2) {
        int hash = LRUHashMap2.hash(key1, key2);
        int i = hash & this.entries.length - 1;
        Entry previous = null;
        Entry entry = this.entries[i];
        while (entry != null) {
            if (hash == entry.hash && LRUHashMap2.eq(key1, entry.key1) && LRUHashMap2.eq(key2, entry.key2)) {
                if (previous == null) {
                    this.entries[i] = entry.next;
                } else {
                    previous.next = entry.next;
                }
                --this.size;
                entry.remove();
                return;
            }
            previous = entry;
            entry = entry.next;
        }
    }

    private void rehash() {
        Entry[] src = this.entries;
        int capacity = 2 * src.length;
        Entry[] dst = new Entry[capacity];
        int i = src.length;
        while (--i >= 0) {
            Entry entry = src[i];
            while (entry != null) {
                int j = entry.hash & capacity - 1;
                Entry next = entry.next;
                entry.next = dst[j];
                dst[j] = entry;
                entry = next;
            }
        }
        this.entries = dst;
        this.threshold = (int)((float)capacity * 0.75f);
    }

    private static boolean eq(String x, String y) {
        return x == y || x.equals(y);
    }

    private static int hash(String key1, String key2) {
        int h = key1.hashCode();
        if (key2 != "") {
            h ^= key2.hashCode();
        }
        return LRUHashMap2.auxiliaryHash(h);
    }

    private static int auxiliaryHash(int h) {
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    private static final class Entry {
        String key1;
        String key2;
        Object value;
        final int hash;
        Entry next;
        Entry before;
        Entry after;

        Entry(String key1, String key2, int hash, Entry next, Object value) {
            this.key1 = key1;
            this.key2 = key2;
            this.hash = hash;
            this.next = next;
            this.value = value;
        }

        void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        void insert(Entry successor) {
            this.after = successor;
            this.before = successor.before;
            this.before.after = this;
            this.after.before = this;
        }
    }
}

