/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.sandbox;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Arrays;
import junit.framework.AssertionFailedError;
import nu.xom.Document;
import nu.xom.tests.XOMTestCase;
import nux.xom.pool.FileUtil;
import nux.xom.pool.XOMUtil;

class IOTestUtil {
    private static final boolean compareInternalDTDSubset = false;

    IOTestUtil() {
    }

    public static void xomAssertEquals(Document expected, Document actual) {
        try {
            XOMTestCase.assertEquals((Document)expected, (Document)actual);
        }
        catch (AssertionFailedError e) {
            System.out.println("expected = " + expected.toXML());
            System.out.println("actual   = " + actual.toXML());
            System.out.println("Canonical XML Diff: " + IOTestUtil.getCanonicalDifference(expected, actual));
            throw e;
        }
    }

    public static void canonicalAssertEquals(Document expected, Document actual) {
        String diff = IOTestUtil.getCanonicalDifference(expected, actual);
        if (diff != null) {
            throw new RuntimeException("Canonical XML Diff: " + diff);
        }
    }

    public static String getCanonicalDifference(Document expected, Document actual) {
        byte[] a;
        int window = 20;
        byte[] e = XOMUtil.toCanonicalXML(expected);
        if (!Arrays.equals(e, a = XOMUtil.toCanonicalXML(actual))) {
            String diff = "";
            if (e.length != a.length) {
                diff = String.valueOf(diff) + "e.length=" + e.length + ", a.length=" + a.length + "\n";
            }
            int size = Math.min(e.length, a.length);
            int i = 0;
            while (i < size) {
                if (e[i] != a[i]) {
                    diff = String.valueOf(diff) + "diff at i=" + i + ", e[i]=" + e[i] + ", a[i]=" + a[i] + "\n";
                    int off = Math.max(0, i - window);
                    int len1 = Math.min(2 * window, e.length - off);
                    int len2 = Math.min(2 * window, a.length - off);
                    try {
                        diff = String.valueOf(diff) + "e='" + new String(e, off, len1, "UTF-8") + "'\n";
                        diff = String.valueOf(diff) + "a='" + new String(a, off, len2, "UTF-8") + "'\n";
                    }
                    catch (UnsupportedEncodingException x) {
                        throw new RuntimeException(x);
                    }
                    return diff;
                }
                ++i;
            }
        }
        return null;
    }

    private static String getDifference(String expected, String actual) {
        int window = 20;
        String e = expected;
        String a = actual;
        if (!e.equals(a)) {
            String diff = "";
            if (e.length() != a.length()) {
                diff = String.valueOf(diff) + "e.length=" + e.length() + ", a.length=" + a.length() + "\n";
            }
            int size = Math.min(e.length(), a.length());
            int i = 0;
            while (i < size) {
                if (e.charAt(i) != a.charAt(i)) {
                    diff = String.valueOf(diff) + "diff at i=" + i + ", e[i]=" + e.charAt(i) + ", a[i]=" + a.charAt(i) + "\n";
                    int off = Math.max(0, i - window);
                    int len1 = Math.min(2 * window, e.length() - off);
                    int len2 = Math.min(2 * window, a.length() - off);
                    diff = String.valueOf(diff) + "e='" + e.substring(off, off + len1) + "'\n";
                    diff = String.valueOf(diff) + "a='" + a.substring(off, off + len2) + "'\n";
                    return diff;
                }
                ++i;
            }
        }
        return null;
    }

    public static File[] listXMLFiles(String fileName) {
        String cocoon = "*.xmap *.xsp *.xconf *.xsamples *.xweb *.xtest";
        String includes = "*.xml *.xsl *.xsd *.rdf *.svg *.wsdl *.xhtml *.mml *.smil *.smi *.wsdd " + cocoon;
        return IOTestUtil.listXMLFiles(fileName, includes);
    }

    public static File[] listXMLFiles(String fileName, String includes) {
        File file = new File(fileName);
        URI[] uris = !file.exists() ? new URI[]{} : (file.isDirectory() ? FileUtil.listFiles(file.getAbsolutePath(), true, includes, "") : new URI[]{file.toURI()});
        File[] files = new File[uris.length];
        int i = 0;
        while (i < uris.length) {
            files[i] = new File(uris[i]);
            ++i;
        }
        return files;
    }

    static String getSystemProperty(String key, String def) {
        try {
            return System.getProperty(key, def);
        }
        catch (Throwable e) {
            return def;
        }
    }

    static boolean getSystemProperty(String key, boolean def) {
        try {
            return "true".equalsIgnoreCase(System.getProperty(key, String.valueOf(def)));
        }
        catch (Throwable e) {
            return def;
        }
    }
}

