/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import java.util.Iterator;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ApplyTemplates;
import net.sf.saxon.expr.instruct.CallTemplate;
import net.sf.saxon.expr.instruct.GeneralVariable;
import net.sf.saxon.trace.ContextStackFrame;
import net.sf.saxon.trace.InstructionInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextStackIterator
implements Iterator<ContextStackFrame> {
    private XPathContextMajor next;

    public ContextStackIterator(XPathContext context) {
        if (!(context instanceof XPathContextMajor)) {
            context = ContextStackIterator.getMajorCaller(context);
        }
        this.next = (XPathContextMajor)context;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public ContextStackFrame next() {
        XPathContextMajor context = this.next;
        if (context == null) {
            return null;
        }
        int construct = context.getOriginatingConstructType();
        InstructionInfo origin = context.getOrigin();
        if (construct == 2000) {
            this.next = ContextStackIterator.getMajorCaller(context);
            return new ContextStackFrame.CallingApplication();
        }
        if (construct == 2010) {
            this.next = ContextStackIterator.getMajorCaller(context);
            return new ContextStackFrame.BuiltInTemplateRule();
        }
        if (construct == 2009) {
            ContextStackFrame.FunctionCall sf = new ContextStackFrame.FunctionCall();
            UserFunctionCall ufc = (UserFunctionCall)origin;
            sf.setSystemId(ufc.getSystemId());
            sf.setLineNumber(ufc.getLineNumber());
            sf.setContainer(ufc.getContainer());
            sf.setFunctionName(ufc.getFunctionName());
            sf.setContextItem(context.getContextItem());
            this.next = ContextStackIterator.getMajorCaller(context);
            return sf;
        }
        if (construct == 132) {
            ContextStackFrame.ApplyTemplates sf = new ContextStackFrame.ApplyTemplates();
            ApplyTemplates loc = (ApplyTemplates)origin;
            sf.setSystemId(loc.getSystemId());
            sf.setLineNumber(loc.getLineNumber());
            sf.setContainer(loc.getContainer());
            sf.setContextItem(context.getContextItem());
            this.next = ContextStackIterator.getMajorCaller(context);
            return sf;
        }
        if (construct == 137) {
            ContextStackFrame.CallTemplate sf = new ContextStackFrame.CallTemplate();
            CallTemplate loc = (CallTemplate)origin;
            sf.setSystemId(loc.getSystemId());
            sf.setLineNumber(loc.getLineNumber());
            sf.setContainer(loc.getContainer());
            sf.setTemplateName(loc.getObjectName());
            sf.setContextItem(context.getContextItem());
            this.next = ContextStackIterator.getMajorCaller(context);
            return sf;
        }
        if (construct == 205) {
            ContextStackFrame.VariableEvaluation sf = new ContextStackFrame.VariableEvaluation();
            GeneralVariable var = (GeneralVariable)((Object)origin);
            sf.setSystemId(var.getSystemId());
            sf.setLineNumber(var.getLineNumber());
            sf.setContainer(var.getContainer());
            sf.setContextItem(context.getContextItem());
            sf.setVariableName(var.getVariableQName());
            this.next = ContextStackIterator.getMajorCaller(context);
            return sf;
        }
        this.next = ContextStackIterator.getMajorCaller(context);
        ContextStackFrame csf = this.next();
        if (csf == null) {
            return new ContextStackFrame.CallingApplication();
        }
        return csf;
    }

    private static XPathContextMajor getMajorCaller(XPathContext context) {
        XPathContext caller;
        for (caller = context.getCaller(); caller != null && !(caller instanceof XPathContextMajor); caller = caller.getCaller()) {
        }
        return (XPathContextMajor)caller;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

