/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkManager;
import javax.transaction.TransactionManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.access.Environment;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.RelativePathService;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.threads.ThreadFactoryResolver;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.teiid.CommandContext;
import org.teiid.PolicyDecider;
import org.teiid.PreParser;
import org.teiid.cache.CacheFactory;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBufferCache;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.RestWarGenerator;
import org.teiid.deployers.VDBRepository;
import org.teiid.deployers.VDBStatusChecker;
import org.teiid.dqp.internal.datamgr.TranslatorRepository;
import org.teiid.dqp.internal.process.AuthorizationValidator;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DefaultAuthorizationValidator;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.service.SessionService;
import org.teiid.events.EventDistributorFactory;
import org.teiid.jboss.BufferManagerService;
import org.teiid.jboss.CacheFactoryService;
import org.teiid.jboss.CacheService;
import org.teiid.jboss.DQPCoreService;
import org.teiid.jboss.DynamicVDBRootMountDeployer;
import org.teiid.jboss.EventDistributorFactoryService;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.JBossLifeCycleListener;
import org.teiid.jboss.JBossSecurityHelper;
import org.teiid.jboss.JGroupsObjectReplicatorService;
import org.teiid.jboss.MaterializationManagementService;
import org.teiid.jboss.ObjectsSerializerService;
import org.teiid.jboss.ReferenceFactoryService;
import org.teiid.jboss.ResteasyEnabler;
import org.teiid.jboss.TeiidConstants;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.jboss.ThreadExecutorService;
import org.teiid.jboss.TranslatorDependencyDeployer;
import org.teiid.jboss.TranslatorDeployer;
import org.teiid.jboss.TranslatorStructureDeployer;
import org.teiid.jboss.TupleBufferCacheService;
import org.teiid.jboss.VDBDependencyDeployer;
import org.teiid.jboss.VDBDeployer;
import org.teiid.jboss.VDBParserDeployer;
import org.teiid.jboss.VDBRepositoryService;
import org.teiid.jboss.VDBStructureDeployer;
import org.teiid.logging.LogManager;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.query.ObjectReplicator;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.security.SecurityHelper;
import org.teiid.services.InternalEventDistributorFactory;
import org.teiid.services.SessionServiceImpl;
import org.wildfly.clustering.jgroups.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.service.ProtocolStackServiceName;

class TeiidAdd
extends AbstractAddStepHandler {
    public static TeiidAdd INSTANCE = new TeiidAdd();
    static SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{TeiidConstants.ALLOW_ENV_FUNCTION_ELEMENT, TeiidConstants.ASYNC_THREAD_POOL_ELEMENT, TeiidConstants.THREAD_COUNT_ATTRIBUTE, TeiidConstants.MAX_THREADS_ELEMENT, TeiidConstants.MAX_ACTIVE_PLANS_ELEMENT, TeiidConstants.USER_REQUEST_SOURCE_CONCURRENCY_ELEMENT, TeiidConstants.TIME_SLICE_IN_MILLI_ELEMENT, TeiidConstants.MAX_ROWS_FETCH_SIZE_ELEMENT, TeiidConstants.LOB_CHUNK_SIZE_IN_KB_ELEMENT, TeiidConstants.QUERY_THRESHOLD_IN_SECS_ELEMENT, TeiidConstants.MAX_SOURCE_ROWS_ELEMENT, TeiidConstants.EXCEPTION_ON_MAX_SOURCE_ROWS_ELEMENT, TeiidConstants.DETECTING_CHANGE_EVENTS_ELEMENT, TeiidConstants.QUERY_TIMEOUT, TeiidConstants.WORKMANAGER, TeiidConstants.PREPARSER_MODULE_ELEMENT, TeiidConstants.AUTHORIZATION_VALIDATOR_MODULE_ELEMENT, TeiidConstants.POLICY_DECIDER_MODULE_ELEMENT, TeiidConstants.DATA_ROLES_REQUIRED_ELEMENT, TeiidConstants.DC_STACK_ATTRIBUTE, TeiidConstants.USE_DISK_ATTRIBUTE, TeiidConstants.INLINE_LOBS, TeiidConstants.PROCESSOR_BATCH_SIZE_ATTRIBUTE, TeiidConstants.MAX_PROCESSING_KB_ATTRIBUTE, TeiidConstants.MAX_RESERVED_KB_ATTRIBUTE, TeiidConstants.MAX_FILE_SIZE_ATTRIBUTE, TeiidConstants.MAX_BUFFER_SPACE_ATTRIBUTE, TeiidConstants.MAX_OPEN_FILES_ATTRIBUTE, TeiidConstants.MEMORY_BUFFER_SPACE_ATTRIBUTE, TeiidConstants.MEMORY_BUFFER_OFFHEAP_ATTRIBUTE, TeiidConstants.MAX_STORAGE_OBJECT_SIZE_ATTRIBUTE, TeiidConstants.ENCRYPT_FILES_ATTRIBUTE, TeiidConstants.PPC_NAME_ATTRIBUTE, TeiidConstants.PPC_CONTAINER_NAME_ATTRIBUTE, TeiidConstants.PPC_ENABLE_ATTRIBUTE, TeiidConstants.RSC_NAME_ATTRIBUTE, TeiidConstants.RSC_CONTAINER_NAME_ATTRIBUTE, TeiidConstants.RSC_MAX_STALENESS_ATTRIBUTE, TeiidConstants.RSC_ENABLE_ATTRIBUTE, TeiidConstants.AUTHENTICATION_SECURITY_DOMAIN_ATTRIBUTE, TeiidConstants.AUTHENTICATION_MAX_SESSIONS_ALLOWED_ATTRIBUTE, TeiidConstants.AUTHENTICATION_SESSION_EXPIRATION_TIME_LIMIT_ATTRIBUTE, TeiidConstants.AUTHENTICATION_TYPE_ATTRIBUTE, TeiidConstants.AUTHENTICATION_TRUST_ALL_LOCAL_ATTRIBUTE, TeiidConstants.AUTHENTICATION_ALLOW_SECURITY_DOMAIN_QUALIFIER};

    TeiidAdd() {
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        resource.getModel().setEmptyObject();
        TeiidAdd.populate(operation, resource.getModel());
        if (context.getProcessType().equals((Object)ProcessType.STANDALONE_SERVER) && context.isNormalServer()) {
            this.deployResources(context);
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        throw new UnsupportedOperationException();
    }

    static void populate(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (int i = 0; i < ATTRIBUTES.length; ++i) {
            ATTRIBUTES[i].validateAndSet(operation, model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                classloader = Module.getCallerModule().getClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Thread.currentThread().setContextClassLoader(classloader);
            this.initilaizeTeiidEngine(context, operation);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classloader);
        }
    }

    public String getNodeName() {
        String nodeName = System.getProperty("jboss.node.name");
        try {
            return nodeName != null ? nodeName : InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    private void initilaizeTeiidEngine(OperationContext context, ModelNode operation) throws OperationFailedException {
        AuthorizationValidator authValidator;
        ServiceTarget target = context.getServiceTarget();
        String nodeName = this.getNodeName();
        int maxThreads = 10;
        if (TeiidConstants.isDefined(TeiidConstants.ASYNC_THREAD_POOL_ELEMENT, operation, context) && TeiidConstants.asInt(TeiidConstants.THREAD_COUNT_ATTRIBUTE, operation, context) != null) {
            maxThreads = TeiidConstants.asInt(TeiidConstants.THREAD_COUNT_ATTRIBUTE, operation, context);
        }
        this.buildThreadService(maxThreads, target);
        final TranslatorRepository translatorRepo = new TranslatorRepository();
        ValueService translatorService = new ValueService((Value)new Value<TranslatorRepository>(){

            public TranslatorRepository getValue() throws IllegalStateException, IllegalArgumentException {
                return translatorRepo;
            }
        });
        ServiceController service = target.addService(TeiidServiceNames.TRANSLATOR_REPO, (Service)translatorService).install();
        SystemFunctionManager systemFunctionManager = new SystemFunctionManager();
        if (TeiidConstants.isDefined(TeiidConstants.ALLOW_ENV_FUNCTION_ELEMENT, operation, context)) {
            systemFunctionManager.setAllowEnvFunction(TeiidConstants.asBoolean(TeiidConstants.ALLOW_ENV_FUNCTION_ELEMENT, operation, context).booleanValue());
        } else {
            systemFunctionManager.setAllowEnvFunction(false);
        }
        systemFunctionManager.setClassloader(Thread.currentThread().getContextClassLoader());
        final VDBRepository vdbRepository = new VDBRepository();
        vdbRepository.setSystemFunctionManager(systemFunctionManager);
        if (TeiidConstants.isDefined(TeiidConstants.DATA_ROLES_REQUIRED_ELEMENT, operation, context) && TeiidConstants.asBoolean(TeiidConstants.DATA_ROLES_REQUIRED_ELEMENT, operation, context).booleanValue()) {
            vdbRepository.setDataRolesRequired(true);
        }
        VDBRepositoryService vdbRepositoryService = new VDBRepositoryService(vdbRepository);
        target.addService(TeiidServiceNames.VDB_REPO, (Service)vdbRepositoryService).install();
        final VDBStatusCheckerExecutorService statusChecker = new VDBStatusCheckerExecutorService();
        ValueService statusService = new ValueService((Value)new Value<VDBStatusChecker>(){

            public VDBStatusChecker getValue() throws IllegalStateException, IllegalArgumentException {
                return statusChecker;
            }
        });
        ServiceBuilder statusBuilder = target.addService(TeiidServiceNames.VDB_STATUS_CHECKER, (Service)statusService);
        statusBuilder.addDependency(TeiidServiceNames.THREAD_POOL_SERVICE, Executor.class, statusChecker.executorInjector);
        statusBuilder.addDependency(TeiidServiceNames.VDB_REPO, VDBRepository.class, statusChecker.vdbRepoInjector);
        statusBuilder.install();
        RelativePathService.addService((ServiceName)TeiidServiceNames.DATA_DIR, (String)"teiid-data", (String)"jboss.server.data.dir", (ServiceTarget)target);
        ObjectsSerializerService serializer = new ObjectsSerializerService();
        ServiceBuilder objectSerializerService = target.addService(TeiidServiceNames.OBJECT_SERIALIZER, (Service)serializer);
        objectSerializerService.addDependency(TeiidServiceNames.DATA_DIR, String.class, serializer.getPathInjector());
        objectSerializerService.install();
        boolean replicatorAvailable = false;
        if (TeiidConstants.isDefined(TeiidConstants.DC_STACK_ATTRIBUTE, operation, context)) {
            String stack = TeiidConstants.asString(TeiidConstants.DC_STACK_ATTRIBUTE, operation, context);
            replicatorAvailable = true;
            JGroupsObjectReplicatorService replicatorService = new JGroupsObjectReplicatorService();
            ServiceBuilder serviceBuilder = target.addService(TeiidServiceNames.OBJECT_REPLICATOR, (Service)replicatorService);
            serviceBuilder.addDependency(ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(stack), ChannelFactory.class, replicatorService.channelFactoryInjector);
            serviceBuilder.addDependency(TeiidServiceNames.THREAD_POOL_SERVICE, Executor.class, replicatorService.executorInjector);
            serviceBuilder.install();
            LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50003, new Object[0]));
        } else {
            LogManager.logDetail((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.getString("distributed_cache_not_enabled"));
        }
        RelativePathService.addService((ServiceName)TeiidServiceNames.BUFFER_DIR, (String)"teiid-buffer", (String)"jboss.server.temp.dir", (ServiceTarget)target);
        BufferManagerService bufferService = this.buildBufferManager(context, operation);
        ServiceBuilder bufferServiceBuilder = target.addService(TeiidServiceNames.BUFFER_MGR, (Service)bufferService);
        bufferServiceBuilder.addDependency(TeiidServiceNames.BUFFER_DIR, String.class, bufferService.pathInjector);
        bufferServiceBuilder.install();
        TupleBufferCacheService tupleBufferService = new TupleBufferCacheService();
        ServiceBuilder tupleBufferBuilder = target.addService(TeiidServiceNames.TUPLE_BUFFER, (Service)tupleBufferService);
        tupleBufferBuilder.addDependency(TeiidServiceNames.BUFFER_MGR, BufferManager.class, tupleBufferService.bufferMgrInjector);
        tupleBufferBuilder.addDependency(replicatorAvailable ? ServiceBuilder.DependencyType.REQUIRED : ServiceBuilder.DependencyType.OPTIONAL, TeiidServiceNames.OBJECT_REPLICATOR, ObjectReplicator.class, tupleBufferService.replicatorInjector);
        tupleBufferBuilder.install();
        EventDistributorFactoryService edfs = new EventDistributorFactoryService();
        ServiceBuilder edfsServiceBuilder = target.addService(TeiidServiceNames.EVENT_DISTRIBUTOR_FACTORY, (Service)edfs);
        edfsServiceBuilder.addDependency(TeiidServiceNames.VDB_REPO, VDBRepository.class, edfs.vdbRepositoryInjector);
        edfsServiceBuilder.addDependency(replicatorAvailable ? ServiceBuilder.DependencyType.REQUIRED : ServiceBuilder.DependencyType.OPTIONAL, TeiidServiceNames.OBJECT_REPLICATOR, ObjectReplicator.class, edfs.objectReplicatorInjector);
        edfsServiceBuilder.install();
        PolicyDecider policyDecider = null;
        if (TeiidConstants.isDefined(TeiidConstants.POLICY_DECIDER_MODULE_ELEMENT, operation, context)) {
            policyDecider = TeiidAdd.buildService(PolicyDecider.class, TeiidConstants.asString(TeiidConstants.POLICY_DECIDER_MODULE_ELEMENT, operation, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.AUTHORIZATION_VALIDATOR_MODULE_ELEMENT, operation, context)) {
            authValidator = TeiidAdd.buildService(AuthorizationValidator.class, TeiidConstants.asString(TeiidConstants.AUTHORIZATION_VALIDATOR_MODULE_ELEMENT, operation, context));
        } else {
            DefaultAuthorizationValidator dap = new DefaultAuthorizationValidator();
            dap.setPolicyDecider(policyDecider);
            authValidator = dap;
        }
        ValueService authValidatorService = new ValueService((Value)new Value<AuthorizationValidator>(){

            public AuthorizationValidator getValue() throws IllegalStateException, IllegalArgumentException {
                return authValidator;
            }
        });
        target.addService(TeiidServiceNames.AUTHORIZATION_VALIDATOR, (Service)authValidatorService).install();
        final PreParser preParser = TeiidConstants.isDefined(TeiidConstants.PREPARSER_MODULE_ELEMENT, operation, context) ? TeiidAdd.buildService(PreParser.class, TeiidConstants.asString(TeiidConstants.PREPARSER_MODULE_ELEMENT, operation, context)) : new PreParser(){

            public String preParse(String command, CommandContext context) {
                return command;
            }
        };
        ValueService preParserService = new ValueService((Value)new Value<PreParser>(){

            public PreParser getValue() throws IllegalStateException, IllegalArgumentException {
                return preParser;
            }
        });
        target.addService(TeiidServiceNames.PREPARSER, (Service)preParserService).install();
        boolean rsCache = true;
        if (TeiidConstants.isDefined(TeiidConstants.RSC_ENABLE_ATTRIBUTE, operation, context) && !TeiidConstants.asBoolean(TeiidConstants.RSC_ENABLE_ATTRIBUTE, operation, context).booleanValue()) {
            rsCache = false;
        }
        if (!TeiidConstants.isDefined(TeiidConstants.RSC_CONTAINER_NAME_ATTRIBUTE, operation, context)) {
            throw new OperationFailedException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50094, new Object[0]));
        }
        String cacheName = "resultset";
        if (TeiidConstants.isDefined(TeiidConstants.RSC_NAME_ATTRIBUTE, operation, context)) {
            cacheName = TeiidConstants.asString(TeiidConstants.RSC_NAME_ATTRIBUTE, operation, context);
        }
        if (rsCache) {
            CacheFactoryService cfs = new CacheFactoryService();
            ServiceBuilder cacheFactoryBuilder = target.addService(TeiidServiceNames.RESULTSET_CACHE_FACTORY, (Service)cfs);
            String ispnName = TeiidConstants.asString(TeiidConstants.RSC_CONTAINER_NAME_ATTRIBUTE, operation, context);
            cacheFactoryBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"infinispan", ispnName}), EmbeddedCacheManager.class, cfs.cacheContainerInjector);
            cacheFactoryBuilder.install();
            int maxStaleness = 0;
            if (TeiidConstants.isDefined(TeiidConstants.RSC_MAX_STALENESS_ATTRIBUTE, operation, context)) {
                maxStaleness = TeiidConstants.asInt(TeiidConstants.RSC_MAX_STALENESS_ATTRIBUTE, operation, context);
            }
            CacheService resultSetService = new CacheService(cacheName, SessionAwareCache.Type.RESULTSET, maxStaleness);
            ServiceBuilder resultsCacheBuilder = target.addService(TeiidServiceNames.CACHE_RESULTSET, resultSetService);
            resultsCacheBuilder.addDependency(TeiidServiceNames.TUPLE_BUFFER, TupleBufferCache.class, resultSetService.tupleBufferCacheInjector);
            resultsCacheBuilder.addDependency(TeiidServiceNames.RESULTSET_CACHE_FACTORY, CacheFactory.class, resultSetService.cacheFactoryInjector);
            resultsCacheBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"infinispan", ispnName, cacheName}));
            resultsCacheBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"infinispan", ispnName, cacheName + "-repl"}));
            resultsCacheBuilder.install();
        }
        boolean ppCache = true;
        if (TeiidConstants.isDefined(TeiidConstants.PPC_ENABLE_ATTRIBUTE, operation, context)) {
            ppCache = TeiidConstants.asBoolean(TeiidConstants.PPC_ENABLE_ATTRIBUTE, operation, context);
        }
        if (!TeiidConstants.isDefined(TeiidConstants.PPC_CONTAINER_NAME_ATTRIBUTE, operation, context)) {
            throw new OperationFailedException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50095, new Object[0]));
        }
        cacheName = "preparedplan";
        if (TeiidConstants.isDefined(TeiidConstants.PPC_NAME_ATTRIBUTE, operation, context)) {
            cacheName = TeiidConstants.asString(TeiidConstants.PPC_NAME_ATTRIBUTE, operation, context);
        }
        if (ppCache) {
            CacheFactoryService cfs = new CacheFactoryService();
            ServiceBuilder cacheFactoryBuilder = target.addService(TeiidServiceNames.PREPAREDPLAN_CACHE_FACTORY, (Service)cfs);
            String ispnName = TeiidConstants.asString(TeiidConstants.PPC_CONTAINER_NAME_ATTRIBUTE, operation, context);
            cacheFactoryBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"infinispan", ispnName}), EmbeddedCacheManager.class, cfs.cacheContainerInjector);
            cacheFactoryBuilder.install();
            CacheService preparedPlanService = new CacheService(cacheName, SessionAwareCache.Type.PREPAREDPLAN, 0);
            ServiceBuilder preparedPlanCacheBuilder = target.addService(TeiidServiceNames.CACHE_PREPAREDPLAN, preparedPlanService);
            preparedPlanCacheBuilder.addDependency(TeiidServiceNames.PREPAREDPLAN_CACHE_FACTORY, CacheFactory.class, preparedPlanService.cacheFactoryInjector);
            preparedPlanCacheBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"infinispan", ispnName, cacheName}));
            preparedPlanCacheBuilder.install();
        }
        DQPCoreService engine = this.buildQueryEngine(context, operation);
        String workManager = "default";
        if (TeiidConstants.isDefined(TeiidConstants.WORKMANAGER, operation, context)) {
            workManager = TeiidConstants.asString(TeiidConstants.WORKMANAGER, operation, context);
        }
        ServiceBuilder engineBuilder = target.addService(TeiidServiceNames.ENGINE, (Service)engine);
        engineBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"connector", "workmanager", workManager}), WorkManager.class, engine.getWorkManagerInjector());
        engineBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"txn", "XATerminator"}), XATerminator.class, engine.getXaTerminatorInjector());
        engineBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"txn", "TransactionManager"}), TransactionManager.class, engine.getTxnManagerInjector());
        engineBuilder.addDependency(TeiidServiceNames.BUFFER_MGR, BufferManager.class, engine.getBufferManagerInjector());
        engineBuilder.addDependency(TeiidServiceNames.TRANSLATOR_REPO, TranslatorRepository.class, engine.getTranslatorRepositoryInjector());
        engineBuilder.addDependency(TeiidServiceNames.VDB_REPO, VDBRepository.class, engine.getVdbRepositoryInjector());
        engineBuilder.addDependency(TeiidServiceNames.AUTHORIZATION_VALIDATOR, AuthorizationValidator.class, engine.getAuthorizationValidatorInjector());
        engineBuilder.addDependency(TeiidServiceNames.PREPARSER, PreParser.class, engine.getPreParserInjector());
        engineBuilder.addDependency(rsCache ? ServiceBuilder.DependencyType.REQUIRED : ServiceBuilder.DependencyType.OPTIONAL, TeiidServiceNames.CACHE_RESULTSET, SessionAwareCache.class, engine.getResultSetCacheInjector());
        engineBuilder.addDependency(TeiidServiceNames.CACHE_PREPAREDPLAN, SessionAwareCache.class, engine.getPreparedPlanCacheInjector());
        engineBuilder.addDependency(TeiidServiceNames.EVENT_DISTRIBUTOR_FACTORY, InternalEventDistributorFactory.class, engine.getEventDistributorFactoryInjector());
        engineBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        engineBuilder.install();
        Environment environment = context.getCallEnvironment();
        final JBossLifeCycleListener shutdownListener = new JBossLifeCycleListener(environment);
        ReferenceFactoryService referenceFactoryService = new ReferenceFactoryService();
        ServiceName referenceFactoryServiceName = TeiidServiceNames.EVENT_DISTRIBUTOR_FACTORY.append(new String[]{"reference-factory"});
        ServiceBuilder referenceBuilder = target.addService(referenceFactoryServiceName, referenceFactoryService);
        referenceBuilder.addDependency(TeiidServiceNames.EVENT_DISTRIBUTOR_FACTORY, EventDistributorFactory.class, referenceFactoryService.getInjector());
        referenceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        String jndiName = "teiid/event-distributor-factory";
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binderService = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = target.addService(bindInfo.getBinderServiceName(), (Service)binderService);
        binderBuilder.addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, (Injector)binderService.getManagedObjectInjector());
        binderBuilder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector());
        binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        referenceBuilder.install();
        binderBuilder.install();
        LogManager.logDetail((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.getString("event_distributor_bound", new Object[]{jndiName}));
        MaterializationManagementService matviewService = new MaterializationManagementService(shutdownListener);
        ServiceBuilder matviewBuilder = target.addService(TeiidServiceNames.MATVIEW_SERVICE, (Service)matviewService);
        matviewBuilder.addDependency(TeiidServiceNames.ENGINE, DQPCore.class, matviewService.dqpInjector);
        matviewBuilder.addDependency(TeiidServiceNames.THREAD_POOL_SERVICE, Executor.class, matviewService.executorInjector);
        matviewBuilder.addDependency(TeiidServiceNames.VDB_REPO, VDBRepository.class, matviewService.vdbRepositoryInjector);
        matviewBuilder.install();
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("teiid", Phase.STRUCTURE, 65397, (DeploymentUnitProcessor)new DynamicVDBRootMountDeployer());
                processorTarget.addDeploymentProcessor("teiid", Phase.STRUCTURE, 65398, (DeploymentUnitProcessor)new VDBStructureDeployer());
                processorTarget.addDeploymentProcessor("teiid", Phase.PARSE, 2817, (DeploymentUnitProcessor)new VDBParserDeployer());
                processorTarget.addDeploymentProcessor("teiid", Phase.DEPENDENCIES, 1793, (DeploymentUnitProcessor)new VDBDependencyDeployer());
                processorTarget.addDeploymentProcessor("teiid", Phase.INSTALL, 7424, (DeploymentUnitProcessor)new VDBDeployer(translatorRepo, vdbRepository, shutdownListener));
                processorTarget.addDeploymentProcessor("teiid", Phase.STRUCTURE, 1537, (DeploymentUnitProcessor)new TranslatorStructureDeployer());
                processorTarget.addDeploymentProcessor("teiid", Phase.DEPENDENCIES, 769, (DeploymentUnitProcessor)new TranslatorDependencyDeployer());
                processorTarget.addDeploymentProcessor("teiid", Phase.INSTALL, 6145, (DeploymentUnitProcessor)new TranslatorDeployer());
            }
        }, OperationContext.Stage.RUNTIME);
        final SessionServiceImpl sessionServiceImpl = new SessionServiceImpl();
        if (TeiidConstants.isDefined(TeiidConstants.AUTHENTICATION_SECURITY_DOMAIN_ATTRIBUTE, operation, context)) {
            String securityDomain = TeiidConstants.asString(TeiidConstants.AUTHENTICATION_SECURITY_DOMAIN_ATTRIBUTE, operation, context);
            sessionServiceImpl.setSecurityDomain(securityDomain);
        }
        if (TeiidConstants.isDefined(TeiidConstants.AUTHENTICATION_MAX_SESSIONS_ALLOWED_ATTRIBUTE, operation, context)) {
            sessionServiceImpl.setSessionMaxLimit(TeiidConstants.asLong(TeiidConstants.AUTHENTICATION_MAX_SESSIONS_ALLOWED_ATTRIBUTE, operation, context).longValue());
        }
        if (TeiidConstants.isDefined(TeiidConstants.AUTHENTICATION_SESSION_EXPIRATION_TIME_LIMIT_ATTRIBUTE, operation, context)) {
            sessionServiceImpl.setSessionExpirationTimeLimit(TeiidConstants.asLong(TeiidConstants.AUTHENTICATION_SESSION_EXPIRATION_TIME_LIMIT_ATTRIBUTE, operation, context).longValue());
        }
        if (TeiidConstants.isDefined(TeiidConstants.AUTHENTICATION_TYPE_ATTRIBUTE, operation, context)) {
            sessionServiceImpl.setAuthenticationType(AuthenticationType.valueOf((String)TeiidConstants.asString(TeiidConstants.AUTHENTICATION_TYPE_ATTRIBUTE, operation, context)));
        } else {
            sessionServiceImpl.setAuthenticationType(AuthenticationType.USERPASSWORD);
        }
        if (TeiidConstants.isDefined(TeiidConstants.AUTHENTICATION_TRUST_ALL_LOCAL_ATTRIBUTE, operation, context)) {
            boolean allowUnauthenticated = TeiidConstants.asBoolean(TeiidConstants.AUTHENTICATION_TRUST_ALL_LOCAL_ATTRIBUTE, operation, context);
            sessionServiceImpl.setTrustAllLocal(allowUnauthenticated);
        }
        if (TeiidConstants.isDefined(TeiidConstants.AUTHENTICATION_ALLOW_SECURITY_DOMAIN_QUALIFIER, operation, context)) {
            boolean allowSecurityDomainQualifier = TeiidConstants.asBoolean(TeiidConstants.AUTHENTICATION_ALLOW_SECURITY_DOMAIN_QUALIFIER, operation, context);
            sessionServiceImpl.setAllowSecurityDomainQualifier(allowSecurityDomainQualifier);
        }
        sessionServiceImpl.setDqp(engine.getValue());
        sessionServiceImpl.setVDBRepository(vdbRepository);
        sessionServiceImpl.setSecurityHelper((SecurityHelper)new JBossSecurityHelper());
        sessionServiceImpl.start();
        ServiceBuilder sessionServiceBuilder = target.addService(TeiidServiceNames.SESSION, (Service)new Service<SessionService>(){

            public SessionService getValue() throws IllegalStateException, IllegalArgumentException {
                return sessionServiceImpl;
            }

            public void stop(StopContext context) {
                sessionServiceImpl.stop();
            }

            public void start(StartContext context) throws StartException {
            }
        });
        sessionServiceBuilder.install();
        RestWarGenerator warGenerator = TeiidAdd.buildService(RestWarGenerator.class, "org.jboss.teiid.rest-service");
        ResteasyEnabler restEnabler = new ResteasyEnabler(warGenerator);
        ServiceBuilder warGeneratorSvc = target.addService(TeiidServiceNames.REST_WAR_SERVICE, (Service)restEnabler);
        warGeneratorSvc.addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, restEnabler.controllerValue);
        warGeneratorSvc.addDependency(TeiidServiceNames.THREAD_POOL_SERVICE, Executor.class, restEnabler.executorInjector);
        warGeneratorSvc.addDependency(TeiidServiceNames.VDB_REPO, VDBRepository.class, restEnabler.vdbRepoInjector);
        warGeneratorSvc.install();
    }

    private void buildThreadService(int maxThreads, ServiceTarget target) {
        ThreadExecutorService service = new ThreadExecutorService(maxThreads);
        ServiceBuilder serviceBuilder = target.addService(TeiidServiceNames.THREAD_POOL_SERVICE, (Service)service);
        serviceBuilder.install();
    }

    static <T> T buildService(Class<T> type, String moduleName) throws OperationFailedException {
        Module module;
        try {
            ModuleIdentifier moduleId = ModuleIdentifier.create((String)moduleName);
            module = Module.getCallerModuleLoader().loadModule(moduleId);
        }
        catch (ModuleLoadException e) {
            throw new OperationFailedException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50069, new Object[]{moduleName}), (Throwable)e);
        }
        ServiceLoader services = module.loadService(type);
        Iterator iter = services.iterator();
        if (!iter.hasNext()) {
            throw new OperationFailedException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50089, new Object[]{type.getName(), moduleName}));
        }
        final Object instance = iter.next();
        Object proxy = Proxy.newProxyInstance(instance.getClass().getClassLoader(), new Class[]{type}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(instance.getClass().getClassLoader());
                    Object object = method.invoke(instance, args);
                    return object;
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalCL);
                }
            }
        });
        return (T)proxy;
    }

    private BufferManagerService buildBufferManager(OperationContext context, ModelNode node) throws OperationFailedException {
        BufferManagerService bufferManger = new BufferManagerService();
        if (node == null) {
            return bufferManger;
        }
        if (TeiidConstants.isDefined(TeiidConstants.USE_DISK_ATTRIBUTE, node, context)) {
            bufferManger.setUseDisk(TeiidConstants.asBoolean(TeiidConstants.USE_DISK_ATTRIBUTE, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.PROCESSOR_BATCH_SIZE_ATTRIBUTE, node, context)) {
            bufferManger.setProcessorBatchSize(TeiidConstants.asInt(TeiidConstants.PROCESSOR_BATCH_SIZE_ATTRIBUTE, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.MAX_PROCESSING_KB_ATTRIBUTE, node, context)) {
            bufferManger.setMaxProcessingKb(TeiidConstants.asInt(TeiidConstants.MAX_PROCESSING_KB_ATTRIBUTE, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.MAX_RESERVED_KB_ATTRIBUTE, node, context)) {
            bufferManger.setMaxReserveKb(TeiidConstants.asInt(TeiidConstants.MAX_RESERVED_KB_ATTRIBUTE, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.MAX_FILE_SIZE_ATTRIBUTE, node, context)) {
            bufferManger.setMaxFileSize(TeiidConstants.asLong(TeiidConstants.MAX_FILE_SIZE_ATTRIBUTE, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.MAX_BUFFER_SPACE_ATTRIBUTE, node, context)) {
            bufferManger.setMaxBufferSpace(TeiidConstants.asLong(TeiidConstants.MAX_BUFFER_SPACE_ATTRIBUTE, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.MAX_OPEN_FILES_ATTRIBUTE, node, context)) {
            bufferManger.setMaxOpenFiles(TeiidConstants.asInt(TeiidConstants.MAX_OPEN_FILES_ATTRIBUTE, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.MEMORY_BUFFER_SPACE_ATTRIBUTE, node, context)) {
            bufferManger.setMemoryBufferSpace(TeiidConstants.asInt(TeiidConstants.MEMORY_BUFFER_SPACE_ATTRIBUTE, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.MEMORY_BUFFER_OFFHEAP_ATTRIBUTE, node, context)) {
            bufferManger.setMemoryBufferOffHeap(TeiidConstants.asBoolean(TeiidConstants.MEMORY_BUFFER_OFFHEAP_ATTRIBUTE, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.MAX_STORAGE_OBJECT_SIZE_ATTRIBUTE, node, context)) {
            bufferManger.setMaxStorageObjectSize(TeiidConstants.asInt(TeiidConstants.MAX_STORAGE_OBJECT_SIZE_ATTRIBUTE, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.INLINE_LOBS, node, context)) {
            bufferManger.setInlineLobs(TeiidConstants.asBoolean(TeiidConstants.INLINE_LOBS, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.ENCRYPT_FILES_ATTRIBUTE, node, context)) {
            bufferManger.setEncryptFiles(TeiidConstants.asBoolean(TeiidConstants.ENCRYPT_FILES_ATTRIBUTE, node, context));
        }
        return bufferManger;
    }

    private DQPCoreService buildQueryEngine(OperationContext context, ModelNode node) throws OperationFailedException {
        DQPCoreService engine = new DQPCoreService();
        if (TeiidConstants.isDefined(TeiidConstants.MAX_THREADS_ELEMENT, node, context)) {
            engine.setMaxThreads(TeiidConstants.asInt(TeiidConstants.MAX_THREADS_ELEMENT, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.MAX_ACTIVE_PLANS_ELEMENT, node, context)) {
            engine.setMaxActivePlans(TeiidConstants.asInt(TeiidConstants.MAX_ACTIVE_PLANS_ELEMENT, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.USER_REQUEST_SOURCE_CONCURRENCY_ELEMENT, node, context)) {
            engine.setUserRequestSourceConcurrency(TeiidConstants.asInt(TeiidConstants.USER_REQUEST_SOURCE_CONCURRENCY_ELEMENT, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.TIME_SLICE_IN_MILLI_ELEMENT, node, context)) {
            engine.setTimeSliceInMilli(TeiidConstants.asInt(TeiidConstants.TIME_SLICE_IN_MILLI_ELEMENT, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.MAX_ROWS_FETCH_SIZE_ELEMENT, node, context)) {
            engine.setMaxRowsFetchSize(TeiidConstants.asInt(TeiidConstants.MAX_ROWS_FETCH_SIZE_ELEMENT, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.LOB_CHUNK_SIZE_IN_KB_ELEMENT, node, context)) {
            engine.setLobChunkSizeInKB(TeiidConstants.asInt(TeiidConstants.LOB_CHUNK_SIZE_IN_KB_ELEMENT, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.QUERY_THRESHOLD_IN_SECS_ELEMENT, node, context)) {
            engine.setQueryThresholdInSecs(TeiidConstants.asInt(TeiidConstants.QUERY_THRESHOLD_IN_SECS_ELEMENT, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.MAX_SOURCE_ROWS_ELEMENT, node, context)) {
            engine.setMaxSourceRows(TeiidConstants.asInt(TeiidConstants.MAX_SOURCE_ROWS_ELEMENT, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.EXCEPTION_ON_MAX_SOURCE_ROWS_ELEMENT, node, context)) {
            engine.setExceptionOnMaxSourceRows(TeiidConstants.asBoolean(TeiidConstants.EXCEPTION_ON_MAX_SOURCE_ROWS_ELEMENT, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.DETECTING_CHANGE_EVENTS_ELEMENT, node, context)) {
            engine.setDetectingChangeEvents(TeiidConstants.asBoolean(TeiidConstants.DETECTING_CHANGE_EVENTS_ELEMENT, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.QUERY_TIMEOUT, node, context)) {
            engine.setQueryTimeout(TeiidConstants.asLong(TeiidConstants.QUERY_TIMEOUT, node, context));
        }
        return engine;
    }

    private void deployResources(OperationContext context) throws OperationFailedException {
        if (this.requiresRuntime(context)) {
            try {
                String deployment;
                Module module = Module.forClass(((Object)((Object)this)).getClass());
                if (module == null) {
                    return;
                }
                URL deployments = module.getExportedResource("deployments.properties");
                if (deployments == null) {
                    return;
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(deployments.openStream()));
                while ((deployment = in.readLine()) != null) {
                    PathAddress deploymentAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment", (String)deployment)});
                    ModelNode op = new ModelNode();
                    op.get("operation").set("add");
                    op.get("address").set(deploymentAddress.toModelNode());
                    op.get("enabled").set(true);
                    op.get("persistent").set(false);
                    URL url = module.getExportedResource(deployment);
                    String urlString = url.toExternalForm();
                    ModelNode contentItem = new ModelNode();
                    contentItem.get("url").set(urlString);
                    op.get("content").add(contentItem);
                    ImmutableManagementResourceRegistration rootResourceRegistration = context.getRootResourceRegistration();
                    OperationStepHandler handler = rootResourceRegistration.getOperationHandler(deploymentAddress, "add");
                    context.addStep(op, handler, OperationContext.Stage.MODEL);
                }
                in.close();
            }
            catch (IOException e) {
                throw new OperationFailedException(e.getMessage(), (Throwable)e);
            }
        }
    }

    static class VDBStatusCheckerExecutorService
    extends VDBStatusChecker {
        final InjectedValue<Executor> executorInjector = new InjectedValue();
        final InjectedValue<VDBRepository> vdbRepoInjector = new InjectedValue();

        VDBStatusCheckerExecutorService() {
        }

        public Executor getExecutor() {
            return (Executor)this.executorInjector.getValue();
        }

        public VDBRepository getVDBRepository() {
            return (VDBRepository)this.vdbRepoInjector.getValue();
        }
    }

    static class TeiidThreadFactoryResolver
    extends ThreadFactoryResolver.SimpleResolver {
        private TeiidThreadFactoryResolver() {
            super(ThreadsServices.FACTORY);
        }

        protected String getThreadGroupName(String threadPoolName) {
            return "Teiid Async Thread";
        }
    }
}

