/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.jboss;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.adminapi.jboss.VDBMetadataMapper;
import org.teiid.translator.ExecutionFactory;

public class TestAdminObjectBuilder {
    @Test
    public void testVDB() {
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("myVDB");
        vdb.setDescription("vdb description");
        vdb.setVersion(1);
        vdb.addProperty("vdb-property", "vdb-value");
        ModelMetaData modelOne = new ModelMetaData();
        modelOne.setName("model-one");
        modelOne.addSourceMapping("s1", "translator", "java:mybinding");
        modelOne.setModelType(Model.Type.PHYSICAL);
        modelOne.addProperty("model-prop", "model-value");
        modelOne.addProperty("model-prop", "model-value-override");
        modelOne.setVisible(false);
        modelOne.addMessage("ERROR", "There is an error in VDB");
        modelOne.setDescription("model description");
        vdb.addModel(modelOne);
        ModelMetaData modelTwo = new ModelMetaData();
        modelTwo.setName("model-two");
        modelTwo.addSourceMapping("s1", "translator", "java:binding-one");
        modelTwo.addSourceMapping("s2", "translator", "java:binding-two");
        modelTwo.setModelType(Model.Type.VIRTUAL);
        modelTwo.addProperty("model-prop", "model-value");
        vdb.addModel(modelTwo);
        VDBTranslatorMetaData t1 = new VDBTranslatorMetaData();
        t1.setName("oracleOverride");
        t1.setType("oracle");
        t1.addProperty("my-property", "my-value");
        ArrayList<VDBTranslatorMetaData> list = new ArrayList<VDBTranslatorMetaData>();
        list.add(t1);
        vdb.setOverrideTranslators(list);
        DataPolicyMetadata roleOne = new DataPolicyMetadata();
        roleOne.setName("roleOne");
        roleOne.setDescription("roleOne described");
        DataPolicyMetadata.PermissionMetaData perm1 = new DataPolicyMetadata.PermissionMetaData();
        perm1.setResourceName("myTable.T1");
        perm1.setAllowRead(Boolean.valueOf(true));
        roleOne.addPermission(new DataPolicyMetadata.PermissionMetaData[]{perm1});
        DataPolicyMetadata.PermissionMetaData perm2 = new DataPolicyMetadata.PermissionMetaData();
        perm2.setResourceName("myTable.T2");
        perm2.setAllowRead(Boolean.valueOf(false));
        perm2.setAllowDelete(Boolean.valueOf(true));
        roleOne.addPermission(new DataPolicyMetadata.PermissionMetaData[]{perm2});
        roleOne.setMappedRoleNames(Arrays.asList("ROLE1", "ROLE2"));
        vdb.addDataPolicy(roleOne);
        ModelNode node = VDBMetadataMapper.INSTANCE.wrap(vdb, new ModelNode());
        vdb = VDBMetadataMapper.INSTANCE.unwrap(node);
        Assert.assertEquals((Object)"myVDB", (Object)vdb.getName());
        Assert.assertEquals((Object)"vdb description", (Object)vdb.getDescription());
        Assert.assertEquals((Object)"1", (Object)vdb.getVersion());
        Assert.assertEquals((Object)"vdb-value", (Object)vdb.getPropertyValue("vdb-property"));
        Assert.assertNotNull((Object)vdb.getModel("model-one"));
        Assert.assertNotNull((Object)vdb.getModel("model-two"));
        Assert.assertNull((Object)vdb.getModel("model-unknown"));
        modelOne = vdb.getModel("model-one");
        Assert.assertEquals((Object)"model-one", (Object)modelOne.getName());
        Assert.assertEquals((Object)"s1", modelOne.getSourceNames().get(0));
        Assert.assertEquals((Object)Model.Type.PHYSICAL, (Object)modelOne.getModelType());
        Assert.assertEquals((Object)"model-value-override", (Object)modelOne.getPropertyValue("model-prop"));
        Assert.assertFalse((boolean)modelOne.isVisible());
        Assert.assertEquals((Object)"model description", (Object)modelOne.getDescription());
        modelTwo = vdb.getModel("model-two");
        Assert.assertEquals((Object)"model-two", (Object)modelTwo.getName());
        Assert.assertTrue((boolean)modelTwo.getSourceNames().contains("s1"));
        Assert.assertTrue((boolean)modelTwo.getSourceNames().contains("s2"));
        Assert.assertEquals((Object)Model.Type.VIRTUAL, (Object)modelTwo.getModelType());
        Assert.assertEquals((Object)"model-value", (Object)modelTwo.getPropertyValue("model-prop"));
        Assert.assertTrue((boolean)vdb.getValidityErrors().contains("There is an error in VDB"));
        List translators = vdb.getOverrideTranslators();
        Assert.assertTrue((translators.size() == 1 ? 1 : 0) != 0);
        Translator translator = (Translator)translators.get(0);
        Assert.assertEquals((Object)"oracleOverride", (Object)translator.getName());
        Assert.assertEquals((Object)"oracle", (Object)translator.getType());
        Assert.assertEquals((Object)"my-value", (Object)translator.getPropertyValue("my-property"));
        List roles = vdb.getDataPolicies();
        Assert.assertTrue((roles.size() == 1 ? 1 : 0) != 0);
        DataPolicyMetadata role = (DataPolicyMetadata)vdb.getDataPolicyMap().get("roleOne");
        Assert.assertEquals((Object)"roleOne described", (Object)role.getDescription());
        Assert.assertNotNull((Object)role.getMappedRoleNames());
        Assert.assertTrue((boolean)role.getMappedRoleNames().contains("ROLE1"));
        Assert.assertTrue((boolean)role.getMappedRoleNames().contains("ROLE2"));
        List permissions = role.getPermissions();
        Assert.assertEquals((long)2L, (long)permissions.size());
        for (DataPolicy.DataPermission p : permissions) {
            if (p.getResourceName().equalsIgnoreCase("myTable.T1")) {
                Assert.assertTrue((boolean)p.getAllowRead());
                Assert.assertNull((Object)p.getAllowDelete());
                continue;
            }
            Assert.assertFalse((boolean)p.getAllowRead());
            Assert.assertTrue((boolean)p.getAllowDelete());
        }
    }

    @Test
    public void testTranslator() {
        VDBTranslatorMetaData tm = new VDBTranslatorMetaData();
        tm.setExecutionFactoryClass(ExecutionFactory.class);
        tm.setName("Oracle");
        tm.addProperty("ExtensionTranslationClassName", "org.teiid.translator.jdbc.oracle.OracleSQLTranslator");
        ModelNode node = VDBMetadataMapper.VDBTranslatorMetaDataMapper.INSTANCE.wrap(tm, new ModelNode());
        VDBTranslatorMetaData tm1 = VDBMetadataMapper.VDBTranslatorMetaDataMapper.INSTANCE.unwrap(node);
        Assert.assertEquals((Object)"Oracle", (Object)tm1.getName());
        Assert.assertEquals((Object)ExecutionFactory.class.getName(), (Object)tm1.getPropertyValue("execution-factory-class"));
        Assert.assertEquals((Object)"org.teiid.translator.jdbc.oracle.OracleSQLTranslator", (Object)tm1.getPropertyValue("ExtensionTranslationClassName"));
    }
}

