/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.VDBRepository;
import org.teiid.jboss.BaseOperationHandler;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.OperationsConstants;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.metadata.Database;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.DatabaseUtil;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.runtime.EmbeddedAdminImpl;

class GetSchema
extends BaseOperationHandler<VDBRepository> {
    protected GetSchema() {
        super("get-schema", true);
    }

    @Override
    protected VDBRepository getService(OperationContext context, PathAddress pathAddress, ModelNode operation) throws OperationFailedException {
        ServiceController sc = context.getServiceRegistry(this.isChangesRuntimes()).getRequiredService(TeiidServiceNames.VDB_REPO);
        return (VDBRepository)VDBRepository.class.cast(sc.getValue());
    }

    @Override
    protected void executeOperation(OperationContext context, VDBRepository repo, ModelNode operation) throws OperationFailedException {
        String vdbVersion;
        if (!operation.hasDefined(OperationsConstants.VDB_NAME.getName())) {
            throw new OperationFailedException(IntegrationPlugin.Util.getString(OperationsConstants.VDB_NAME.getName() + ".missing"));
        }
        if (!operation.hasDefined(OperationsConstants.VDB_VERSION.getName())) {
            throw new OperationFailedException(IntegrationPlugin.Util.getString(OperationsConstants.VDB_VERSION.getName() + ".missing"));
        }
        String modelName = null;
        if (operation.hasDefined(OperationsConstants.MODEL_NAME.getName())) {
            modelName = operation.get(OperationsConstants.MODEL_NAME.getName()).asString();
        }
        Admin.ExportFormat format = Admin.ExportFormat.XML;
        if (operation.hasDefined(OperationsConstants.FORMAT.getName())) {
            format = Admin.ExportFormat.valueOf((String)operation.get(OperationsConstants.FORMAT.getName()).asString());
        }
        ModelNode result = context.getResult();
        String vdbName = operation.get(OperationsConstants.VDB_NAME.getName()).asString();
        VDBMetaData vdb = repo.getLiveVDB(vdbName, (Object)(vdbVersion = operation.get(OperationsConstants.VDB_VERSION.getName()).asString()));
        if (vdb == null || vdb.getStatus() != VDB.Status.ACTIVE) {
            throw new OperationFailedException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50096, new Object[]{vdbName, vdbVersion}));
        }
        EnumSet<Admin.SchemaObjectType> schemaTypes = null;
        if (modelName != null && vdb.getModel(modelName) == null) {
            throw new OperationFailedException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50097, new Object[]{vdbName, vdbVersion, modelName}));
        }
        if (operation.hasDefined(OperationsConstants.ENTITY_TYPE.getName())) {
            String[] types = operation.get(OperationsConstants.ENTITY_TYPE.getName()).asString().toUpperCase().split(",");
            if (types.length > 0) {
                ArrayList<Admin.SchemaObjectType> sot = new ArrayList<Admin.SchemaObjectType>();
                for (int i = 1; i < types.length; ++i) {
                    sot.add(Admin.SchemaObjectType.valueOf((String)types[i]));
                }
                schemaTypes = EnumSet.of(Admin.SchemaObjectType.valueOf((String)types[0]), (Enum[])sot.toArray(new Admin.SchemaObjectType[sot.size()]));
            } else {
                schemaTypes = EnumSet.of(Admin.SchemaObjectType.valueOf((String)types[0]));
            }
        }
        String regEx = null;
        if (operation.hasDefined(OperationsConstants.ENTITY_PATTERN.getName())) {
            regEx = operation.get(OperationsConstants.ENTITY_PATTERN.getName()).asString();
        }
        CompositeMetadataStore metadataStore = ((TransformationMetadata)vdb.getAttachment(TransformationMetadata.class)).getMetadataStore();
        if (modelName != null) {
            Schema schema = metadataStore.getSchema(modelName);
            String ddl = DDLStringVisitor.getDDLString((Schema)schema, schemaTypes, (String)regEx);
            result.set(ddl);
        } else if (format == Admin.ExportFormat.XML) {
            for (ModelMetaData m : vdb.getModelMetaDatas().values()) {
                Schema schema = metadataStore.getSchema(m.getName());
                String ddl = DDLStringVisitor.getDDLString((Schema)schema, schemaTypes, (String)regEx);
                m.addSourceMetadata("DDL", ddl);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                VDBMetadataParser.marshell((VDBMetaData)vdb, (OutputStream)out);
                String xml = EmbeddedAdminImpl.prettyFormat((String)new String(out.toByteArray()));
                result.set(xml);
            }
            catch (IOException | XMLStreamException | TransformerException e) {
                throw new OperationFailedException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50114, new Object[]{e, vdbName, vdbVersion}));
            }
        } else {
            Database db = DatabaseUtil.convert((VDBMetaData)vdb, (MetadataStore)metadataStore);
            String ddl = DDLStringVisitor.getDDLString((Database)db);
            result.set(ddl);
        }
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        builder.addParameter((AttributeDefinition)OperationsConstants.VDB_NAME);
        builder.addParameter((AttributeDefinition)OperationsConstants.VDB_VERSION);
        builder.addParameter((AttributeDefinition)OperationsConstants.MODEL_NAME);
        builder.addParameter((AttributeDefinition)OperationsConstants.ENTITY_TYPE);
        builder.addParameter((AttributeDefinition)OperationsConstants.ENTITY_PATTERN);
        builder.addParameter((AttributeDefinition)OperationsConstants.FORMAT);
        builder.setReplyType(ModelType.STRING);
    }
}

