/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.jboss.logging.Logger;
import org.jboss.security.negotiation.Constants;

class GSSUtil {
    private static final Logger log = Logger.getLogger(GSSUtil.class);
    private static final Method CREATE_SUBJECT_METHOD = GSSUtil.getCreateSubjectMethod();
    private static final String SUN_GSSUTIL = "com.sun.security.jgss.GSSUtil";
    private static final String CREATE_SUBJECT = "createSubject";

    GSSUtil() {
    }

    static Subject createGssSubject(GSSCredential delegatedCredential, GSSCredential privateCredential) throws LoginException {
        Subject intermediateSubject = null;
        if (CREATE_SUBJECT_METHOD != null) {
            try {
                GSSName name = delegatedCredential.getName(Constants.KERBEROS_V5);
                intermediateSubject = GSSUtil.invokeCreateSubject(CREATE_SUBJECT_METHOD, name, delegatedCredential);
                log.trace((Object)"Delegated credential converted to Subject.");
            }
            catch (GSSException e) {
                log.debug((Object)e);
                throw new LoginException("Unable to use supplied GSSCredential to populate Subject.");
            }
        } else if (privateCredential == null) {
            throw new LoginException("Utility not available to convert from GSSCredential and adding GSSCredential to Subject disabled - this would just result in an empty Subject!");
        }
        return intermediateSubject;
    }

    static Method createSubjectMethod() {
        try {
            Class<?> sunGssUtil = GSSUtil.class.getClassLoader().loadClass(SUN_GSSUTIL);
            return sunGssUtil.getMethod(CREATE_SUBJECT, GSSName.class, GSSCredential.class);
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)e);
            return null;
        }
        catch (NoSuchMethodException e) {
            log.debug((Object)e);
            return null;
        }
        catch (SecurityException e) {
            log.debug((Object)e);
            return null;
        }
    }

    static Method getCreateSubjectMethod() {
        if (System.getSecurityManager() == null) {
            return GSSUtil.createSubjectMethod();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                return GSSUtil.createSubjectMethod();
            }
        });
    }

    static Subject invokeCreateSubject(Method createSubjectMethod, GSSName gssName, GSSCredential gssCredential) throws GSSException {
        try {
            return (Subject)createSubjectMethod.invoke(null, gssName, gssCredential);
        }
        catch (IllegalAccessException e) {
            log.debug((Object)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            log.debug((Object)e);
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof GSSException) {
                throw (GSSException)cause;
            }
            log.debug((Object)cause);
            return null;
        }
    }

    static Subject createSubjectMethod(final Method createSubjectMethod, final GSSName gssName, final GSSCredential gssCredential) throws GSSException {
        if (System.getSecurityManager() == null) {
            return GSSUtil.invokeCreateSubject(createSubjectMethod, gssName, gssCredential);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Subject>(){

                @Override
                public Subject run() throws Exception {
                    return GSSUtil.invokeCreateSubject(createSubjectMethod, gssName, gssCredential);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (GSSException)e.getCause();
        }
    }
}

